/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.slimjar.relocation.facade;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import me.glaremasters.guilds.libs.slimjar.app.builder.ApplicationBuilder;
import me.glaremasters.guilds.libs.slimjar.injector.loader.InjectableClassLoader;
import me.glaremasters.guilds.libs.slimjar.injector.loader.IsolatedInjectableClassLoader;
import me.glaremasters.guilds.libs.slimjar.relocation.PassthroughRelocator;
import me.glaremasters.guilds.libs.slimjar.relocation.RelocationRule;
import me.glaremasters.guilds.libs.slimjar.relocation.facade.JarRelocatorFacade;
import me.glaremasters.guilds.libs.slimjar.relocation.facade.JarRelocatorFacadeFactory;
import me.glaremasters.guilds.libs.slimjar.relocation.facade.ReflectiveJarRelocatorFacade;
import me.glaremasters.guilds.libs.slimjar.resolver.data.Dependency;
import me.glaremasters.guilds.libs.slimjar.resolver.data.DependencyData;
import me.glaremasters.guilds.libs.slimjar.resolver.data.Repository;
import me.glaremasters.guilds.libs.slimjar.util.Packages;

public final class ReflectiveJarRelocatorFacadeFactory
implements JarRelocatorFacadeFactory {
    private static final String JAR_RELOCATOR_PACKAGE = "me#lucko#jarrelocator#JarRelocator";
    private static final String RELOCATION_PACKAGE = "me#lucko#jarrelocator#Relocation";
    private final Constructor<?> jarRelocatorConstructor;
    private final Constructor<?> relocationConstructor;
    private final Method jarRelocatorRunMethod;

    private ReflectiveJarRelocatorFacadeFactory(Constructor<?> constructor, Constructor<?> constructor2, Method method) {
        this.jarRelocatorConstructor = constructor;
        this.relocationConstructor = constructor2;
        this.jarRelocatorRunMethod = method;
    }

    @Override
    public JarRelocatorFacade createFacade(File file, File file2, Collection<RelocationRule> collection) {
        HashSet<Object> hashSet = new HashSet<Object>();
        for (RelocationRule relocationRule : collection) {
            hashSet.add(ReflectiveJarRelocatorFacadeFactory.createRelocation(this.relocationConstructor, relocationRule));
        }
        Object object = ReflectiveJarRelocatorFacadeFactory.createRelocator(this.jarRelocatorConstructor, file, file2, hashSet);
        return new ReflectiveJarRelocatorFacade(object, this.jarRelocatorRunMethod);
    }

    private static Object createRelocation(Constructor<?> constructor, RelocationRule relocationRule) {
        return constructor.newInstance(relocationRule.getOriginalPackagePattern(), relocationRule.getRelocatedPackagePattern(), relocationRule.getExclusions(), relocationRule.getInclusions());
    }

    private static Object createRelocator(Constructor<?> constructor, File file, File file2, Collection<Object> collection) {
        return constructor.newInstance(file, file2, collection);
    }

    private static DependencyData getJarRelocatorDependency(Collection<Repository> collection) {
        Dependency dependency = new Dependency(Packages.fix("org#ow2#asm"), "asm", "9.1", null, Collections.emptyList());
        Dependency dependency2 = new Dependency(Packages.fix("org#ow2#asm"), "asm-commons", "9.1", null, Collections.emptyList());
        Dependency dependency3 = new Dependency(Packages.fix("me#lucko"), "jar-relocator", "1.4", null, Arrays.asList(dependency, dependency2));
        return new DependencyData(Collections.emptySet(), collection, Collections.singleton(dependency3), Collections.emptyList());
    }

    public static JarRelocatorFacadeFactory create(Path path, Collection<Repository> collection) {
        IsolatedInjectableClassLoader isolatedInjectableClassLoader = new IsolatedInjectableClassLoader();
        return ReflectiveJarRelocatorFacadeFactory.create(path, collection, isolatedInjectableClassLoader);
    }

    public static JarRelocatorFacadeFactory create(Path path, Collection<Repository> collection2, InjectableClassLoader injectableClassLoader) {
        ApplicationBuilder.injecting("SlimJar", injectableClassLoader).downloadDirectoryPath(path).preResolutionDataProviderFactory(uRL -> Collections::emptyMap).dataProviderFactory(uRL -> () -> ReflectiveJarRelocatorFacadeFactory.getJarRelocatorDependency(collection2)).relocatorFactory(collection -> new PassthroughRelocator()).relocationHelperFactory(relocator -> (dependency, file) -> file).build();
        Class<?> clazz = Class.forName(Packages.fix(JAR_RELOCATOR_PACKAGE), true, injectableClassLoader);
        Class<?> clazz2 = Class.forName(Packages.fix(RELOCATION_PACKAGE), true, injectableClassLoader);
        Constructor<?> constructor = clazz.getConstructor(File.class, File.class, Collection.class);
        Constructor<?> constructor2 = clazz2.getConstructor(String.class, String.class, Collection.class, Collection.class);
        Method method = clazz.getMethod("run", new Class[0]);
        return new ReflectiveJarRelocatorFacadeFactory(constructor, constructor2, method);
    }
}

