/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.slimjar.relocation.helper;

import java.io.File;
import me.glaremasters.guilds.libs.slimjar.downloader.strategy.FilePathStrategy;
import me.glaremasters.guilds.libs.slimjar.relocation.Relocator;
import me.glaremasters.guilds.libs.slimjar.relocation.helper.RelocationHelper;
import me.glaremasters.guilds.libs.slimjar.relocation.meta.MetaMediator;
import me.glaremasters.guilds.libs.slimjar.relocation.meta.MetaMediatorFactory;
import me.glaremasters.guilds.libs.slimjar.resolver.data.Dependency;

public final class VerifyingRelocationHelper
implements RelocationHelper {
    private final FilePathStrategy outputFilePathStrategy;
    private final Relocator relocator;
    private final String selfHash;
    private final MetaMediatorFactory mediatorFactory;

    public VerifyingRelocationHelper(String string, FilePathStrategy filePathStrategy, Relocator relocator, MetaMediatorFactory metaMediatorFactory) {
        this.mediatorFactory = metaMediatorFactory;
        this.outputFilePathStrategy = filePathStrategy;
        this.relocator = relocator;
        this.selfHash = string;
    }

    @Override
    public File relocate(Dependency dependency, File file) {
        File file2 = this.outputFilePathStrategy.selectFileFor(dependency);
        MetaMediator metaMediator = this.mediatorFactory.create(file2.toPath());
        if (file2.exists()) {
            try {
                String string = metaMediator.readAttribute("slimjar.owner");
                if (this.selfHash != null && string != null && this.selfHash.trim().equals(string.trim())) {
                    return file2;
                }
            }
            catch (Exception exception) {
                file2.delete();
            }
        }
        this.relocator.relocate(file, file2);
        metaMediator.writeAttribute("slimjar.owner", this.selfHash);
        return file2;
    }
}

