/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.slimjar.resolver.data;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import me.glaremasters.guilds.libs.slimjar.relocation.RelocationRule;
import me.glaremasters.guilds.libs.slimjar.resolver.data.Dependency;
import me.glaremasters.guilds.libs.slimjar.resolver.data.Mirror;
import me.glaremasters.guilds.libs.slimjar.resolver.data.Repository;

public final class DependencyData {
    private final Collection<Mirror> mirrors;
    private final Collection<Repository> repositories;
    private final Collection<Dependency> dependencies;
    private final Collection<RelocationRule> relocations;

    public DependencyData(Collection<Mirror> collection, Collection<Repository> collection2, Collection<Dependency> collection3, Collection<RelocationRule> collection4) {
        this.mirrors = Collections.unmodifiableCollection(collection);
        this.repositories = Collections.unmodifiableCollection(collection2);
        this.dependencies = Collections.unmodifiableCollection(collection3);
        this.relocations = Collections.unmodifiableCollection(collection4);
    }

    public Collection<Repository> getRepositories() {
        return this.repositories;
    }

    public Collection<Dependency> getDependencies() {
        return this.dependencies;
    }

    public Collection<RelocationRule> getRelocations() {
        return this.relocations;
    }

    public Collection<Mirror> getMirrors() {
        return this.mirrors;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        DependencyData dependencyData = (DependencyData)object;
        return this.isCollectionEqual(this.repositories, dependencyData.repositories) && this.isCollectionEqual(this.dependencies, dependencyData.dependencies) && this.isCollectionEqual(this.relocations, dependencyData.relocations);
    }

    private <T> boolean isCollectionEqual(Collection<T> collection, Collection<T> collection2) {
        return collection.containsAll(collection2) && collection2.containsAll(collection);
    }

    public int hashCode() {
        return Objects.hash(this.repositories, this.dependencies, this.relocations);
    }

    public String toString() {
        return "DependencyData{mirrors=" + this.mirrors + ", repositories=" + this.repositories + ", dependencies=" + this.dependencies + ", relocations=" + this.relocations + '}';
    }
}

