/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.slimjar.resolver.reader.facade;

import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import me.glaremasters.guilds.libs.slimjar.app.builder.ApplicationBuilder;
import me.glaremasters.guilds.libs.slimjar.injector.loader.InjectableClassLoader;
import me.glaremasters.guilds.libs.slimjar.injector.loader.IsolatedInjectableClassLoader;
import me.glaremasters.guilds.libs.slimjar.relocation.PassthroughRelocator;
import me.glaremasters.guilds.libs.slimjar.resolver.data.Dependency;
import me.glaremasters.guilds.libs.slimjar.resolver.data.DependencyData;
import me.glaremasters.guilds.libs.slimjar.resolver.data.Repository;
import me.glaremasters.guilds.libs.slimjar.resolver.reader.facade.GsonFacade;
import me.glaremasters.guilds.libs.slimjar.resolver.reader.facade.GsonFacadeFactory;
import me.glaremasters.guilds.libs.slimjar.resolver.reader.facade.ReflectiveGsonFacade;
import me.glaremasters.guilds.libs.slimjar.util.Packages;

public final class ReflectiveGsonFacadeFactory
implements GsonFacadeFactory {
    private static final String GSON_PACKAGE = "com#google#gson#Gson";
    private static final String GSON_TYPES_PACKAGE = "com#google#gson#internal#$Gson$Types";
    private final Constructor<?> gsonConstructor;
    private final Method gsonFromJsonMethod;
    private final Method gsonFromJsonTypeMethod;
    private final Method canonicalizeMethod;

    private ReflectiveGsonFacadeFactory(Constructor<?> constructor, Method method, Method method2, Method method3) {
        this.gsonConstructor = constructor;
        this.gsonFromJsonMethod = method;
        this.gsonFromJsonTypeMethod = method2;
        this.canonicalizeMethod = method3;
    }

    @Override
    public GsonFacade createFacade() {
        Object obj = this.gsonConstructor.newInstance(new Object[0]);
        return new ReflectiveGsonFacade(obj, this.gsonFromJsonMethod, this.gsonFromJsonTypeMethod, this.canonicalizeMethod);
    }

    public static GsonFacadeFactory create(Path path, Collection<Repository> collection) {
        IsolatedInjectableClassLoader isolatedInjectableClassLoader = new IsolatedInjectableClassLoader();
        return ReflectiveGsonFacadeFactory.create(path, collection, isolatedInjectableClassLoader);
    }

    public static GsonFacadeFactory create(Path path, Collection<Repository> collection2, InjectableClassLoader injectableClassLoader) {
        ApplicationBuilder.injecting("SlimJar", injectableClassLoader).downloadDirectoryPath(path).dataProviderFactory(uRL -> () -> ReflectiveGsonFacadeFactory.getGsonDependency(collection2)).relocatorFactory(collection -> new PassthroughRelocator()).preResolutionDataProviderFactory(uRL -> Collections::emptyMap).relocationHelperFactory(relocator -> (dependency, file) -> file).build();
        Class<?> clazz = Class.forName(Packages.fix(GSON_PACKAGE), true, injectableClassLoader);
        Constructor<?> constructor = clazz.getConstructor(new Class[0]);
        Method method = clazz.getMethod("fromJson", Reader.class, Class.class);
        Method method2 = clazz.getMethod("fromJson", Reader.class, Type.class);
        Class<?> clazz2 = Class.forName(Packages.fix(GSON_TYPES_PACKAGE), true, injectableClassLoader);
        Method method3 = clazz2.getMethod("canonicalize", Type.class);
        return new ReflectiveGsonFacadeFactory(constructor, method, method2, method3);
    }

    private static DependencyData getGsonDependency(Collection<Repository> collection) {
        Dependency dependency = new Dependency(Packages.fix("com#google#code#gson"), "gson", "2.8.6", null, Collections.emptyList());
        return new DependencyData(Collections.emptySet(), collection, Collections.singleton(dependency), Collections.emptyList());
    }
}

