/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.slimjar.resolver.strategy;

import java.util.Collection;
import java.util.Locale;
import java.util.stream.Collectors;
import me.glaremasters.guilds.libs.slimjar.resolver.data.Dependency;
import me.glaremasters.guilds.libs.slimjar.resolver.data.Repository;
import me.glaremasters.guilds.libs.slimjar.resolver.strategy.PathResolutionStrategy;

public final class MavenChecksumPathResolutionStrategy
implements PathResolutionStrategy {
    private final PathResolutionStrategy resolutionStrategy;
    private final String algorithm;

    public MavenChecksumPathResolutionStrategy(String string, PathResolutionStrategy pathResolutionStrategy) {
        this.algorithm = string.replaceAll("[ -]", "").toLowerCase(Locale.ENGLISH);
        this.resolutionStrategy = pathResolutionStrategy;
    }

    @Override
    public Collection<String> pathTo(Repository repository, Dependency dependency) {
        return this.resolutionStrategy.pathTo(repository, dependency).stream().map(string -> string + "." + this.algorithm).collect(Collectors.toSet());
    }
}

