/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.taskchain;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import me.glaremasters.guilds.libs.taskchain.AsyncQueue;

public class TaskChainAsyncQueue
implements AsyncQueue {
    private static final AtomicInteger threadId = new AtomicInteger();
    private final ThreadPoolExecutor executor;

    public TaskChainAsyncQueue() {
        this.executor = TaskChainAsyncQueue.createCachedThreadPool();
    }

    public TaskChainAsyncQueue(ThreadPoolExecutor threadPoolExecutor) {
        this.executor = threadPoolExecutor;
    }

    public static ThreadPoolExecutor createCachedThreadPool() {
        return (ThreadPoolExecutor)Executors.newCachedThreadPool(runnable -> {
            Thread thread = new Thread(runnable);
            thread.setName("TaskChainAsyncQueue Thread " + threadId.getAndIncrement());
            return thread;
        });
    }

    @Override
    public void postAsync(Runnable runnable) {
        this.executor.submit(runnable);
    }

    @Override
    public void shutdown(int n, TimeUnit timeUnit) {
        try {
            this.executor.setRejectedExecutionHandler((runnable, threadPoolExecutor) -> runnable.run());
            this.executor.shutdown();
            this.executor.awaitTermination(n, timeUnit);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }
}

