/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.listeners;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import me.glaremasters.guilds.challenges.ChallengeHandler;
import me.glaremasters.guilds.configuration.sections.GuildSettings;
import me.glaremasters.guilds.guild.Guild;
import me.glaremasters.guilds.guild.GuildChallenge;
import me.glaremasters.guilds.guild.GuildHandler;
import me.glaremasters.guilds.libs.configme.SettingsManager;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class EntityListener
implements Listener {
    private final GuildHandler guildHandler;
    private final SettingsManager settingsManager;
    private final ChallengeHandler challengeHandler;
    private final Set<PotionEffectType> bad = new HashSet<PotionEffectType>(Arrays.asList(PotionEffectType.BLINDNESS, PotionEffectType.WITHER, PotionEffectType.SLOW_DIGGING, PotionEffectType.WEAKNESS, PotionEffectType.SLOW, PotionEffectType.POISON));

    public EntityListener(GuildHandler guildHandler, SettingsManager settingsManager, ChallengeHandler challengeHandler) {
        this.guildHandler = guildHandler;
        this.settingsManager = settingsManager;
        this.challengeHandler = challengeHandler;
    }

    @EventHandler
    public void onMobDamage(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (entityDamageByEntityEvent.isCancelled()) {
            return;
        }
        Entity entity = entityDamageByEntityEvent.getDamager();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        Guild guild = this.guildHandler.getGuild((OfflinePlayer)player);
        if (guild == null) {
            return;
        }
        double d = entityDamageByEntityEvent.getDamage();
        double d2 = guild.getTier().getDamageMultiplier();
        entityDamageByEntityEvent.setDamage(d * d2);
    }

    public void onMobDeath(EntityDeathEvent entityDeathEvent) {
        if (!(entityDeathEvent.getEntity() instanceof Monster)) {
            return;
        }
        Player player = entityDeathEvent.getEntity().getKiller();
        if (player == null) {
            return;
        }
        Guild guild = this.guildHandler.getGuild((OfflinePlayer)player);
        if (guild == null) {
            return;
        }
        double d = entityDeathEvent.getDroppedExp();
        double d2 = guild.getTier().getMobXpMultiplier();
        entityDeathEvent.setDroppedExp((int)Math.round(d * d2));
    }

    @EventHandler
    public void onEntityDamage(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        Player player;
        if (entityDamageByEntityEvent.isCancelled()) {
            return;
        }
        if (!(entityDamageByEntityEvent.getEntity() instanceof Player) || !(entityDamageByEntityEvent.getDamager() instanceof Player)) {
            return;
        }
        Player player2 = (Player)entityDamageByEntityEvent.getEntity();
        if (this.guildHandler.isSameGuild(player2, player = (Player)entityDamageByEntityEvent.getDamager()) && !player2.hasPermission("guilds.ffa.guild")) {
            entityDamageByEntityEvent.setCancelled(this.settingsManager.getProperty(GuildSettings.GUILD_DAMAGE) == false);
            return;
        }
        GuildChallenge guildChallenge = this.challengeHandler.getChallenge(player2);
        if (guildChallenge != null && guildChallenge.isStarted()) {
            return;
        }
        if (this.guildHandler.isAlly(player2, player) && !player2.hasPermission("guilds.ffa.ally")) {
            entityDamageByEntityEvent.setCancelled(this.settingsManager.getProperty(GuildSettings.ALLY_DAMAGE) == false);
        }
    }

    @EventHandler
    public void onDamage(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        Player player;
        if (entityDamageByEntityEvent.isCancelled()) {
            return;
        }
        if (!(entityDamageByEntityEvent.getEntity() instanceof Player) || !(entityDamageByEntityEvent.getDamager() instanceof Projectile)) {
            return;
        }
        Projectile projectile = (Projectile)entityDamageByEntityEvent.getDamager();
        if (!(projectile.getShooter() instanceof Player)) {
            return;
        }
        Player player2 = (Player)entityDamageByEntityEvent.getEntity();
        if (this.guildHandler.isSameGuild(player2, player = (Player)projectile.getShooter()) && player2 != player && !player2.hasPermission("guilds.ffa.guild")) {
            entityDamageByEntityEvent.setCancelled(this.settingsManager.getProperty(GuildSettings.GUILD_DAMAGE) == false);
            return;
        }
        if (this.guildHandler.isAlly(player2, player) && !player2.hasPermission("guilds.ffa.ally")) {
            entityDamageByEntityEvent.setCancelled(this.settingsManager.getProperty(GuildSettings.ALLY_DAMAGE) == false);
        }
    }

    @EventHandler
    public void onFlameArrow(EntityCombustByEntityEvent entityCombustByEntityEvent) {
        Player player;
        if (entityCombustByEntityEvent.isCancelled() || !(entityCombustByEntityEvent.getEntity() instanceof Player) || !(entityCombustByEntityEvent.getCombuster() instanceof Arrow)) {
            return;
        }
        Arrow arrow = (Arrow)entityCombustByEntityEvent.getCombuster();
        if (!(arrow.getShooter() instanceof Player)) {
            return;
        }
        Player player2 = (Player)entityCombustByEntityEvent.getEntity();
        if (this.guildHandler.isSameGuild(player2, player = (Player)arrow.getShooter()) && !player2.hasPermission("guilds.ffa.guild")) {
            arrow.setFireTicks(0);
            entityCombustByEntityEvent.setCancelled(this.settingsManager.getProperty(GuildSettings.GUILD_DAMAGE) == false);
            return;
        }
        if (this.guildHandler.isAlly(player2, player) && !player2.hasPermission("guilds.ffa.ally")) {
            arrow.setFireTicks(0);
            entityCombustByEntityEvent.setCancelled(this.settingsManager.getProperty(GuildSettings.ALLY_DAMAGE) == false);
        }
    }

    @EventHandler
    public void onSplash(PotionSplashEvent potionSplashEvent) {
        if (potionSplashEvent.isCancelled()) {
            return;
        }
        boolean bl = this.isHarmfulPotion(potionSplashEvent.getPotion());
        if (!bl) {
            return;
        }
        ThrownPotion thrownPotion = potionSplashEvent.getPotion();
        if (!(thrownPotion.getShooter() instanceof Player)) {
            return;
        }
        Player player = (Player)thrownPotion.getShooter();
        this.handleSplashDamage(player, potionSplashEvent);
    }

    private boolean isHarmfulPotion(ThrownPotion thrownPotion) {
        for (PotionEffect potionEffect : thrownPotion.getEffects()) {
            if (!this.bad.contains(potionEffect.getType())) continue;
            return true;
        }
        return false;
    }

    private void handleSplashDamage(Player player, PotionSplashEvent potionSplashEvent) {
        for (LivingEntity livingEntity : potionSplashEvent.getAffectedEntities()) {
            if (!(livingEntity instanceof Player)) continue;
            Player player2 = (Player)livingEntity;
            if (this.guildHandler.isSameGuild(player, player2) && player != player2 && !player.hasPermission("guilds.ffa.guild")) {
                potionSplashEvent.setCancelled(this.settingsManager.getProperty(GuildSettings.GUILD_DAMAGE) == false);
                return;
            }
            if (!this.guildHandler.isAlly(player, player2) || player.hasPermission("guilds.ffa.ally")) continue;
            potionSplashEvent.setCancelled(this.settingsManager.getProperty(GuildSettings.ALLY_DAMAGE) == false);
        }
    }
}

