/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.utils;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class ItemBuilder {
    private final ItemStack item;
    private final ItemMeta meta;

    public ItemBuilder(@NotNull ItemStack itemStack) {
        this.item = itemStack;
        this.meta = itemStack.getItemMeta();
        Preconditions.checkArgument((this.meta != null ? 1 : 0) != 0, (Object)"Item/material must have ItemMeta");
    }

    public ItemBuilder(@NotNull Material material) {
        this(new ItemStack(material));
    }

    @NotNull
    @Contract(pure=true)
    public ItemStack build() {
        this.item.setItemMeta(this.meta);
        return this.item;
    }

    @NotNull
    public ItemBuilder setAmount(int n) {
        this.item.setAmount(n);
        return this;
    }

    @NotNull
    public ItemBuilder setName(@NotNull String string) {
        this.meta.setDisplayName(string);
        return this;
    }

    @NotNull
    public ItemBuilder setLore(@NotNull List<String> list2) {
        this.meta.setLore(list2);
        return this;
    }

    @NotNull
    public ItemBuilder setLore(String ... stringArray) {
        this.meta.setLore(Arrays.asList(stringArray));
        return this;
    }

    @NotNull
    public ItemBuilder addEnchantment(@NotNull Enchantment enchantment, int n) {
        this.meta.addEnchant(enchantment, n, true);
        return this;
    }

    @NotNull
    public ItemBuilder addItemFlags(ItemFlag ... itemFlagArray) {
        this.meta.addItemFlags(itemFlagArray);
        return this;
    }

    @NotNull
    public ItemBuilder setUnbreakable(boolean bl) {
        this.meta.setUnbreakable(bl);
        return this;
    }

    @NotNull
    public <T extends ItemMeta> ItemBuilder applyCustomMeta(@NotNull Class<T> clazz, @NotNull Consumer<T> consumer) {
        consumer.accept((ItemMeta)clazz.cast(this.meta));
        return this;
    }
}

