/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.utils;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Random;
import java.util.stream.Collectors;
import me.glaremasters.guilds.utils.PremiumFun;
import org.bukkit.ChatColor;
import org.bukkit.plugin.java.JavaPlugin;

public final class StringUtils {
    private static final String ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";

    private StringUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static String color(String string) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)string);
    }

    public static String getAnnouncements(JavaPlugin javaPlugin) {
        String string;
        String string2 = javaPlugin.getDescription().getVersion();
        String string3 = String.format("https://glaremasters.me/api/guilds/?id=%s", string2);
        String string4 = String.format("https://glaremasters.me/api/guilds/?id=%s&u=%s&d=%s", string2, PremiumFun.getUserID(), PremiumFun.getDownloadID());
        URL uRL = new URL(PremiumFun.isPremium() != false ? string4 : string3);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11");
        try (InputStream inputStream = httpURLConnection.getInputStream();){
            String string5 = new BufferedReader(new InputStreamReader(inputStream)).lines().collect(Collectors.joining("\n"));
            string = StringUtils.convert_html(string5);
            httpURLConnection.disconnect();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            string = "Could not fetch announcements!";
        }
        return string;
    }

    public static String generateString(int n) {
        Random random = new Random();
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(ALPHABET.charAt(random.nextInt(ALPHABET.length())));
        }
        return stringBuilder.toString();
    }

    public static String convert_html(String string) {
        string = string.replaceAll("&", "\u00a7");
        StringBuffer stringBuffer = new StringBuffer(string.length());
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            int n = string.codePointAt(i);
            if (string.codePointAt(i) > 65535) {
                ++i;
            }
            if (!bl) {
                if (n == 92) {
                    bl = true;
                    continue;
                }
                stringBuffer.append(Character.toChars(n));
                continue;
            }
            if (n == 92) {
                bl = false;
                stringBuffer.append('\\');
                stringBuffer.append('\\');
                continue;
            }
            switch (n) {
                case 114: {
                    stringBuffer.append('\r');
                    break;
                }
                case 110: {
                    stringBuffer.append('\n');
                    break;
                }
                case 102: {
                    stringBuffer.append('\f');
                    break;
                }
                case 98: {
                    stringBuffer.append("\\b");
                    break;
                }
                case 116: {
                    stringBuffer.append('\t');
                    break;
                }
                case 97: {
                    stringBuffer.append('\u0007');
                    break;
                }
                case 101: {
                    stringBuffer.append('\u001b');
                    break;
                }
                case 99: {
                    if (++i == string.length()) {
                        return "trailing \\c";
                    }
                    n = string.codePointAt(i);
                    if (n > 127) {
                        return "expected ASCII after \\c";
                    }
                    stringBuffer.append(Character.toChars(n ^ 0x40));
                    break;
                }
                case 56: 
                case 57: {
                    return "illegal octal digit";
                }
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: {
                    --i;
                }
                case 48: {
                    int n2;
                    int n3;
                    if (i + 1 == string.length()) {
                        stringBuffer.append(Character.toChars(0));
                        break;
                    }
                    ++i;
                    int n4 = 0;
                    for (n3 = 0; n3 <= 2 && i + n3 != string.length() && (n2 = string.charAt(i + n3)) >= 48 && n2 <= 55; ++n3) {
                        ++n4;
                    }
                    if (n4 == 0) {
                        --i;
                        stringBuffer.append('\u0000');
                        break;
                    }
                    try {
                        n2 = Integer.parseInt(string.substring(i, i + n4), 8);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return "invalid octal value for \\0 escape";
                    }
                    stringBuffer.append(Character.toChars(n2));
                    i += n4 - 1;
                    break;
                }
                case 120: {
                    int n2;
                    int n3;
                    if (i + 2 > string.length()) {
                        return "string too short for \\x escape";
                    }
                    int n4 = 0;
                    if (string.charAt(++i) == '{') {
                        ++i;
                        n4 = 1;
                    }
                    for (n3 = 0; n3 < 8 && (n4 != 0 || n3 != 2); ++n3) {
                        n2 = string.charAt(i + n3);
                        if (n2 > 127) {
                            return "illegal non-ASCII hex digit in \\x escape";
                        }
                        if (n4 != 0 && n2 == 125) break;
                        if (n2 >= 48 && n2 <= 57 || n2 >= 97 && n2 <= 102 || n2 >= 65 && n2 <= 70) continue;
                        return String.format("illegal hex digit #%d '%c' in \\x", n2, n2);
                    }
                    if (n3 == 0) {
                        return "empty braces in \\x{} escape";
                    }
                    try {
                        n2 = Integer.parseInt(string.substring(i, i + n3), 16);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return "invalid hex value for \\x escape";
                    }
                    stringBuffer.append(Character.toChars(n2));
                    if (n4 != 0) {
                        ++n3;
                    }
                    i += n3 - 1;
                    break;
                }
                case 117: {
                    int n3;
                    int n4;
                    if (i + 4 > string.length()) {
                        return "string too short for \\u escape";
                    }
                    ++i;
                    for (n4 = 0; n4 < 4; ++n4) {
                        if (string.charAt(i + n4) <= '\u007f') continue;
                        return "illegal non-ASCII hex digit in \\u escape";
                    }
                    try {
                        n3 = Integer.parseInt(string.substring(i, i + n4), 16);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return "invalid hex value for \\u escape";
                    }
                    stringBuffer.append(Character.toChars(n3));
                    i += n4 - 1;
                    break;
                }
                case 85: {
                    int n3;
                    int n4;
                    if (i + 8 > string.length()) {
                        return "string too short for \\U escape";
                    }
                    ++i;
                    for (n4 = 0; n4 < 8; ++n4) {
                        if (string.charAt(i + n4) <= '\u007f') continue;
                        return "illegal non-ASCII hex digit in \\U escape";
                    }
                    try {
                        n3 = Integer.parseInt(string.substring(i, i + n4), 16);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return "invalid hex value for \\U escape";
                    }
                    stringBuffer.append(Character.toChars(n3));
                    i += n4 - 1;
                    break;
                }
                default: {
                    stringBuffer.append('\\');
                    stringBuffer.append(Character.toChars(n));
                }
            }
            bl = false;
        }
        if (bl) {
            stringBuffer.append('\\');
        }
        return stringBuffer.toString();
    }
}

