/*
 * Decompiled with CFR 0.152.
 */
package net.minidev.json;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Map;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONAware;
import net.minidev.json.JSONAwareEx;
import net.minidev.json.JSONObject;
import net.minidev.json.JSONStreamAware;
import net.minidev.json.JSONStreamAwareEx;
import net.minidev.json.JSONStyle;
import net.minidev.json.JSONUtil;
import net.minidev.json.parser.ContainerFactory;
import net.minidev.json.parser.ContentHandler;
import net.minidev.json.parser.ContentHandlerCompressor;
import net.minidev.json.parser.FakeContainerFactory;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;

public class JSONValue {
    public static JSONStyle COMPRESSION = JSONStyle.NO_COMPRESS;
    private static final FakeContainerFactory FACTORY_FAKE_COINTAINER = new FakeContainerFactory();

    public static Object parse(byte[] byArray) {
        try {
            return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(byArray);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object parse(InputStream inputStream) {
        try {
            return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(inputStream);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object parse(Reader reader) {
        try {
            return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(reader);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object parse(String string) {
        try {
            return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object parseKeepingOrder(byte[] byArray) {
        try {
            return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(byArray, ContainerFactory.FACTORY_ORDERED);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object parseKeepingOrder(InputStream inputStream) {
        try {
            return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(inputStream, ContainerFactory.FACTORY_ORDERED);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object parseKeepingOrder(Reader reader) {
        try {
            return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(reader, ContainerFactory.FACTORY_ORDERED);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object parseKeepingOrder(String string) {
        try {
            return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(string, ContainerFactory.FACTORY_ORDERED);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void SAXParse(InputStream inputStream, ContentHandler contentHandler) {
        JSONParser jSONParser = new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE);
        jSONParser.parse(inputStream, (ContainerFactory)FACTORY_FAKE_COINTAINER, contentHandler);
    }

    public static void SAXParse(Reader reader, ContentHandler contentHandler) {
        JSONParser jSONParser = new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE);
        jSONParser.parse(reader, (ContainerFactory)FACTORY_FAKE_COINTAINER, contentHandler);
    }

    public static void SAXParse(String string, ContentHandler contentHandler) {
        JSONParser jSONParser = new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE);
        jSONParser.parse(string, (ContainerFactory)FACTORY_FAKE_COINTAINER, contentHandler);
    }

    public static String compress(String string, JSONStyle jSONStyle) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            ContentHandlerCompressor contentHandlerCompressor = new ContentHandlerCompressor(stringBuilder, jSONStyle);
            JSONParser jSONParser = new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE);
            jSONParser.parse(string, (ContainerFactory)FACTORY_FAKE_COINTAINER, (ContentHandler)contentHandlerCompressor);
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            return string;
        }
    }

    public static String compress(String string) {
        return JSONValue.compress(string, JSONStyle.MAX_COMPRESS);
    }

    public static String uncompress(String string) {
        return JSONValue.compress(string, JSONStyle.NO_COMPRESS);
    }

    public static Object parseWithException(byte[] byArray) {
        return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(byArray, ContainerFactory.FACTORY_SIMPLE);
    }

    public static Object parseWithException(InputStream inputStream) {
        return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(inputStream, ContainerFactory.FACTORY_SIMPLE);
    }

    public static Object parseWithException(Reader reader) {
        return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(reader, ContainerFactory.FACTORY_SIMPLE);
    }

    public static Object parseWithException(String string) {
        return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(string, ContainerFactory.FACTORY_SIMPLE);
    }

    public static Object parseStrict(InputStream inputStream) {
        return new JSONParser(400).parse(inputStream, ContainerFactory.FACTORY_SIMPLE);
    }

    public static Object parseStrict(Reader reader) {
        return new JSONParser(400).parse(reader, ContainerFactory.FACTORY_SIMPLE);
    }

    public static Object parseStrict(String string) {
        return new JSONParser(400).parse(string, ContainerFactory.FACTORY_SIMPLE);
    }

    public static Object parseStrict(byte[] byArray) {
        return new JSONParser(400).parse(byArray, ContainerFactory.FACTORY_SIMPLE);
    }

    public static boolean isValidJsonStrict(Reader reader) {
        try {
            new JSONParser(400).parse(reader, (ContainerFactory)FACTORY_FAKE_COINTAINER);
            return true;
        }
        catch (ParseException parseException) {
            return false;
        }
    }

    public static boolean isValidJsonStrict(String string) {
        try {
            new JSONParser(400).parse(string, (ContainerFactory)FACTORY_FAKE_COINTAINER);
            return true;
        }
        catch (ParseException parseException) {
            return false;
        }
    }

    public static boolean isValidJson(Reader reader) {
        try {
            new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(reader, (ContainerFactory)FACTORY_FAKE_COINTAINER);
            return true;
        }
        catch (ParseException parseException) {
            return false;
        }
    }

    public static boolean isValidJson(String string) {
        try {
            new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(string, (ContainerFactory)FACTORY_FAKE_COINTAINER);
            return true;
        }
        catch (ParseException parseException) {
            return false;
        }
    }

    public static void writeJSONString(Object object, Appendable appendable) {
        JSONValue.writeJSONString(object, appendable, COMPRESSION);
    }

    public static void writeJSONString(Object object, Appendable appendable, JSONStyle jSONStyle) {
        if (object == null) {
            appendable.append("null");
            return;
        }
        if (object instanceof String) {
            if (!jSONStyle.mustProtectValue((String)object)) {
                appendable.append((String)object);
            } else {
                appendable.append('\"');
                JSONValue.escape((String)object, appendable, jSONStyle);
                appendable.append('\"');
            }
            return;
        }
        if (object instanceof Number) {
            if (object instanceof Double) {
                if (((Double)object).isInfinite()) {
                    appendable.append("null");
                } else {
                    appendable.append(object.toString());
                }
            } else if (object instanceof Float) {
                if (((Float)object).isInfinite()) {
                    appendable.append("null");
                } else {
                    appendable.append(object.toString());
                }
            } else {
                appendable.append(object.toString());
            }
            return;
        }
        if (object instanceof Boolean) {
            appendable.append(object.toString());
        } else if (object instanceof JSONStreamAware) {
            if (object instanceof JSONStreamAwareEx) {
                ((JSONStreamAwareEx)object).writeJSONString(appendable, jSONStyle);
            } else {
                ((JSONStreamAware)object).writeJSONString(appendable);
            }
        } else if (object instanceof JSONAware) {
            if (object instanceof JSONAwareEx) {
                appendable.append(((JSONAwareEx)object).toJSONString(jSONStyle));
            } else {
                appendable.append(((JSONAware)object).toJSONString());
            }
        } else if (object instanceof Map) {
            JSONObject.writeJSON((Map)object, appendable, jSONStyle);
        } else if (object instanceof Iterable) {
            JSONArray.writeJSONString((Iterable)object, appendable, jSONStyle);
        } else if (object instanceof Date) {
            JSONValue.writeJSONString(object.toString(), appendable, jSONStyle);
        } else {
            if (object instanceof Enum) {
                String string = ((Enum)object).name();
                if (!jSONStyle.mustProtectValue(string)) {
                    appendable.append(string);
                } else {
                    appendable.append('\"');
                    JSONValue.escape(string, appendable, jSONStyle);
                    appendable.append('\"');
                }
                return;
            }
            if (object.getClass().isArray()) {
                Class<?> clazz = object.getClass();
                Class<?> clazz2 = clazz.getComponentType();
                appendable.append('[');
                boolean bl = false;
                if (clazz2.isPrimitive()) {
                    if (clazz2 == Integer.TYPE) {
                        for (int n : (int[])object) {
                            if (bl) {
                                appendable.append(',');
                            } else {
                                bl = true;
                            }
                            appendable.append(Integer.toString(n));
                        }
                    } else if (clazz2 == Short.TYPE) {
                        for (short s : (short[])object) {
                            if (bl) {
                                appendable.append(',');
                            } else {
                                bl = true;
                            }
                            appendable.append(Short.toString(s));
                        }
                    } else if (clazz2 == Byte.TYPE) {
                        for (byte by : (byte[])object) {
                            if (bl) {
                                appendable.append(',');
                            } else {
                                bl = true;
                            }
                            appendable.append(Byte.toString(by));
                        }
                    } else if (clazz2 == Long.TYPE) {
                        for (long l : (long[])object) {
                            if (bl) {
                                appendable.append(',');
                            } else {
                                bl = true;
                            }
                            appendable.append(Long.toString(l));
                        }
                    } else if (clazz2 == Float.TYPE) {
                        for (float f : (float[])object) {
                            if (bl) {
                                appendable.append(',');
                            } else {
                                bl = true;
                            }
                            appendable.append(Float.toString(f));
                        }
                    } else if (clazz2 == Double.TYPE) {
                        for (double d : (double[])object) {
                            if (bl) {
                                appendable.append(',');
                            } else {
                                bl = true;
                            }
                            appendable.append(Double.toString(d));
                        }
                    } else if (clazz2 == Boolean.TYPE) {
                        for (boolean bl2 : (boolean[])object) {
                            if (bl) {
                                appendable.append(',');
                            } else {
                                bl = true;
                            }
                            if (bl2) {
                                appendable.append("true");
                                continue;
                            }
                            appendable.append("false");
                        }
                    }
                } else {
                    for (Object object2 : (Object[])object) {
                        if (bl) {
                            appendable.append(',');
                        } else {
                            bl = true;
                        }
                        JSONValue.writeJSONString(object2, appendable, jSONStyle);
                    }
                }
                appendable.append(']');
            } else {
                try {
                    Class<?> clazz = object.getClass();
                    boolean bl = false;
                    Field[] fieldArray = clazz.getDeclaredFields();
                    appendable.append('{');
                    for (Field field : fieldArray) {
                        int n = field.getModifiers();
                        if ((n & 0x98) > 0) continue;
                        Object object3 = null;
                        if ((n & 1) > 0) {
                            object3 = field.get(object);
                        } else {
                            Class<?> clazz3;
                            String string = JSONUtil.getGetterName(field.getName());
                            Method method = null;
                            try {
                                method = clazz.getDeclaredMethod(string, new Class[0]);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (method == null && ((clazz3 = field.getType()) == Boolean.TYPE || clazz3 == Boolean.class)) {
                                string = JSONUtil.getIsName(field.getName());
                                method = clazz.getDeclaredMethod(string, new Class[0]);
                            }
                            if (method == null) continue;
                            object3 = method.invoke(object, new Object[0]);
                        }
                        if (bl) {
                            appendable.append(',');
                        } else {
                            bl = true;
                        }
                        JSONObject.writeJSONKV(field.getName(), object3, appendable, jSONStyle);
                    }
                    appendable.append('}');
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
        }
    }

    public static String toJSONString(Object object) {
        return JSONValue.toJSONString(object, COMPRESSION);
    }

    public static String toJSONString(Object object, JSONStyle jSONStyle) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            JSONValue.writeJSONString(object, stringBuilder, jSONStyle);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringBuilder.toString();
    }

    public static String escape(String string) {
        return JSONValue.escape(string, COMPRESSION);
    }

    public static String escape(String string, JSONStyle jSONStyle) {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        jSONStyle.escape(string, stringBuilder);
        return stringBuilder.toString();
    }

    public static void escape(String string, Appendable appendable) {
        JSONValue.escape(string, appendable, COMPRESSION);
    }

    public static void escape(String string, Appendable appendable, JSONStyle jSONStyle) {
        if (string == null) {
            return;
        }
        jSONStyle.escape(string, appendable);
    }
}

