/*
 * Decompiled with CFR 0.152.
 */
package net.minidev.json;

import java.io.IOException;

class JStylerObj {
    public static final MPSimple MP_SIMPLE = new MPSimple();
    public static final MPTrue MP_TRUE = new MPTrue();
    public static final MPAgressive MP_AGGRESIVE = new MPAgressive();
    public static final EscapeLT ESCAPE_LT = new EscapeLT();
    public static final Escape4Web ESCAPE4Web = new Escape4Web();

    JStylerObj() {
    }

    public static boolean isSpace(char c) {
        return c == '\r' || c == '\n' || c == '\t' || c == ' ';
    }

    public static boolean isSpecialChar(char c) {
        return c == '\b' || c == '\f' || c == '\n';
    }

    public static boolean isSpecialOpen(char c) {
        return c == '{' || c == '[' || c == ',' || c == ':';
    }

    public static boolean isSpecialClose(char c) {
        return c == '}' || c == ']' || c == ',' || c == ':';
    }

    public static boolean isSpecial(char c) {
        return c == '{' || c == '[' || c == ',' || c == '}' || c == ']' || c == ':' || c == '\'' || c == '\"';
    }

    public static boolean isUnicode(char c) {
        return c >= '\u0000' && c <= '\u001f' || c >= '\u007f' && c <= '\u009f' || c >= '\u2000' && c <= '\u20ff';
    }

    public static boolean isKeyword(String string) {
        if (string.length() < 3) {
            return false;
        }
        char c = string.charAt(0);
        if (c == 'n') {
            return string.equals("null");
        }
        if (c == 't') {
            return string.equals("true");
        }
        if (c == 'f') {
            return string.equals("false");
        }
        if (c == 'N') {
            return string.equals("NaN");
        }
        return false;
    }

    private static class Escape4Web
    implements StringProtector {
        private Escape4Web() {
        }

        public void escape(String string, Appendable appendable) {
            try {
                block12: for (int i = 0; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    switch (c) {
                        case '\"': {
                            appendable.append("\\\"");
                            continue block12;
                        }
                        case '\\': {
                            appendable.append("\\\\");
                            continue block12;
                        }
                        case '\b': {
                            appendable.append("\\b");
                            continue block12;
                        }
                        case '\f': {
                            appendable.append("\\f");
                            continue block12;
                        }
                        case '\n': {
                            appendable.append("\\n");
                            continue block12;
                        }
                        case '\r': {
                            appendable.append("\\r");
                            continue block12;
                        }
                        case '\t': {
                            appendable.append("\\t");
                            continue block12;
                        }
                        case '/': {
                            appendable.append("\\/");
                            continue block12;
                        }
                        default: {
                            if (c >= '\u0000' && c <= '\u001f' || c >= '\u007f' && c <= '\u009f' || c >= '\u2000' && c <= '\u20ff') {
                                appendable.append("\\u");
                                String string2 = "0123456789ABCDEF";
                                appendable.append(string2.charAt(c >> 12 & 0xF));
                                appendable.append(string2.charAt(c >> 8 & 0xF));
                                appendable.append(string2.charAt(c >> 4 & 0xF));
                                appendable.append(string2.charAt(c >> 0 & 0xF));
                                continue block12;
                            }
                            appendable.append(c);
                        }
                    }
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException("Impossible Error");
            }
        }
    }

    private static class EscapeLT
    implements StringProtector {
        private EscapeLT() {
        }

        public void escape(String string, Appendable appendable) {
            try {
                block11: for (int i = 0; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    switch (c) {
                        case '\"': {
                            appendable.append("\\\"");
                            continue block11;
                        }
                        case '\\': {
                            appendable.append("\\\\");
                            continue block11;
                        }
                        case '\b': {
                            appendable.append("\\b");
                            continue block11;
                        }
                        case '\f': {
                            appendable.append("\\f");
                            continue block11;
                        }
                        case '\n': {
                            appendable.append("\\n");
                            continue block11;
                        }
                        case '\r': {
                            appendable.append("\\r");
                            continue block11;
                        }
                        case '\t': {
                            appendable.append("\\t");
                            continue block11;
                        }
                        default: {
                            if (c >= '\u0000' && c <= '\u001f' || c >= '\u007f' && c <= '\u009f' || c >= '\u2000' && c <= '\u20ff') {
                                appendable.append("\\u");
                                String string2 = "0123456789ABCDEF";
                                appendable.append(string2.charAt(c >> 12 & 0xF));
                                appendable.append(string2.charAt(c >> 8 & 0xF));
                                appendable.append(string2.charAt(c >> 4 & 0xF));
                                appendable.append(string2.charAt(c >> 0 & 0xF));
                                continue block11;
                            }
                            appendable.append(c);
                        }
                    }
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException("Impossible Exeption");
            }
        }
    }

    public static interface StringProtector {
        public void escape(String var1, Appendable var2);
    }

    private static class MPAgressive
    implements MustProtect {
        private MPAgressive() {
        }

        public boolean mustBeProtect(String string) {
            int n;
            if (string == null) {
                return false;
            }
            int n2 = string.length();
            if (n2 == 0) {
                return true;
            }
            if (string.trim() != string) {
                return true;
            }
            char c = string.charAt(0);
            if (JStylerObj.isSpecial(c) || JStylerObj.isUnicode(c)) {
                return true;
            }
            for (n = 1; n < n2; ++n) {
                c = string.charAt(n);
                if (!JStylerObj.isSpecialClose(c) && !JStylerObj.isUnicode(c)) continue;
                return true;
            }
            if (JStylerObj.isKeyword(string)) {
                return true;
            }
            c = string.charAt(0);
            if (c >= '0' && c <= '9' || c == '-') {
                for (n = 1; n < string.length() && (c = string.charAt(n)) >= '0' && c <= '9'; ++n) {
                }
                if (n == string.length()) {
                    return true;
                }
                if (c == '.') {
                    ++n;
                    while (n < string.length() && (c = string.charAt(n)) >= '0' && c <= '9') {
                        ++n;
                    }
                }
                if (n == string.length()) {
                    return true;
                }
                if (c != 'E' || c != 'e') {
                    return false;
                }
                if (++n == string.length()) {
                    return false;
                }
                c = string.charAt(n);
                if (c == '+' || c == '-') {
                    c = (char)(c + '\u0001');
                    if (n == string.length()) {
                        return false;
                    }
                    c = string.charAt(n);
                }
                if (c == '+' || c == '-') {
                    c = (char)(c + '\u0001');
                    if (n == string.length()) {
                        return false;
                    }
                }
                while (n < string.length() && (c = string.charAt(n)) >= '0' && c <= '9') {
                    ++n;
                }
                return n == string.length();
            }
            return false;
        }
    }

    private static class MPSimple
    implements MustProtect {
        private MPSimple() {
        }

        public boolean mustBeProtect(String string) {
            if (string == null) {
                return false;
            }
            int n = string.length();
            if (n == 0) {
                return true;
            }
            if (string.trim() != string) {
                return true;
            }
            char c = string.charAt(0);
            if (c >= '0' && c <= '9' || c == '-') {
                return true;
            }
            for (int i = 0; i < n; ++i) {
                c = string.charAt(i);
                if (JStylerObj.isSpace(c)) {
                    return true;
                }
                if (JStylerObj.isSpecial(c)) {
                    return true;
                }
                if (JStylerObj.isSpecialChar(c)) {
                    return true;
                }
                if (!JStylerObj.isUnicode(c)) continue;
                return true;
            }
            return JStylerObj.isKeyword(string);
        }
    }

    private static class MPTrue
    implements MustProtect {
        private MPTrue() {
        }

        public boolean mustBeProtect(String string) {
            return true;
        }
    }

    public static interface MustProtect {
        public boolean mustBeProtect(String var1);
    }
}

