/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.runtime;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;

public class CodePointBuffer {
    private final Type type;
    private final ByteBuffer byteBuffer;
    private final CharBuffer charBuffer;
    private final IntBuffer intBuffer;

    private CodePointBuffer(Type type, ByteBuffer byteBuffer, CharBuffer charBuffer, IntBuffer intBuffer) {
        this.type = type;
        this.byteBuffer = byteBuffer;
        this.charBuffer = charBuffer;
        this.intBuffer = intBuffer;
    }

    public static CodePointBuffer withBytes(ByteBuffer byteBuffer) {
        return new CodePointBuffer(Type.BYTE, byteBuffer, null, null);
    }

    public static CodePointBuffer withChars(CharBuffer charBuffer) {
        return new CodePointBuffer(Type.CHAR, null, charBuffer, null);
    }

    public static CodePointBuffer withInts(IntBuffer intBuffer) {
        return new CodePointBuffer(Type.INT, null, null, intBuffer);
    }

    public int position() {
        switch (this.type) {
            case BYTE: {
                return this.byteBuffer.position();
            }
            case CHAR: {
                return this.charBuffer.position();
            }
            case INT: {
                return this.intBuffer.position();
            }
        }
        throw new UnsupportedOperationException("Not reached");
    }

    public void position(int n) {
        switch (this.type) {
            case BYTE: {
                this.byteBuffer.position(n);
                break;
            }
            case CHAR: {
                this.charBuffer.position(n);
                break;
            }
            case INT: {
                this.intBuffer.position(n);
            }
        }
    }

    public int remaining() {
        switch (this.type) {
            case BYTE: {
                return this.byteBuffer.remaining();
            }
            case CHAR: {
                return this.charBuffer.remaining();
            }
            case INT: {
                return this.intBuffer.remaining();
            }
        }
        throw new UnsupportedOperationException("Not reached");
    }

    public int get(int n) {
        switch (this.type) {
            case BYTE: {
                return this.byteBuffer.get(n);
            }
            case CHAR: {
                return this.charBuffer.get(n);
            }
            case INT: {
                return this.intBuffer.get(n);
            }
        }
        throw new UnsupportedOperationException("Not reached");
    }

    Type getType() {
        return this.type;
    }

    int arrayOffset() {
        switch (this.type) {
            case BYTE: {
                return this.byteBuffer.arrayOffset();
            }
            case CHAR: {
                return this.charBuffer.arrayOffset();
            }
            case INT: {
                return this.intBuffer.arrayOffset();
            }
        }
        throw new UnsupportedOperationException("Not reached");
    }

    byte[] byteArray() {
        assert (this.type == Type.BYTE);
        return this.byteBuffer.array();
    }

    char[] charArray() {
        assert (this.type == Type.CHAR);
        return this.charBuffer.array();
    }

    int[] intArray() {
        assert (this.type == Type.INT);
        return this.intBuffer.array();
    }

    public static Builder builder(int n) {
        return new Builder(n);
    }

    public static class Builder {
        private Type type = Type.BYTE;
        private ByteBuffer byteBuffer;
        private CharBuffer charBuffer;
        private IntBuffer intBuffer;
        private int prevHighSurrogate;

        private Builder(int n) {
            this.byteBuffer = ByteBuffer.allocate(n);
            this.charBuffer = null;
            this.intBuffer = null;
            this.prevHighSurrogate = -1;
        }

        Type getType() {
            return this.type;
        }

        ByteBuffer getByteBuffer() {
            return this.byteBuffer;
        }

        CharBuffer getCharBuffer() {
            return this.charBuffer;
        }

        IntBuffer getIntBuffer() {
            return this.intBuffer;
        }

        public CodePointBuffer build() {
            switch (this.type) {
                case BYTE: {
                    this.byteBuffer.flip();
                    break;
                }
                case CHAR: {
                    this.charBuffer.flip();
                    break;
                }
                case INT: {
                    this.intBuffer.flip();
                }
            }
            return new CodePointBuffer(this.type, this.byteBuffer, this.charBuffer, this.intBuffer);
        }

        private static int roundUpToNextPowerOfTwo(int n) {
            int n2 = 32 - Integer.numberOfLeadingZeros(n - 1);
            return (int)Math.pow(2.0, n2);
        }

        public void ensureRemaining(int n) {
            switch (this.type) {
                case BYTE: {
                    if (this.byteBuffer.remaining() >= n) break;
                    int n2 = Builder.roundUpToNextPowerOfTwo(this.byteBuffer.capacity() + n);
                    ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
                    this.byteBuffer.flip();
                    byteBuffer.put(this.byteBuffer);
                    this.byteBuffer = byteBuffer;
                    break;
                }
                case CHAR: {
                    if (this.charBuffer.remaining() >= n) break;
                    int n3 = Builder.roundUpToNextPowerOfTwo(this.charBuffer.capacity() + n);
                    CharBuffer charBuffer = CharBuffer.allocate(n3);
                    this.charBuffer.flip();
                    charBuffer.put(this.charBuffer);
                    this.charBuffer = charBuffer;
                    break;
                }
                case INT: {
                    if (this.intBuffer.remaining() >= n) break;
                    int n4 = Builder.roundUpToNextPowerOfTwo(this.intBuffer.capacity() + n);
                    IntBuffer intBuffer = IntBuffer.allocate(n4);
                    this.intBuffer.flip();
                    intBuffer.put(this.intBuffer);
                    this.intBuffer = intBuffer;
                }
            }
        }

        public void append(CharBuffer charBuffer) {
            this.ensureRemaining(charBuffer.remaining());
            if (!charBuffer.hasArray()) {
                throw new UnsupportedOperationException("TODO");
            }
            this.appendArray(charBuffer);
        }

        private void appendArray(CharBuffer charBuffer) {
            assert (charBuffer.hasArray());
            switch (this.type) {
                case BYTE: {
                    this.appendArrayByte(charBuffer);
                    break;
                }
                case CHAR: {
                    this.appendArrayChar(charBuffer);
                    break;
                }
                case INT: {
                    this.appendArrayInt(charBuffer);
                }
            }
        }

        private void appendArrayByte(CharBuffer charBuffer) {
            assert (this.prevHighSurrogate == -1);
            char[] cArray = charBuffer.array();
            int n = charBuffer.arrayOffset() + charBuffer.position();
            int n2 = charBuffer.arrayOffset() + charBuffer.limit();
            byte[] byArray = this.byteBuffer.array();
            int n3 = this.byteBuffer.arrayOffset() + this.byteBuffer.position();
            while (n < n2) {
                char c = cArray[n];
                if (c > '\u00ff') {
                    charBuffer.position(n - charBuffer.arrayOffset());
                    this.byteBuffer.position(n3 - this.byteBuffer.arrayOffset());
                    if (!Character.isHighSurrogate(c)) {
                        this.byteToCharBuffer(charBuffer.remaining());
                        this.appendArrayChar(charBuffer);
                        return;
                    }
                    this.byteToIntBuffer(charBuffer.remaining());
                    this.appendArrayInt(charBuffer);
                    return;
                }
                byArray[n3] = (byte)(c & 0xFF);
                ++n;
                ++n3;
            }
            charBuffer.position(n - charBuffer.arrayOffset());
            this.byteBuffer.position(n3 - this.byteBuffer.arrayOffset());
        }

        private void appendArrayChar(CharBuffer charBuffer) {
            assert (this.prevHighSurrogate == -1);
            char[] cArray = charBuffer.array();
            int n = charBuffer.arrayOffset() + charBuffer.position();
            int n2 = charBuffer.arrayOffset() + charBuffer.limit();
            char[] cArray2 = this.charBuffer.array();
            int n3 = this.charBuffer.arrayOffset() + this.charBuffer.position();
            while (n < n2) {
                char c = cArray[n];
                if (Character.isHighSurrogate(c)) {
                    charBuffer.position(n - charBuffer.arrayOffset());
                    this.charBuffer.position(n3 - this.charBuffer.arrayOffset());
                    this.charToIntBuffer(charBuffer.remaining());
                    this.appendArrayInt(charBuffer);
                    return;
                }
                cArray2[n3] = c;
                ++n;
                ++n3;
            }
            charBuffer.position(n - charBuffer.arrayOffset());
            this.charBuffer.position(n3 - this.charBuffer.arrayOffset());
        }

        private void appendArrayInt(CharBuffer charBuffer) {
            char[] cArray = charBuffer.array();
            int n = charBuffer.arrayOffset() + charBuffer.position();
            int n2 = charBuffer.arrayOffset() + charBuffer.limit();
            int[] nArray = this.intBuffer.array();
            int n3 = this.intBuffer.arrayOffset() + this.intBuffer.position();
            while (n < n2) {
                char c = cArray[n];
                ++n;
                if (this.prevHighSurrogate != -1) {
                    if (Character.isLowSurrogate(c)) {
                        nArray[n3] = Character.toCodePoint((char)this.prevHighSurrogate, c);
                        ++n3;
                        this.prevHighSurrogate = -1;
                        continue;
                    }
                    nArray[n3] = this.prevHighSurrogate;
                    ++n3;
                    if (Character.isHighSurrogate(c)) {
                        this.prevHighSurrogate = c & 0xFFFF;
                        continue;
                    }
                    nArray[n3] = c & 0xFFFF;
                    ++n3;
                    this.prevHighSurrogate = -1;
                    continue;
                }
                if (Character.isHighSurrogate(c)) {
                    this.prevHighSurrogate = c & 0xFFFF;
                    continue;
                }
                nArray[n3] = c & 0xFFFF;
                ++n3;
            }
            if (this.prevHighSurrogate != -1) {
                nArray[n3] = this.prevHighSurrogate & 0xFFFF;
                ++n3;
            }
            charBuffer.position(n - charBuffer.arrayOffset());
            this.intBuffer.position(n3 - this.intBuffer.arrayOffset());
        }

        private void byteToCharBuffer(int n) {
            this.byteBuffer.flip();
            CharBuffer charBuffer = CharBuffer.allocate(Math.max(this.byteBuffer.remaining() + n, this.byteBuffer.capacity() / 2));
            while (this.byteBuffer.hasRemaining()) {
                charBuffer.put((char)(this.byteBuffer.get() & 0xFF));
            }
            this.type = Type.CHAR;
            this.byteBuffer = null;
            this.charBuffer = charBuffer;
        }

        private void byteToIntBuffer(int n) {
            this.byteBuffer.flip();
            IntBuffer intBuffer = IntBuffer.allocate(Math.max(this.byteBuffer.remaining() + n, this.byteBuffer.capacity() / 4));
            while (this.byteBuffer.hasRemaining()) {
                intBuffer.put(this.byteBuffer.get() & 0xFF);
            }
            this.type = Type.INT;
            this.byteBuffer = null;
            this.intBuffer = intBuffer;
        }

        private void charToIntBuffer(int n) {
            this.charBuffer.flip();
            IntBuffer intBuffer = IntBuffer.allocate(Math.max(this.charBuffer.remaining() + n, this.charBuffer.capacity() / 2));
            while (this.charBuffer.hasRemaining()) {
                intBuffer.put(this.charBuffer.get() & 0xFFFF);
            }
            this.type = Type.INT;
            this.charBuffer = null;
            this.intBuffer = intBuffer;
        }
    }

    public static enum Type {
        BYTE,
        CHAR,
        INT;

    }
}

