/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.runtime.atn;

import java.util.Arrays;
import org.antlr.v4.runtime.atn.PredictionContext;
import org.antlr.v4.runtime.atn.SingletonPredictionContext;

public class ArrayPredictionContext
extends PredictionContext {
    public final PredictionContext[] parents;
    public final int[] returnStates;

    public ArrayPredictionContext(SingletonPredictionContext singletonPredictionContext) {
        this(new PredictionContext[]{singletonPredictionContext.parent}, new int[]{singletonPredictionContext.returnState});
    }

    public ArrayPredictionContext(PredictionContext[] predictionContextArray, int[] nArray) {
        super(ArrayPredictionContext.calculateHashCode(predictionContextArray, nArray));
        assert (predictionContextArray != null && predictionContextArray.length > 0);
        assert (nArray != null && nArray.length > 0);
        this.parents = predictionContextArray;
        this.returnStates = nArray;
    }

    @Override
    public boolean isEmpty() {
        return this.returnStates[0] == Integer.MAX_VALUE;
    }

    @Override
    public int size() {
        return this.returnStates.length;
    }

    @Override
    public PredictionContext getParent(int n) {
        return this.parents[n];
    }

    @Override
    public int getReturnState(int n) {
        return this.returnStates[n];
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ArrayPredictionContext)) {
            return false;
        }
        if (this.hashCode() != object.hashCode()) {
            return false;
        }
        ArrayPredictionContext arrayPredictionContext = (ArrayPredictionContext)object;
        return Arrays.equals(this.returnStates, arrayPredictionContext.returnStates) && Arrays.equals(this.parents, arrayPredictionContext.parents);
    }

    public String toString() {
        if (this.isEmpty()) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (int i = 0; i < this.returnStates.length; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            if (this.returnStates[i] == Integer.MAX_VALUE) {
                stringBuilder.append("$");
                continue;
            }
            stringBuilder.append(this.returnStates[i]);
            if (this.parents[i] != null) {
                stringBuilder.append(' ');
                stringBuilder.append(this.parents[i].toString());
                continue;
            }
            stringBuilder.append("null");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

