/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.runtime.atn;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.misc.MurmurHash;
import org.antlr.v4.runtime.misc.Utils;

public abstract class SemanticContext {
    public static final SemanticContext NONE = new Predicate();

    public abstract boolean eval(Recognizer<?, ?> var1, RuleContext var2);

    public SemanticContext evalPrecedence(Recognizer<?, ?> recognizer, RuleContext ruleContext) {
        return this;
    }

    public static SemanticContext and(SemanticContext semanticContext, SemanticContext semanticContext2) {
        if (semanticContext == null || semanticContext == NONE) {
            return semanticContext2;
        }
        if (semanticContext2 == null || semanticContext2 == NONE) {
            return semanticContext;
        }
        AND aND = new AND(semanticContext, semanticContext2);
        if (aND.opnds.length == 1) {
            return aND.opnds[0];
        }
        return aND;
    }

    public static SemanticContext or(SemanticContext semanticContext, SemanticContext semanticContext2) {
        if (semanticContext == null) {
            return semanticContext2;
        }
        if (semanticContext2 == null) {
            return semanticContext;
        }
        if (semanticContext == NONE || semanticContext2 == NONE) {
            return NONE;
        }
        OR oR = new OR(semanticContext, semanticContext2);
        if (oR.opnds.length == 1) {
            return oR.opnds[0];
        }
        return oR;
    }

    private static List<PrecedencePredicate> filterPrecedencePredicates(Collection<? extends SemanticContext> collection) {
        ArrayList<PrecedencePredicate> arrayList = null;
        Iterator<? extends SemanticContext> iterator = collection.iterator();
        while (iterator.hasNext()) {
            SemanticContext semanticContext = iterator.next();
            if (!(semanticContext instanceof PrecedencePredicate)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<PrecedencePredicate>();
            }
            arrayList.add((PrecedencePredicate)semanticContext);
            iterator.remove();
        }
        if (arrayList == null) {
            return Collections.emptyList();
        }
        return arrayList;
    }

    public static class OR
    extends Operator {
        public final SemanticContext[] opnds;

        public OR(SemanticContext semanticContext, SemanticContext semanticContext2) {
            HashSet<SemanticContext> hashSet = new HashSet<SemanticContext>();
            if (semanticContext instanceof OR) {
                hashSet.addAll(Arrays.asList(((OR)semanticContext).opnds));
            } else {
                hashSet.add(semanticContext);
            }
            if (semanticContext2 instanceof OR) {
                hashSet.addAll(Arrays.asList(((OR)semanticContext2).opnds));
            } else {
                hashSet.add(semanticContext2);
            }
            List list2 = SemanticContext.filterPrecedencePredicates(hashSet);
            if (!list2.isEmpty()) {
                PrecedencePredicate precedencePredicate = (PrecedencePredicate)Collections.max(list2);
                hashSet.add(precedencePredicate);
            }
            this.opnds = hashSet.toArray(new SemanticContext[hashSet.size()]);
        }

        @Override
        public Collection<SemanticContext> getOperands() {
            return Arrays.asList(this.opnds);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof OR)) {
                return false;
            }
            OR oR = (OR)object;
            return Arrays.equals(this.opnds, oR.opnds);
        }

        public int hashCode() {
            return MurmurHash.hashCode(this.opnds, OR.class.hashCode());
        }

        @Override
        public boolean eval(Recognizer<?, ?> recognizer, RuleContext ruleContext) {
            for (SemanticContext semanticContext : this.opnds) {
                if (!semanticContext.eval(recognizer, ruleContext)) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SemanticContext evalPrecedence(Recognizer<?, ?> recognizer, RuleContext ruleContext) {
            void var5_7;
            boolean bl = false;
            ArrayList<SemanticContext> arrayList = new ArrayList<SemanticContext>();
            SemanticContext[] object = this.opnds;
            int n = object.length;
            for (int i = 0; i < n; ++i) {
                SemanticContext semanticContext = object[i];
                SemanticContext semanticContext2 = semanticContext.evalPrecedence(recognizer, ruleContext);
                bl |= semanticContext2 != semanticContext;
                if (semanticContext2 == NONE) {
                    return NONE;
                }
                if (semanticContext2 == null) continue;
                arrayList.add(semanticContext2);
            }
            if (!bl) {
                return this;
            }
            if (arrayList.isEmpty()) {
                return null;
            }
            SemanticContext semanticContext = (SemanticContext)arrayList.get(0);
            for (n = 1; n < arrayList.size(); ++n) {
                SemanticContext semanticContext3 = SemanticContext.or((SemanticContext)var5_7, (SemanticContext)arrayList.get(n));
            }
            return var5_7;
        }

        public String toString() {
            return Utils.join(Arrays.asList(this.opnds).iterator(), "||");
        }
    }

    public static class AND
    extends Operator {
        public final SemanticContext[] opnds;

        public AND(SemanticContext semanticContext, SemanticContext semanticContext2) {
            HashSet<SemanticContext> hashSet = new HashSet<SemanticContext>();
            if (semanticContext instanceof AND) {
                hashSet.addAll(Arrays.asList(((AND)semanticContext).opnds));
            } else {
                hashSet.add(semanticContext);
            }
            if (semanticContext2 instanceof AND) {
                hashSet.addAll(Arrays.asList(((AND)semanticContext2).opnds));
            } else {
                hashSet.add(semanticContext2);
            }
            List list2 = SemanticContext.filterPrecedencePredicates(hashSet);
            if (!list2.isEmpty()) {
                PrecedencePredicate precedencePredicate = (PrecedencePredicate)Collections.min(list2);
                hashSet.add(precedencePredicate);
            }
            this.opnds = hashSet.toArray(new SemanticContext[hashSet.size()]);
        }

        @Override
        public Collection<SemanticContext> getOperands() {
            return Arrays.asList(this.opnds);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof AND)) {
                return false;
            }
            AND aND = (AND)object;
            return Arrays.equals(this.opnds, aND.opnds);
        }

        public int hashCode() {
            return MurmurHash.hashCode(this.opnds, AND.class.hashCode());
        }

        @Override
        public boolean eval(Recognizer<?, ?> recognizer, RuleContext ruleContext) {
            for (SemanticContext semanticContext : this.opnds) {
                if (semanticContext.eval(recognizer, ruleContext)) continue;
                return false;
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SemanticContext evalPrecedence(Recognizer<?, ?> recognizer, RuleContext ruleContext) {
            void var5_7;
            boolean bl = false;
            ArrayList<SemanticContext> arrayList = new ArrayList<SemanticContext>();
            SemanticContext[] object = this.opnds;
            int n = object.length;
            for (int i = 0; i < n; ++i) {
                SemanticContext semanticContext = object[i];
                SemanticContext semanticContext2 = semanticContext.evalPrecedence(recognizer, ruleContext);
                bl |= semanticContext2 != semanticContext;
                if (semanticContext2 == null) {
                    return null;
                }
                if (semanticContext2 == NONE) continue;
                arrayList.add(semanticContext2);
            }
            if (!bl) {
                return this;
            }
            if (arrayList.isEmpty()) {
                return NONE;
            }
            SemanticContext semanticContext = (SemanticContext)arrayList.get(0);
            for (n = 1; n < arrayList.size(); ++n) {
                SemanticContext semanticContext3 = SemanticContext.and((SemanticContext)var5_7, (SemanticContext)arrayList.get(n));
            }
            return var5_7;
        }

        public String toString() {
            return Utils.join(Arrays.asList(this.opnds).iterator(), "&&");
        }
    }

    public static abstract class Operator
    extends SemanticContext {
        public abstract Collection<SemanticContext> getOperands();
    }

    public static class PrecedencePredicate
    extends SemanticContext
    implements Comparable<PrecedencePredicate> {
        public final int precedence;

        protected PrecedencePredicate() {
            this.precedence = 0;
        }

        public PrecedencePredicate(int n) {
            this.precedence = n;
        }

        @Override
        public boolean eval(Recognizer<?, ?> recognizer, RuleContext ruleContext) {
            return recognizer.precpred(ruleContext, this.precedence);
        }

        @Override
        public SemanticContext evalPrecedence(Recognizer<?, ?> recognizer, RuleContext ruleContext) {
            if (recognizer.precpred(ruleContext, this.precedence)) {
                return NONE;
            }
            return null;
        }

        @Override
        public int compareTo(PrecedencePredicate precedencePredicate) {
            return this.precedence - precedencePredicate.precedence;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + this.precedence;
            return n;
        }

        public boolean equals(Object object) {
            if (!(object instanceof PrecedencePredicate)) {
                return false;
            }
            if (this == object) {
                return true;
            }
            PrecedencePredicate precedencePredicate = (PrecedencePredicate)object;
            return this.precedence == precedencePredicate.precedence;
        }

        public String toString() {
            return "{" + this.precedence + ">=prec}?";
        }
    }

    public static class Predicate
    extends SemanticContext {
        public final int ruleIndex;
        public final int predIndex;
        public final boolean isCtxDependent;

        protected Predicate() {
            this.ruleIndex = -1;
            this.predIndex = -1;
            this.isCtxDependent = false;
        }

        public Predicate(int n, int n2, boolean bl) {
            this.ruleIndex = n;
            this.predIndex = n2;
            this.isCtxDependent = bl;
        }

        @Override
        public boolean eval(Recognizer<?, ?> recognizer, RuleContext ruleContext) {
            RuleContext ruleContext2 = this.isCtxDependent ? ruleContext : null;
            return recognizer.sempred(ruleContext2, this.ruleIndex, this.predIndex);
        }

        public int hashCode() {
            int n = MurmurHash.initialize();
            n = MurmurHash.update(n, this.ruleIndex);
            n = MurmurHash.update(n, this.predIndex);
            n = MurmurHash.update(n, this.isCtxDependent ? 1 : 0);
            n = MurmurHash.finish(n, 3);
            return n;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Predicate)) {
                return false;
            }
            if (this == object) {
                return true;
            }
            Predicate predicate = (Predicate)object;
            return this.ruleIndex == predicate.ruleIndex && this.predIndex == predicate.predIndex && this.isCtxDependent == predicate.isCtxDependent;
        }

        public String toString() {
            return "{" + this.ruleIndex + ":" + this.predIndex + "}?";
        }
    }
}

