/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.runtime.dfa;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.Vocabulary;
import org.antlr.v4.runtime.VocabularyImpl;
import org.antlr.v4.runtime.atn.ATNConfigSet;
import org.antlr.v4.runtime.atn.DecisionState;
import org.antlr.v4.runtime.atn.StarLoopEntryState;
import org.antlr.v4.runtime.dfa.DFASerializer;
import org.antlr.v4.runtime.dfa.DFAState;
import org.antlr.v4.runtime.dfa.LexerDFASerializer;

public class DFA {
    public final Map<DFAState, DFAState> states = new HashMap<DFAState, DFAState>();
    public volatile DFAState s0;
    public final int decision;
    public final DecisionState atnStartState;
    private final boolean precedenceDfa;

    public DFA(DecisionState decisionState) {
        this(decisionState, 0);
    }

    public DFA(DecisionState decisionState, int n) {
        this.atnStartState = decisionState;
        this.decision = n;
        boolean bl = false;
        if (decisionState instanceof StarLoopEntryState && ((StarLoopEntryState)decisionState).isPrecedenceDecision) {
            bl = true;
            DFAState dFAState = new DFAState(new ATNConfigSet());
            dFAState.edges = new DFAState[0];
            dFAState.isAcceptState = false;
            dFAState.requiresFullContext = false;
            this.s0 = dFAState;
        }
        this.precedenceDfa = bl;
    }

    public final boolean isPrecedenceDfa() {
        return this.precedenceDfa;
    }

    public final DFAState getPrecedenceStartState(int n) {
        if (!this.isPrecedenceDfa()) {
            throw new IllegalStateException("Only precedence DFAs may contain a precedence start state.");
        }
        if (n < 0 || n >= this.s0.edges.length) {
            return null;
        }
        return this.s0.edges[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setPrecedenceStartState(int n, DFAState dFAState) {
        if (!this.isPrecedenceDfa()) {
            throw new IllegalStateException("Only precedence DFAs may contain a precedence start state.");
        }
        if (n < 0) {
            return;
        }
        DFAState dFAState2 = this.s0;
        synchronized (dFAState2) {
            if (n >= this.s0.edges.length) {
                this.s0.edges = Arrays.copyOf(this.s0.edges, n + 1);
            }
            this.s0.edges[n] = dFAState;
        }
    }

    @Deprecated
    public final void setPrecedenceDfa(boolean bl) {
        if (bl != this.isPrecedenceDfa()) {
            throw new UnsupportedOperationException("The precedenceDfa field cannot change after a DFA is constructed.");
        }
    }

    public List<DFAState> getStates() {
        ArrayList<DFAState> arrayList = new ArrayList<DFAState>(this.states.keySet());
        Collections.sort(arrayList, new Comparator<DFAState>(){

            @Override
            public int compare(DFAState dFAState, DFAState dFAState2) {
                return dFAState.stateNumber - dFAState2.stateNumber;
            }
        });
        return arrayList;
    }

    public String toString() {
        return this.toString(VocabularyImpl.EMPTY_VOCABULARY);
    }

    @Deprecated
    public String toString(String[] stringArray) {
        if (this.s0 == null) {
            return "";
        }
        DFASerializer dFASerializer = new DFASerializer(this, stringArray);
        return dFASerializer.toString();
    }

    public String toString(Vocabulary vocabulary) {
        if (this.s0 == null) {
            return "";
        }
        DFASerializer dFASerializer = new DFASerializer(this, vocabulary);
        return dFASerializer.toString();
    }

    public String toLexerString() {
        if (this.s0 == null) {
            return "";
        }
        LexerDFASerializer lexerDFASerializer = new LexerDFASerializer(this);
        return lexerDFASerializer.toString();
    }
}

