/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.runtime.dfa;

import java.util.Arrays;
import java.util.List;
import org.antlr.v4.runtime.Vocabulary;
import org.antlr.v4.runtime.VocabularyImpl;
import org.antlr.v4.runtime.dfa.DFA;
import org.antlr.v4.runtime.dfa.DFAState;

public class DFASerializer {
    private final DFA dfa;
    private final Vocabulary vocabulary;

    @Deprecated
    public DFASerializer(DFA dFA, String[] stringArray) {
        this(dFA, VocabularyImpl.fromTokenNames(stringArray));
    }

    public DFASerializer(DFA dFA, Vocabulary vocabulary) {
        this.dfa = dFA;
        this.vocabulary = vocabulary;
    }

    public String toString() {
        if (this.dfa.s0 == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        List<DFAState> list2 = this.dfa.getStates();
        for (DFAState dFAState : list2) {
            int n = 0;
            if (dFAState.edges != null) {
                n = dFAState.edges.length;
            }
            for (int i = 0; i < n; ++i) {
                DFAState dFAState2 = dFAState.edges[i];
                if (dFAState2 == null || dFAState2.stateNumber == Integer.MAX_VALUE) continue;
                stringBuilder.append(this.getStateString(dFAState));
                String string = this.getEdgeLabel(i);
                stringBuilder.append("-").append(string).append("->").append(this.getStateString(dFAState2)).append('\n');
            }
        }
        String string = stringBuilder.toString();
        if (string.length() == 0) {
            return null;
        }
        return string;
    }

    protected String getEdgeLabel(int n) {
        return this.vocabulary.getDisplayName(n - 1);
    }

    protected String getStateString(DFAState dFAState) {
        int n = dFAState.stateNumber;
        String string = (dFAState.isAcceptState ? ":" : "") + "s" + n + (dFAState.requiresFullContext ? "^" : "");
        if (dFAState.isAcceptState) {
            if (dFAState.predicates != null) {
                return string + "=>" + Arrays.toString(dFAState.predicates);
            }
            return string + "=>" + dFAState.prediction;
        }
        return string;
    }
}

