/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.runtime.misc;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.antlr.v4.runtime.misc.AbstractEqualityComparator;
import org.antlr.v4.runtime.misc.MurmurHash;
import org.antlr.v4.runtime.misc.ObjectEqualityComparator;

public class Array2DHashSet<T>
implements Set<T> {
    public static final int INITAL_CAPACITY = 16;
    public static final int INITAL_BUCKET_CAPACITY = 8;
    public static final double LOAD_FACTOR = 0.75;
    protected final AbstractEqualityComparator<? super T> comparator;
    protected T[][] buckets;
    protected int n = 0;
    protected int threshold = (int)Math.floor(12.0);
    protected int currentPrime = 1;
    protected int initialBucketCapacity = 8;

    public Array2DHashSet() {
        this(null, 16, 8);
    }

    public Array2DHashSet(AbstractEqualityComparator<? super T> abstractEqualityComparator) {
        this(abstractEqualityComparator, 16, 8);
    }

    public Array2DHashSet(AbstractEqualityComparator<? super T> objectEqualityComparator, int n, int n2) {
        if (objectEqualityComparator == null) {
            objectEqualityComparator = ObjectEqualityComparator.INSTANCE;
        }
        this.comparator = objectEqualityComparator;
        this.buckets = this.createBuckets(n);
        this.initialBucketCapacity = n2;
    }

    public final T getOrAdd(T t) {
        if (this.n > this.threshold) {
            this.expand();
        }
        return this.getOrAddImpl(t);
    }

    protected T getOrAddImpl(T t) {
        int n;
        int n2 = this.getBucket(t);
        T[] TArray = this.buckets[n2];
        if (TArray == null) {
            TArray = this.createBucket(this.initialBucketCapacity);
            TArray[0] = t;
            this.buckets[n2] = TArray;
            ++this.n;
            return t;
        }
        for (n = 0; n < TArray.length; ++n) {
            T t2 = TArray[n];
            if (t2 == null) {
                TArray[n] = t;
                ++this.n;
                return t;
            }
            if (!this.comparator.equals(t2, t)) continue;
            return t2;
        }
        n = TArray.length;
        TArray = Arrays.copyOf(TArray, TArray.length * 2);
        this.buckets[n2] = TArray;
        TArray[n] = t;
        ++this.n;
        return t;
    }

    public T get(T t) {
        if (t == null) {
            return t;
        }
        int n = this.getBucket(t);
        T[] TArray = this.buckets[n];
        if (TArray == null) {
            return null;
        }
        for (T t2 : TArray) {
            if (t2 == null) {
                return null;
            }
            if (!this.comparator.equals(t2, t)) continue;
            return t2;
        }
        return null;
    }

    protected final int getBucket(T t) {
        int n = this.comparator.hashCode(t);
        int n2 = n & this.buckets.length - 1;
        return n2;
    }

    @Override
    public int hashCode() {
        int n = MurmurHash.initialize();
        for (T[] TArray : this.buckets) {
            if (TArray == null) continue;
            for (T t : TArray) {
                if (t == null) break;
                n = MurmurHash.update(n, this.comparator.hashCode(t));
            }
        }
        n = MurmurHash.finish(n, this.size());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Array2DHashSet)) {
            return false;
        }
        Array2DHashSet array2DHashSet = (Array2DHashSet)object;
        if (array2DHashSet.size() != this.size()) {
            return false;
        }
        boolean bl = this.containsAll(array2DHashSet);
        return bl;
    }

    protected void expand() {
        T[][] TArray = this.buckets;
        this.currentPrime += 4;
        int n = this.buckets.length * 2;
        T[][] TArray2 = this.createBuckets(n);
        int[] nArray = new int[TArray2.length];
        this.buckets = TArray2;
        this.threshold = (int)((double)n * 0.75);
        int n2 = this.size();
        for (T[] TArray3 : TArray) {
            if (TArray3 == null) continue;
            for (T t : TArray3) {
                T[] TArray4;
                if (t == null) break;
                int n3 = this.getBucket(t);
                int n4 = nArray[n3];
                if (n4 == 0) {
                    TArray4 = this.createBucket(this.initialBucketCapacity);
                    TArray2[n3] = TArray4;
                } else {
                    TArray4 = TArray2[n3];
                    if (n4 == TArray4.length) {
                        TArray4 = Arrays.copyOf(TArray4, TArray4.length * 2);
                        TArray2[n3] = TArray4;
                    }
                }
                TArray4[n4] = t;
                int n5 = n3;
                nArray[n5] = nArray[n5] + 1;
            }
        }
        assert (this.n == n2);
    }

    @Override
    public final boolean add(T t) {
        T t2 = this.getOrAdd(t);
        return t2 == t;
    }

    @Override
    public final int size() {
        return this.n;
    }

    @Override
    public final boolean isEmpty() {
        return this.n == 0;
    }

    @Override
    public final boolean contains(Object object) {
        return this.containsFast(this.asElementType(object));
    }

    public boolean containsFast(T t) {
        if (t == null) {
            return false;
        }
        return this.get(t) != null;
    }

    @Override
    public Iterator<T> iterator() {
        return new SetIterator(this.toArray());
    }

    @Override
    public T[] toArray() {
        T[] TArray = this.createBucket(this.size());
        int n = 0;
        for (T[] TArray2 : this.buckets) {
            if (TArray2 == null) continue;
            for (T t : TArray2) {
                if (t == null) break;
                TArray[n++] = t;
            }
        }
        return TArray;
    }

    @Override
    public <U> U[] toArray(U[] UArray) {
        if (UArray.length < this.size()) {
            UArray = Arrays.copyOf(UArray, this.size());
        }
        int n = 0;
        for (T[] TArray : this.buckets) {
            if (TArray == null) continue;
            for (T t : TArray) {
                if (t == null) break;
                T t2 = t;
                UArray[n++] = t2;
            }
        }
        return UArray;
    }

    @Override
    public final boolean remove(Object object) {
        return this.removeFast(this.asElementType(object));
    }

    public boolean removeFast(T t) {
        if (t == null) {
            return false;
        }
        int n = this.getBucket(t);
        T[] TArray = this.buckets[n];
        if (TArray == null) {
            return false;
        }
        for (int i = 0; i < TArray.length; ++i) {
            T t2 = TArray[i];
            if (t2 == null) {
                return false;
            }
            if (!this.comparator.equals(t2, t)) continue;
            System.arraycopy(TArray, i + 1, TArray, i, TArray.length - i - 1);
            TArray[TArray.length - 1] = null;
            --this.n;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        if (collection instanceof Array2DHashSet) {
            Array2DHashSet array2DHashSet = (Array2DHashSet)collection;
            for (T[] TArray : array2DHashSet.buckets) {
                if (TArray == null) continue;
                for (T t : TArray) {
                    if (t == null) break;
                    if (this.containsFast(this.asElementType(t))) continue;
                    return false;
                }
            }
        } else {
            for (Object obj : collection) {
                if (this.containsFast(this.asElementType(obj))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        boolean bl = false;
        for (T t : collection) {
            T t2 = this.getOrAdd(t);
            if (t2 == t) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        int n = 0;
        for (T[] TArray : this.buckets) {
            int n2;
            if (TArray == null) continue;
            int n3 = 0;
            for (n2 = 0; n2 < TArray.length && TArray[n2] != null; ++n2) {
                if (!collection.contains(TArray[n2])) continue;
                if (n2 != n3) {
                    TArray[n3] = TArray[n2];
                }
                ++n3;
                ++n;
            }
            n += n3;
            while (n3 < n2) {
                TArray[n3] = null;
                ++n3;
            }
        }
        boolean bl = n != this.n;
        this.n = n;
        return bl;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean bl = false;
        for (Object obj : collection) {
            bl |= this.removeFast(this.asElementType(obj));
        }
        return bl;
    }

    @Override
    public void clear() {
        this.buckets = this.createBuckets(16);
        this.n = 0;
        this.threshold = (int)Math.floor(12.0);
    }

    public String toString() {
        if (this.size() == 0) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        boolean bl = true;
        for (T[] TArray : this.buckets) {
            if (TArray == null) continue;
            for (T t : TArray) {
                if (t == null) break;
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(t.toString());
            }
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public String toTableString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (T[] TArray : this.buckets) {
            if (TArray == null) {
                stringBuilder.append("null\n");
                continue;
            }
            stringBuilder.append('[');
            boolean bl = true;
            for (T t : TArray) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(" ");
                }
                if (t == null) {
                    stringBuilder.append("_");
                    continue;
                }
                stringBuilder.append(t.toString());
            }
            stringBuilder.append("]\n");
        }
        return stringBuilder.toString();
    }

    protected T asElementType(Object object) {
        return (T)object;
    }

    protected T[][] createBuckets(int n) {
        return new Object[n][];
    }

    protected T[] createBucket(int n) {
        return new Object[n];
    }

    protected class SetIterator
    implements Iterator<T> {
        final T[] data;
        int nextIndex = 0;
        boolean removed = true;

        public SetIterator(T[] TArray) {
            this.data = TArray;
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex < this.data.length;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.removed = false;
            return this.data[this.nextIndex++];
        }

        @Override
        public void remove() {
            if (this.removed) {
                throw new IllegalStateException();
            }
            Array2DHashSet.this.remove(this.data[this.nextIndex - 1]);
            this.removed = true;
        }
    }
}

