/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.runtime.misc;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.antlr.v4.runtime.Vocabulary;
import org.antlr.v4.runtime.VocabularyImpl;
import org.antlr.v4.runtime.misc.IntSet;
import org.antlr.v4.runtime.misc.IntegerList;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.misc.MurmurHash;

public class IntervalSet
implements IntSet {
    public static final IntervalSet COMPLETE_CHAR_SET = IntervalSet.of(0, 0x10FFFF);
    public static final IntervalSet EMPTY_SET;
    protected List<Interval> intervals;
    protected boolean readonly;

    public IntervalSet(List<Interval> list2) {
        this.intervals = list2;
    }

    public IntervalSet(IntervalSet intervalSet) {
        this(new int[0]);
        this.addAll(intervalSet);
    }

    public IntervalSet(int ... nArray) {
        if (nArray == null) {
            this.intervals = new ArrayList<Interval>(2);
        } else {
            this.intervals = new ArrayList<Interval>(nArray.length);
            for (int n : nArray) {
                this.add(n);
            }
        }
    }

    public static IntervalSet of(int n) {
        IntervalSet intervalSet = new IntervalSet(new int[0]);
        intervalSet.add(n);
        return intervalSet;
    }

    public static IntervalSet of(int n, int n2) {
        IntervalSet intervalSet = new IntervalSet(new int[0]);
        intervalSet.add(n, n2);
        return intervalSet;
    }

    public void clear() {
        if (this.readonly) {
            throw new IllegalStateException("can't alter readonly IntervalSet");
        }
        this.intervals.clear();
    }

    @Override
    public void add(int n) {
        if (this.readonly) {
            throw new IllegalStateException("can't alter readonly IntervalSet");
        }
        this.add(n, n);
    }

    public void add(int n, int n2) {
        this.add(Interval.of(n, n2));
    }

    protected void add(Interval interval) {
        if (this.readonly) {
            throw new IllegalStateException("can't alter readonly IntervalSet");
        }
        if (interval.b < interval.a) {
            return;
        }
        ListIterator<Interval> listIterator = this.intervals.listIterator();
        while (listIterator.hasNext()) {
            Interval interval2 = listIterator.next();
            if (interval.equals(interval2)) {
                return;
            }
            if (interval.adjacent(interval2) || !interval.disjoint(interval2)) {
                Interval interval3;
                Interval interval4 = interval.union(interval2);
                listIterator.set(interval4);
                while (listIterator.hasNext() && (interval4.adjacent(interval3 = listIterator.next()) || !interval4.disjoint(interval3))) {
                    listIterator.remove();
                    listIterator.previous();
                    listIterator.set(interval4.union(interval3));
                    listIterator.next();
                }
                return;
            }
            if (!interval.startsBeforeDisjoint(interval2)) continue;
            listIterator.previous();
            listIterator.add(interval);
            return;
        }
        this.intervals.add(interval);
    }

    public static IntervalSet or(IntervalSet[] intervalSetArray) {
        IntervalSet intervalSet = new IntervalSet(new int[0]);
        for (IntervalSet intervalSet2 : intervalSetArray) {
            intervalSet.addAll(intervalSet2);
        }
        return intervalSet;
    }

    @Override
    public IntervalSet addAll(IntSet intSet) {
        if (intSet == null) {
            return this;
        }
        if (intSet instanceof IntervalSet) {
            IntervalSet intervalSet = (IntervalSet)intSet;
            int n = intervalSet.intervals.size();
            for (int i = 0; i < n; ++i) {
                Interval interval = intervalSet.intervals.get(i);
                this.add(interval.a, interval.b);
            }
        } else {
            for (int n : intSet.toList()) {
                this.add(n);
            }
        }
        return this;
    }

    public IntervalSet complement(int n, int n2) {
        return this.complement(IntervalSet.of(n, n2));
    }

    @Override
    public IntervalSet complement(IntSet intSet) {
        IntervalSet intervalSet;
        if (intSet == null || intSet.isNil()) {
            return null;
        }
        if (intSet instanceof IntervalSet) {
            intervalSet = (IntervalSet)intSet;
        } else {
            intervalSet = new IntervalSet(new int[0]);
            intervalSet.addAll(intSet);
        }
        return intervalSet.subtract(this);
    }

    @Override
    public IntervalSet subtract(IntSet intSet) {
        if (intSet == null || intSet.isNil()) {
            return new IntervalSet(this);
        }
        if (intSet instanceof IntervalSet) {
            return IntervalSet.subtract(this, (IntervalSet)intSet);
        }
        IntervalSet intervalSet = new IntervalSet(new int[0]);
        intervalSet.addAll(intSet);
        return IntervalSet.subtract(this, intervalSet);
    }

    public static IntervalSet subtract(IntervalSet intervalSet, IntervalSet intervalSet2) {
        if (intervalSet == null || intervalSet.isNil()) {
            return new IntervalSet(new int[0]);
        }
        IntervalSet intervalSet3 = new IntervalSet(intervalSet);
        if (intervalSet2 == null || intervalSet2.isNil()) {
            return intervalSet3;
        }
        int n = 0;
        int n2 = 0;
        while (n < intervalSet3.intervals.size() && n2 < intervalSet2.intervals.size()) {
            Interval interval = intervalSet3.intervals.get(n);
            Interval interval2 = intervalSet2.intervals.get(n2);
            if (interval2.b < interval.a) {
                ++n2;
                continue;
            }
            if (interval2.a > interval.b) {
                ++n;
                continue;
            }
            Interval interval3 = null;
            Interval interval4 = null;
            if (interval2.a > interval.a) {
                interval3 = new Interval(interval.a, interval2.a - 1);
            }
            if (interval2.b < interval.b) {
                interval4 = new Interval(interval2.b + 1, interval.b);
            }
            if (interval3 != null) {
                if (interval4 != null) {
                    intervalSet3.intervals.set(n, interval3);
                    intervalSet3.intervals.add(n + 1, interval4);
                    ++n;
                    ++n2;
                    continue;
                }
                intervalSet3.intervals.set(n, interval3);
                ++n;
                continue;
            }
            if (interval4 != null) {
                intervalSet3.intervals.set(n, interval4);
                ++n2;
                continue;
            }
            intervalSet3.intervals.remove(n);
        }
        return intervalSet3;
    }

    @Override
    public IntervalSet or(IntSet intSet) {
        IntervalSet intervalSet = new IntervalSet(new int[0]);
        intervalSet.addAll(this);
        intervalSet.addAll(intSet);
        return intervalSet;
    }

    @Override
    public IntervalSet and(IntSet intSet) {
        if (intSet == null) {
            return null;
        }
        List<Interval> list2 = this.intervals;
        List<Interval> list3 = ((IntervalSet)intSet).intervals;
        IntervalSet intervalSet = null;
        int n = list2.size();
        int n2 = list3.size();
        int n3 = 0;
        int n4 = 0;
        while (n3 < n && n4 < n2) {
            Interval interval;
            Interval interval2 = list2.get(n3);
            if (interval2.startsBeforeDisjoint(interval = list3.get(n4))) {
                ++n3;
                continue;
            }
            if (interval.startsBeforeDisjoint(interval2)) {
                ++n4;
                continue;
            }
            if (interval2.properlyContains(interval)) {
                if (intervalSet == null) {
                    intervalSet = new IntervalSet(new int[0]);
                }
                intervalSet.add(interval2.intersection(interval));
                ++n4;
                continue;
            }
            if (interval.properlyContains(interval2)) {
                if (intervalSet == null) {
                    intervalSet = new IntervalSet(new int[0]);
                }
                intervalSet.add(interval2.intersection(interval));
                ++n3;
                continue;
            }
            if (interval2.disjoint(interval)) continue;
            if (intervalSet == null) {
                intervalSet = new IntervalSet(new int[0]);
            }
            intervalSet.add(interval2.intersection(interval));
            if (interval2.startsAfterNonDisjoint(interval)) {
                ++n4;
                continue;
            }
            if (!interval.startsAfterNonDisjoint(interval2)) continue;
            ++n3;
        }
        if (intervalSet == null) {
            return new IntervalSet(new int[0]);
        }
        return intervalSet;
    }

    @Override
    public boolean contains(int n) {
        int n2 = this.intervals.size();
        int n3 = 0;
        int n4 = n2 - 1;
        while (n3 <= n4) {
            int n5 = (n3 + n4) / 2;
            Interval interval = this.intervals.get(n5);
            int n6 = interval.a;
            int n7 = interval.b;
            if (n7 < n) {
                n3 = n5 + 1;
                continue;
            }
            if (n6 > n) {
                n4 = n5 - 1;
                continue;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isNil() {
        return this.intervals == null || this.intervals.isEmpty();
    }

    public int getMaxElement() {
        if (this.isNil()) {
            throw new RuntimeException("set is empty");
        }
        Interval interval = this.intervals.get(this.intervals.size() - 1);
        return interval.b;
    }

    public int getMinElement() {
        if (this.isNil()) {
            throw new RuntimeException("set is empty");
        }
        return this.intervals.get((int)0).a;
    }

    public List<Interval> getIntervals() {
        return this.intervals;
    }

    public int hashCode() {
        int n = MurmurHash.initialize();
        for (Interval interval : this.intervals) {
            n = MurmurHash.update(n, interval.a);
            n = MurmurHash.update(n, interval.b);
        }
        n = MurmurHash.finish(n, this.intervals.size() * 2);
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !(object instanceof IntervalSet)) {
            return false;
        }
        IntervalSet intervalSet = (IntervalSet)object;
        return this.intervals.equals(intervalSet.intervals);
    }

    @Override
    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.intervals == null || this.intervals.isEmpty()) {
            return "{}";
        }
        if (this.size() > 1) {
            stringBuilder.append("{");
        }
        Iterator<Interval> iterator = this.intervals.iterator();
        while (iterator.hasNext()) {
            Interval interval = iterator.next();
            int n = interval.a;
            int n2 = interval.b;
            if (n == n2) {
                if (n == -1) {
                    stringBuilder.append("<EOF>");
                } else if (bl) {
                    stringBuilder.append("'").appendCodePoint(n).append("'");
                } else {
                    stringBuilder.append(n);
                }
            } else if (bl) {
                stringBuilder.append("'").appendCodePoint(n).append("'..'").appendCodePoint(n2).append("'");
            } else {
                stringBuilder.append(n).append("..").append(n2);
            }
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        if (this.size() > 1) {
            stringBuilder.append("}");
        }
        return stringBuilder.toString();
    }

    @Deprecated
    public String toString(String[] stringArray) {
        return this.toString(VocabularyImpl.fromTokenNames(stringArray));
    }

    public String toString(Vocabulary vocabulary) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.intervals == null || this.intervals.isEmpty()) {
            return "{}";
        }
        if (this.size() > 1) {
            stringBuilder.append("{");
        }
        Iterator<Interval> iterator = this.intervals.iterator();
        while (iterator.hasNext()) {
            Interval interval = iterator.next();
            int n = interval.a;
            int n2 = interval.b;
            if (n == n2) {
                stringBuilder.append(this.elementName(vocabulary, n));
            } else {
                for (int i = n; i <= n2; ++i) {
                    if (i > n) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(this.elementName(vocabulary, i));
                }
            }
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        if (this.size() > 1) {
            stringBuilder.append("}");
        }
        return stringBuilder.toString();
    }

    @Deprecated
    protected String elementName(String[] stringArray, int n) {
        return this.elementName(VocabularyImpl.fromTokenNames(stringArray), n);
    }

    protected String elementName(Vocabulary vocabulary, int n) {
        if (n == -1) {
            return "<EOF>";
        }
        if (n == -2) {
            return "<EPSILON>";
        }
        return vocabulary.getDisplayName(n);
    }

    @Override
    public int size() {
        int n = 0;
        int n2 = this.intervals.size();
        if (n2 == 1) {
            Interval interval = this.intervals.get(0);
            return interval.b - interval.a + 1;
        }
        for (int i = 0; i < n2; ++i) {
            Interval interval = this.intervals.get(i);
            n += interval.b - interval.a + 1;
        }
        return n;
    }

    public IntegerList toIntegerList() {
        IntegerList integerList = new IntegerList(this.size());
        int n = this.intervals.size();
        for (int i = 0; i < n; ++i) {
            Interval interval = this.intervals.get(i);
            int n2 = interval.a;
            int n3 = interval.b;
            for (int j = n2; j <= n3; ++j) {
                integerList.add(j);
            }
        }
        return integerList;
    }

    @Override
    public List<Integer> toList() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = this.intervals.size();
        for (int i = 0; i < n; ++i) {
            Interval interval = this.intervals.get(i);
            int n2 = interval.a;
            int n3 = interval.b;
            for (int j = n2; j <= n3; ++j) {
                arrayList.add(j);
            }
        }
        return arrayList;
    }

    public Set<Integer> toSet() {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (Interval interval : this.intervals) {
            int n = interval.a;
            int n2 = interval.b;
            for (int i = n; i <= n2; ++i) {
                hashSet.add(i);
            }
        }
        return hashSet;
    }

    public int get(int n) {
        int n2 = this.intervals.size();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            Interval interval = this.intervals.get(i);
            int n4 = interval.a;
            int n5 = interval.b;
            for (int j = n4; j <= n5; ++j) {
                if (n3 == n) {
                    return j;
                }
                ++n3;
            }
        }
        return -1;
    }

    public int[] toArray() {
        return this.toIntegerList().toArray();
    }

    @Override
    public void remove(int n) {
        if (this.readonly) {
            throw new IllegalStateException("can't alter readonly IntervalSet");
        }
        int n2 = this.intervals.size();
        for (int i = 0; i < n2; ++i) {
            Interval interval = this.intervals.get(i);
            int n3 = interval.a;
            int n4 = interval.b;
            if (n < n3) break;
            if (n == n3 && n == n4) {
                this.intervals.remove(i);
                break;
            }
            if (n == n3) {
                ++interval.a;
                break;
            }
            if (n == n4) {
                --interval.b;
                break;
            }
            if (n <= n3 || n >= n4) continue;
            int n5 = interval.b;
            interval.b = n - 1;
            this.add(n + 1, n5);
        }
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean bl) {
        if (this.readonly && !bl) {
            throw new IllegalStateException("can't alter readonly IntervalSet");
        }
        this.readonly = bl;
    }

    static {
        COMPLETE_CHAR_SET.setReadonly(true);
        EMPTY_SET = new IntervalSet(new int[0]);
        EMPTY_SET.setReadonly(true);
    }
}

