/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.runtime.tree.pattern;

import java.util.Collections;
import java.util.List;
import org.antlr.v4.runtime.misc.MultiMap;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.pattern.ParseTreePattern;

public class ParseTreeMatch {
    private final ParseTree tree;
    private final ParseTreePattern pattern;
    private final MultiMap<String, ParseTree> labels;
    private final ParseTree mismatchedNode;

    public ParseTreeMatch(ParseTree parseTree, ParseTreePattern parseTreePattern, MultiMap<String, ParseTree> multiMap, ParseTree parseTree2) {
        if (parseTree == null) {
            throw new IllegalArgumentException("tree cannot be null");
        }
        if (parseTreePattern == null) {
            throw new IllegalArgumentException("pattern cannot be null");
        }
        if (multiMap == null) {
            throw new IllegalArgumentException("labels cannot be null");
        }
        this.tree = parseTree;
        this.pattern = parseTreePattern;
        this.labels = multiMap;
        this.mismatchedNode = parseTree2;
    }

    public ParseTree get(String string) {
        List list2 = (List)this.labels.get(string);
        if (list2 == null || list2.size() == 0) {
            return null;
        }
        return (ParseTree)list2.get(list2.size() - 1);
    }

    public List<ParseTree> getAll(String string) {
        List list2 = (List)this.labels.get(string);
        if (list2 == null) {
            return Collections.emptyList();
        }
        return list2;
    }

    public MultiMap<String, ParseTree> getLabels() {
        return this.labels;
    }

    public ParseTree getMismatchedNode() {
        return this.mismatchedNode;
    }

    public boolean succeeded() {
        return this.mismatchedNode == null;
    }

    public ParseTreePattern getPattern() {
        return this.pattern;
    }

    public ParseTree getTree() {
        return this.tree;
    }

    public String toString() {
        return String.format("Match %s; found %d labels", this.succeeded() ? "succeeded" : "failed", this.getLabels().size());
    }
}

