/*
 * Decompiled with CFR 0.152.
 */
package cn.inrhor.imipetcore.api.entity.ai.universal;

import cn.inrhor.imipetcore.api.entity.PetEntity;
import cn.inrhor.imipetcore.api.entity.ai.Controller;
import cn.inrhor.imipetcore.api.entity.ai.universal.UniversalAi;
import cn.inrhor.imipetcore.common.database.data.PetData;
import cn.inrhor.imipetcore.common.location.PositionKt;
import cn.inrhor.imipetcore.taboolib.module.ai.SimpleAiExecutorKt;
import kotlin.Metadata;
import kotlin180.jvm.internal.Intrinsics;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0017"}, d2={"Lcn/inrhor/imipetcore/api/entity/ai/universal/UniversalAiWalk;", "Lcn/inrhor/imipetcore/api/entity/ai/universal/UniversalAi;", "petEntity", "Lcn/inrhor/imipetcore/api/entity/PetEntity;", "(Lcn/inrhor/imipetcore/api/entity/PetEntity;)V", "owner", "Lorg/bukkit/entity/Player;", "getOwner", "()Lorg/bukkit/entity/Player;", "pet", "Lorg/bukkit/entity/LivingEntity;", "getPet", "()Lorg/bukkit/entity/LivingEntity;", "petData", "Lcn/inrhor/imipetcore/common/database/data/PetData;", "getPetData", "()Lcn/inrhor/imipetcore/common/database/data/PetData;", "getPetEntity", "()Lcn/inrhor/imipetcore/api/entity/PetEntity;", "shouldExecute", "", "updateTask", "", "imiPetCore"})
public final class UniversalAiWalk
extends UniversalAi {
    @NotNull
    private final PetEntity petEntity;
    @NotNull
    private final Player owner;
    @NotNull
    private final PetData petData;
    @Nullable
    private final LivingEntity pet;

    public UniversalAiWalk(@NotNull PetEntity petEntity) {
        Intrinsics.checkNotNullParameter((Object)petEntity, (String)"petEntity");
        this.petEntity = petEntity;
        this.owner = this.petEntity.getOwner();
        this.petData = this.petEntity.getPetData();
        this.pet = this.petEntity.getEntity();
    }

    @NotNull
    public final PetEntity getPetEntity() {
        return this.petEntity;
    }

    @NotNull
    public final Player getOwner() {
        return this.owner;
    }

    @NotNull
    public final PetData getPetData() {
        return this.petData;
    }

    @Nullable
    public final LivingEntity getPet() {
        return this.pet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean shouldExecute() {
        if (this.petData.isDead()) return false;
        if (!this.owner.isOnline()) return false;
        if (this.owner.isDead()) return false;
        LivingEntity livingEntity = this.pet;
        double d = livingEntity != null ? PositionKt.distanceLoc((Entity)livingEntity, (Entity)this.owner) : 0.0;
        if (!(d > 6.0)) return false;
        return true;
    }

    @Override
    public void updateTask() {
        if (this.pet == null) {
            return;
        }
        Controller.INSTANCE.attackEntity(this.pet, null);
        if (PositionKt.distanceLoc((Entity)this.pet, (Entity)this.owner) > 16.0) {
            this.pet.teleport((Entity)this.owner);
        } else {
            Location location = this.owner.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"owner.location");
            SimpleAiExecutorKt.navigationMove(this.pet, location, 1.2);
        }
    }
}

