/*
 * Decompiled with CFR 0.152.
 */
package cn.inrhor.imipetcore.common.listener.pet;

import cn.inrhor.imipetcore.api.event.PetDeathEvent;
import cn.inrhor.imipetcore.api.manager.MetaManager;
import cn.inrhor.imipetcore.api.manager.PetManager;
import cn.inrhor.imipetcore.common.database.data.PetData;
import cn.inrhor.imipetcore.common.option.PetOptionKt;
import cn.inrhor.imipetcore.common.option.TriggerOption;
import cn.inrhor.imipetcore.taboolib.common.platform.event.SubscribeEvent;
import kotlin.Metadata;
import kotlin180.jvm.internal.Intrinsics;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\bH\u0007J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a8\u0006\r"}, d2={"Lcn/inrhor/imipetcore/common/listener/pet/PetDamage;", "", "()V", "damage", "", "ev", "Lorg/bukkit/event/entity/EntityDamageEvent;", "death", "Lorg/bukkit/event/entity/EntityDeathEvent;", "fire", "Lorg/bukkit/event/entity/EntityCombustEvent;", "petDeath", "Lcn/inrhor/imipetcore/api/event/PetDeathEvent;", "imiPetCore"})
public final class PetDamage {
    @NotNull
    public static final PetDamage INSTANCE = new PetDamage();

    private PetDamage() {
    }

    @SubscribeEvent
    public final void damage(@NotNull EntityDamageEvent ev) {
        Intrinsics.checkNotNullParameter((Object)ev, (String)"ev");
        if (ev.isCancelled()) {
            return;
        }
        Entity entity = ev.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"ev.entity");
        Entity entity2 = entity;
        if (ev.getCause() == EntityDamageEvent.DamageCause.SUFFOCATION) {
            if (entity2.hasMetadata("imipetcore_entity")) {
                ev.setCancelled(true);
            }
        } else {
            Player player = MetaManager.INSTANCE.getOwner(entity2);
            if (player == null) {
                return;
            }
            Player owner = player;
            PetData petData = MetaManager.INSTANCE.getPetData(entity2, owner);
            if (petData == null) {
                return;
            }
            PetData petData2 = petData;
            if (ev.getCause() == EntityDamageEvent.DamageCause.ENTITY_ATTACK) {
                return;
            }
            PetManager.INSTANCE.delCurrentHP(owner, petData2, ev.getDamage());
        }
    }

    @SubscribeEvent
    public final void fire(@NotNull EntityCombustEvent ev) {
        Intrinsics.checkNotNullParameter((Object)ev, (String)"ev");
        Entity entity = ev.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"ev.entity");
        Entity entity2 = entity;
        if (entity2.hasMetadata("imipetcore_entity")) {
            ev.setCancelled(true);
        }
    }

    @SubscribeEvent
    public final void death(@NotNull EntityDeathEvent ev) {
        Intrinsics.checkNotNullParameter((Object)ev, (String)"ev");
        LivingEntity livingEntity = ev.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)livingEntity, (String)"ev.entity");
        LivingEntity entity = livingEntity;
        Player player = MetaManager.INSTANCE.getOwner((Entity)entity);
        if (player == null) {
            return;
        }
        Player owner = player;
        PetData petData = MetaManager.INSTANCE.getPetData((Entity)entity, owner);
        if (petData == null) {
            return;
        }
        PetData petData2 = petData;
        ev.getDrops().clear();
        ev.setDroppedExp(0);
        new PetDeathEvent(owner, petData2).call();
    }

    @SubscribeEvent
    public final void petDeath(@NotNull PetDeathEvent ev) {
        Intrinsics.checkNotNullParameter((Object)((Object)ev), (String)"ev");
        PetData petData = ev.getPetData();
        Player player = ev.getPlayer();
        PetManager.setCurrentHP$default(PetManager.INSTANCE, player, petData, 0.0, false, 4, null);
        PetOptionKt.trigger(petData, player, TriggerOption.Type.DEATH);
    }
}

