/*
 * Decompiled with CFR 0.152.
 */
package cn.inrhor.imipetcore.taboolib.common.env;

import cn.inrhor.imipetcore.taboolib.common.TabooLibCommon;
import cn.inrhor.imipetcore.taboolib.common.env.ClassAppender;
import cn.inrhor.imipetcore.taboolib.common.env.Dependency;
import cn.inrhor.imipetcore.taboolib.common.env.DependencyDownloader;
import cn.inrhor.imipetcore.taboolib.common.env.DependencyScope;
import cn.inrhor.imipetcore.taboolib.common.env.JarRelocation;
import cn.inrhor.imipetcore.taboolib.common.env.KotlinEnv;
import cn.inrhor.imipetcore.taboolib.common.env.KotlinEnvNoRelocate;
import cn.inrhor.imipetcore.taboolib.common.env.Repository;
import cn.inrhor.imipetcore.taboolib.common.env.RuntimeDependencies;
import cn.inrhor.imipetcore.taboolib.common.env.RuntimeDependency;
import cn.inrhor.imipetcore.taboolib.common.env.RuntimeResource;
import cn.inrhor.imipetcore.taboolib.common.env.RuntimeResources;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RuntimeEnv {
    public static final RuntimeEnv ENV = new RuntimeEnv();
    private static final String ENV_FILE_NAME = "env.properties";
    private static final Properties ENV_PROPERTIES = new Properties();
    private static String defaultAssets = "assets";
    private static String defaultLibrary = "libs";
    private static String defaultRepositoryCentral = "https://maven.aliyun.com/repository/central";

    RuntimeEnv() {
        try {
            File env;
            File libs = new File("libs", "custom.txt");
            if (libs.exists()) {
                defaultLibrary = Files.readAllLines(libs.toPath(), StandardCharsets.UTF_8).get(0);
            }
            if ((env = new File(ENV_FILE_NAME)).exists()) {
                ENV_PROPERTIES.load(Files.newInputStream(Paths.get(ENV_FILE_NAME, new String[0]), new OpenOption[0]));
                defaultAssets = ENV_PROPERTIES.getProperty("assets", defaultAssets);
                defaultLibrary = ENV_PROPERTIES.getProperty("library", defaultLibrary);
                defaultRepositoryCentral = ENV_PROPERTIES.getProperty("repository-central", defaultRepositoryCentral);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setup() {
        try {
            this.loadDependency(KotlinEnv.class, true);
        }
        catch (NoClassDefFoundError ignored) {
            try {
                this.loadDependency(KotlinEnvNoRelocate.class, true);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
    }

    public void inject(@NotNull Class<?> clazz) {
        this.loadAssets(clazz);
        this.loadDependency(clazz, false);
    }

    public void loadAssets(@NotNull Class<?> clazz) {
        RuntimeResource[] resources = null;
        if (clazz.isAnnotationPresent(RuntimeResource.class)) {
            resources = (RuntimeResource[])clazz.getAnnotationsByType(RuntimeResource.class);
        } else {
            RuntimeResources annotation = clazz.getAnnotation(RuntimeResources.class);
            if (annotation != null) {
                resources = annotation.value();
            }
        }
        if (resources == null) {
            return;
        }
        for (RuntimeResource resource2 : resources) {
            this.loadAssets(resource2.name(), resource2.hash(), resource2.value(), resource2.zip());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAssets(String name2, String hash, String url, boolean zip) {
        block32: {
            File file = name2.isEmpty() ? new File(defaultAssets, hash.substring(0, 2) + "/" + hash) : new File(defaultAssets, name2);
            if (file.exists() && DependencyDownloader.readFileHash(file).equals(hash)) {
                return;
            }
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            TabooLibCommon.print("Downloading assets " + url.substring(url.lastIndexOf(47) + 1));
            try {
                if (zip) {
                    File cacheFile = new File(file.getParentFile(), file.getName() + ".zip");
                    Repository.downloadToFile(new URL(url + ".zip"), cacheFile);
                    try (ZipFile zipFile = new ZipFile(cacheFile);){
                        InputStream inputStream = zipFile.getInputStream(zipFile.getEntry(url.substring(url.lastIndexOf(47) + 1)));
                        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                            fileOutputStream.write(DependencyDownloader.readFully(inputStream));
                            break block32;
                        }
                    }
                    finally {
                        cacheFile.delete();
                    }
                }
                Repository.downloadToFile(new URL(url), file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean test(String path) {
        String test = path.startsWith("!") ? path.substring(1) : path;
        return test.length() > 0 && ClassAppender.isExists(test);
    }

    public void loadDependency(@NotNull Class<?> clazz, boolean initiative) {
        File baseFile = new File(defaultLibrary);
        RuntimeDependency[] dependencies = null;
        if (clazz.isAnnotationPresent(RuntimeDependency.class)) {
            dependencies = (RuntimeDependency[])clazz.getAnnotationsByType(RuntimeDependency.class);
        } else {
            RuntimeDependencies annotation = clazz.getAnnotation(RuntimeDependencies.class);
            if (annotation != null) {
                dependencies = annotation.value();
            }
        }
        if (dependencies != null) {
            for (RuntimeDependency dependency : dependencies) {
                if (dependency.initiative() && !initiative) continue;
                String allTest = dependency.test();
                ArrayList<String> tests = new ArrayList<String>();
                if (allTest.contains(",")) {
                    tests.addAll(Arrays.asList(allTest.split(",")));
                } else {
                    tests.add(allTest);
                }
                if (tests.stream().allMatch(this::test)) continue;
                ArrayList<JarRelocation> relocation = new ArrayList<JarRelocation>();
                String[] relocate = dependency.relocate();
                if (relocate.length % 2 != 0) {
                    throw new IllegalArgumentException("unformatted relocate");
                }
                int i = 0;
                while (i + 1 < relocate.length) {
                    String pattern = relocate[i].startsWith("!") ? relocate[i].substring(1) : relocate[i];
                    String relocatePattern = relocate[i + 1].startsWith("!") ? relocate[i + 1].substring(1) : relocate[i + 1];
                    relocation.add(new JarRelocation(pattern, relocatePattern));
                    i += 2;
                }
                try {
                    String url = dependency.value().startsWith("!") ? dependency.value().substring(1) : dependency.value();
                    this.loadDependency(url, baseFile, relocation, dependency.repository(), dependency.ignoreOptional(), dependency.ignoreException(), dependency.transitive(), dependency.isolated(), dependency.initiative(), dependency.scopes());
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public void loadDependency(@NotNull String url) throws IOException {
        this.loadDependency(url, new File(defaultLibrary));
    }

    public void loadDependency(@NotNull String url, @Nullable String repository) throws IOException {
        this.loadDependency(url, new File(defaultLibrary), repository);
    }

    public void loadDependency(@NotNull String url, @NotNull List<JarRelocation> relocation) throws IOException {
        this.loadDependency(url, new File(defaultLibrary), relocation, null, true, false, true, false, false, new DependencyScope[]{DependencyScope.RUNTIME, DependencyScope.COMPILE});
    }

    public void loadDependency(@NotNull String url, @NotNull File baseDir) throws IOException {
        this.loadDependency(url, baseDir, null);
    }

    public void loadDependency(@NotNull String url, @NotNull File baseDir, @Nullable String repository) throws IOException {
        this.loadDependency(url, baseDir, new ArrayList<JarRelocation>(), repository, true, false, true, false, false, new DependencyScope[]{DependencyScope.RUNTIME, DependencyScope.COMPILE});
    }

    public void loadDependency(@NotNull String url, @NotNull File baseDir, @NotNull List<JarRelocation> relocation, @Nullable String repository, boolean ignoreOptional, boolean ignoreException, boolean transitive, boolean isolated, boolean initiative, @NotNull DependencyScope[] dependencyScopes) throws IOException {
        String[] args = url.split(":");
        DependencyDownloader downloader = new DependencyDownloader(baseDir, relocation);
        if (repository == null || repository.isEmpty()) {
            repository = defaultRepositoryCentral;
        } else if (ENV_PROPERTIES.contains("repository-" + repository)) {
            repository = ENV_PROPERTIES.getProperty("repository-" + repository);
        }
        downloader.addRepository(new Repository(repository));
        downloader.setIgnoreOptional(ignoreOptional);
        downloader.setIgnoreException(ignoreException);
        downloader.setDependencyScopes(dependencyScopes);
        downloader.setTransitive(transitive);
        downloader.setIsolated(isolated);
        downloader.setInitiative(initiative);
        File pomFile = new File(baseDir, String.format("%s/%s/%s/%s-%s.pom", args[0].replace('.', '/'), args[1], args[2], args[1], args[2]));
        File pomShaFile = new File(pomFile.getPath() + ".sha1");
        if (pomFile.exists() && pomShaFile.exists() && DependencyDownloader.readFile(pomShaFile).startsWith(DependencyDownloader.readFileHash(pomFile))) {
            downloader.loadDependencyFromInputStream(pomFile.toPath().toUri().toURL().openStream());
        } else {
            String pom = String.format("%s/%s/%s/%s/%s-%s.pom", repository, args[0].replace('.', '/'), args[1], args[2], args[1], args[2]);
            try {
                TabooLibCommon.print(String.format("Downloading library %s:%s:%s %s", args[0], args[1], args[2], transitive ? "(transitive)" : ""));
                downloader.loadDependencyFromInputStream(new URL(pom).openStream());
            }
            catch (FileNotFoundException ex) {
                if (ex.toString().contains("@kotlin_version@")) {
                    return;
                }
                throw ex;
            }
        }
        Dependency current = new Dependency(args[0], args[1], args[2], DependencyScope.RUNTIME);
        if (transitive) {
            downloader.injectClasspath(downloader.loadDependency(downloader.getRepositories(), current));
        } else {
            downloader.injectClasspath(Collections.singleton(current));
        }
    }
}

