/*
 * Decompiled with CFR 0.152.
 */
package cn.inrhor.imipetcore.taboolib.common5;

import cn.inrhor.imipetcore.taboolib.common.Isolated;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

@Isolated
public abstract class Baffle {
    public abstract void resetAll();

    public abstract void reset(String var1);

    public abstract void next(String var1);

    public abstract boolean hasNext(String var1, boolean var2);

    public void reset() {
        this.reset("*");
    }

    public void next() {
        this.next("*");
    }

    public boolean hasNext() {
        return this.hasNext("*");
    }

    public boolean hasNext(String id2) {
        return this.hasNext(id2, true);
    }

    @NotNull
    public static Baffle of(long duration, TimeUnit timeUnit) {
        return new BaffleTime(timeUnit.toMillis(duration));
    }

    @NotNull
    public static Baffle of(int count) {
        return new BaffleCounter(count);
    }

    public static class BaffleCounter
    extends Baffle {
        private final int count;
        private final Map<String, Integer> data = Maps.newConcurrentMap();
        private final AtomicInteger globalCount = new AtomicInteger();

        public BaffleCounter(int count) {
            this.count = count;
        }

        @Override
        public void resetAll() {
            this.data.clear();
            this.globalCount.set(0);
        }

        @Override
        public void reset(String id2) {
            if (Objects.equals(id2, "*")) {
                this.globalCount.set(0);
            } else {
                this.data.remove(id2);
            }
        }

        @Override
        public void next(String id2) {
            if (Objects.equals(id2, "*")) {
                this.globalCount.getAndIncrement();
            } else {
                this.data.put(id2, this.data.computeIfAbsent(id2, a -> 0) + 1);
            }
        }

        @Override
        public boolean hasNext(String id2, boolean update2) {
            if (Objects.equals(id2, "*")) {
                if (this.globalCount.get() < this.count) {
                    if (update2) {
                        this.globalCount.getAndIncrement();
                    }
                    return false;
                }
                if (update2) {
                    this.globalCount.set(0);
                }
            } else {
                int i;
                if (this.data.containsKey(id2)) {
                    i = this.data.get(id2);
                } else {
                    i = 0;
                    this.data.put(id2, 0);
                }
                if (i < this.count) {
                    if (update2) {
                        this.data.put(id2, i + 1);
                    }
                    return false;
                }
                if (update2) {
                    this.data.put(id2, 0);
                }
            }
            return true;
        }
    }

    public static class BaffleTime
    extends Baffle {
        private final long millis;
        private final Map<String, Long> data = Maps.newConcurrentMap();
        private long globalTime;

        public BaffleTime(long millis) {
            this.millis = millis;
        }

        public long nextTime(String id2) {
            long result = Objects.equals(id2, "*") ? this.globalTime + this.millis - System.currentTimeMillis() : this.data.getOrDefault(id2, 0L) + this.millis - System.currentTimeMillis();
            return result >= 0L ? result : 0L;
        }

        @Override
        public void resetAll() {
            this.data.clear();
            this.globalTime = 0L;
        }

        @Override
        public void reset(String id2) {
            if (Objects.equals(id2, "*")) {
                this.globalTime = 0L;
            } else {
                this.data.remove(id2);
            }
        }

        @Override
        public void next(String id2) {
            if (Objects.equals(id2, "*")) {
                this.globalTime = System.currentTimeMillis();
            } else {
                this.data.put(id2, System.currentTimeMillis());
            }
        }

        @Override
        public boolean hasNext(String id2, boolean update2) {
            long time = Objects.equals(id2, "*") ? this.globalTime : this.data.getOrDefault(id2, 0L);
            if (time + this.millis < System.currentTimeMillis()) {
                if (update2) {
                    this.next(id2);
                }
                return true;
            }
            return false;
        }
    }
}

