/*
 * Decompiled with CFR 0.152.
 */
package cn.inrhor.imipetcore.taboolib.module.metrics;

import cn.inrhor.imipetcore.taboolib.common.TabooLibCommon;
import cn.inrhor.imipetcore.taboolib.common.io.File1Kt;
import cn.inrhor.imipetcore.taboolib.common.platform.Platform;
import cn.inrhor.imipetcore.taboolib.common.platform.function.AdapterKt;
import cn.inrhor.imipetcore.taboolib.common.platform.function.ExecutorKt;
import cn.inrhor.imipetcore.taboolib.common.platform.function.IOKt;
import cn.inrhor.imipetcore.taboolib.common.platform.service.PlatformExecutor;
import cn.inrhor.imipetcore.taboolib.module.configuration.SecuredFile;
import cn.inrhor.imipetcore.taboolib.module.metrics.CustomChart;
import cn.inrhor.imipetcore.taboolib.module.metrics.JsonBuilder;
import cn.inrhor.imipetcore.taboolib.module.metrics.MetricsBase;
import java.io.File;
import java.util.Map;
import java.util.UUID;
import kotlin180.Unit;
import kotlin180.jvm.functions.Function1;

public class Metrics {
    private MetricsBase metricsBase;

    public Metrics(int serviceId, String pluginVersion, Platform runningPlatform) {
        String platform;
        if (TabooLibCommon.getRunningPlatform() != runningPlatform) {
            return;
        }
        File bStatsFolder = new File(IOKt.getDataFolder().getParentFile(), "bStats");
        File configFile = File1Kt.newFile(bStatsFolder, "config.yml", true, false);
        SecuredFile config = SecuredFile.Companion.loadConfiguration(configFile);
        if (!config.contains("serverUUID")) {
            config.set("enabled", true);
            config.set("serverUUID", UUID.randomUUID().toString());
            config.set("logFailedRequests", false);
            config.set("logSentData", false);
            config.set("logResponseStatusText", false);
            config.saveToFile(configFile);
        }
        boolean enabled = config.getBoolean("enabled", true);
        String serverUUID = config.getString("serverUUID");
        boolean logErrors = config.getBoolean("logFailedRequests", false);
        boolean logSentData = config.getBoolean("logSentData", false);
        boolean logResponseStatusText = config.getBoolean("logResponseStatusText", false);
        switch (runningPlatform) {
            case UNKNOWN: 
            case BUKKIT: 
            case NUKKIT: {
                platform = "bukkit";
                break;
            }
            case BUNGEE: {
                platform = "bungeecord";
                break;
            }
            case VELOCITY: {
                platform = "velocity";
                break;
            }
            case SPONGE_API_7: 
            case SPONGE_API_8: {
                platform = "sponge";
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported");
            }
        }
        this.metricsBase = new MetricsBase(platform, serverUUID, serviceId, enabled, json -> this.appendPlatformData((JsonBuilder)json, runningPlatform), json -> this.appendServiceData((JsonBuilder)json, pluginVersion), task2 -> ExecutorKt.submit(false, false, 0L, 0L, "", (Function1<? super PlatformExecutor.PlatformTask, Unit>)((Function1)r -> {
            task2.run();
            return Unit.INSTANCE;
        })), () -> true, (message, error) -> IOKt.warning(message), xva$0 -> IOKt.info(xva$0), logErrors, logSentData, logResponseStatusText);
    }

    public void addCustomChart(CustomChart chart) {
        this.metricsBase.addCustomChart(chart);
    }

    private void appendPlatformData(JsonBuilder builder, Platform platform) {
        builder.appendField("playerAmount", AdapterKt.onlinePlayers().size());
        builder.appendField("javaVersion", System.getProperty("java.version"));
        builder.appendField("osName", System.getProperty("os.name"));
        builder.appendField("osArch", System.getProperty("os.arch"));
        builder.appendField("osVersion", System.getProperty("os.version"));
        builder.appendField("coreCount", Runtime.getRuntime().availableProcessors());
        Map<String, Object> platformData = IOKt.getPlatformData();
        for (Map.Entry<String, Object> entry : platformData.entrySet()) {
            if (entry.getValue() instanceof Integer) {
                if (platform == Platform.NUKKIT) {
                    builder.appendField(entry.getKey().replace("nukkit", "bukkit"), (Integer)entry.getValue());
                    continue;
                }
                builder.appendField(entry.getKey(), (Integer)entry.getValue());
                continue;
            }
            if (platform == Platform.NUKKIT) {
                builder.appendField(entry.getKey().replace("nukkit", "bukkit"), entry.getValue().toString());
                continue;
            }
            builder.appendField(entry.getKey(), entry.getValue().toString());
        }
    }

    private void appendServiceData(JsonBuilder builder, String version) {
        builder.appendField("pluginVersion", version);
    }
}

