/*
 * Decompiled with CFR 0.152.
 */
package cn.inrhor.imipetcore.taboolib.module.nms;

import cn.inrhor.imipetcore.taboolib.common.platform.function.IOKt;
import cn.inrhor.imipetcore.taboolib.library.reflex.Reflex;
import cn.inrhor.imipetcore.taboolib.library.reflex.UnsafeAccess;
import cn.inrhor.imipetcore.taboolib.module.nms.ItemTag;
import cn.inrhor.imipetcore.taboolib.module.nms.ItemTagData;
import cn.inrhor.imipetcore.taboolib.module.nms.ItemTagList;
import cn.inrhor.imipetcore.taboolib.module.nms.MinecraftServerUtilKt;
import cn.inrhor.imipetcore.taboolib.module.nms.MinecraftVersion;
import cn.inrhor.imipetcore.taboolib.module.nms.NMSGeneric;
import cn.inrhor.imipetcore.taboolib.module.nms.type.LightType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import net.minecraft.server.v1_12_R1.BlockPosition;
import net.minecraft.server.v1_12_R1.EntityVillager;
import net.minecraft.server.v1_12_R1.PacketPlayOutOpenSignEditor;
import net.minecraft.server.v1_13_R2.EntityTypes;
import net.minecraft.server.v1_13_R2.IRegistry;
import net.minecraft.server.v1_13_R2.NBTBase;
import net.minecraft.server.v1_13_R2.NBTTagList;
import net.minecraft.server.v1_14_R1.EntityPlayer;
import net.minecraft.server.v1_14_R1.EnumSkyBlock;
import net.minecraft.server.v1_14_R1.LightEngineBlock;
import net.minecraft.server.v1_14_R1.LightEngineLayer;
import net.minecraft.server.v1_14_R1.LightEngineLayerEventListener;
import net.minecraft.server.v1_14_R1.LightEngineSky;
import net.minecraft.server.v1_14_R1.LightEngineThreaded;
import net.minecraft.server.v1_14_R1.PacketPlayOutMapChunk;
import net.minecraft.server.v1_14_R1.SectionPosition;
import net.minecraft.server.v1_14_R1.WorldServer;
import net.minecraft.server.v1_15_R1.NBTTagFloat;
import net.minecraft.server.v1_15_R1.NBTTagInt;
import net.minecraft.server.v1_15_R1.NBTTagShort;
import net.minecraft.server.v1_16_R1.ChunkCoordIntPair;
import net.minecraft.server.v1_16_R1.IChunkProvider;
import net.minecraft.server.v1_16_R1.LightEngine;
import net.minecraft.server.v1_16_R1.PacketPlayOutLightUpdate;
import net.minecraft.server.v1_16_R1.PlayerChunk;
import net.minecraft.server.v1_16_R1.Registry;
import net.minecraft.server.v1_16_R1.WorldDataServer;
import net.minecraft.server.v1_8_R3.Item;
import net.minecraft.server.v1_8_R3.MobEffectList;
import net.minecraft.server.v1_8_R3.NBTTagByte;
import net.minecraft.server.v1_8_R3.NBTTagByteArray;
import net.minecraft.server.v1_8_R3.NBTTagCompound;
import net.minecraft.server.v1_8_R3.NBTTagDouble;
import net.minecraft.server.v1_8_R3.NBTTagIntArray;
import net.minecraft.server.v1_8_R3.NBTTagLong;
import net.minecraft.server.v1_8_R3.NBTTagString;
import net.minecraft.server.v1_9_R2.Chunk;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftVillager;
import org.bukkit.craftbukkit.v1_13_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_14_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_8_R3.inventory.CraftItemStack;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NMSGenericImpl
extends NMSGeneric {
    private Field entityTypesField;
    private Constructor packetPlayOutLightUpdateConstructor;
    private Method getKeyMethod;

    public NMSGenericImpl() {
        if (MinecraftVersion.INSTANCE.getMajor() >= 5) {
            for (Field declaredField : net.minecraft.server.v1_12_R1.Entity.class.getDeclaredFields()) {
                if (!declaredField.getType().getSimpleName().equals("EntityTypes")) continue;
                this.entityTypesField = declaredField;
                break;
            }
        }
        if (MinecraftVersion.INSTANCE.getMajor() >= 9) {
            try {
                if (MinecraftVersion.INSTANCE.getMajor() >= 10) {
                    Class<?> entityTypes = MinecraftServerUtilKt.nmsClass("EntityTypes");
                    this.getKeyMethod = entityTypes.getDeclaredMethod("a", entityTypes);
                }
                this.packetPlayOutLightUpdateConstructor = PacketPlayOutLightUpdate.class.getDeclaredConstructor(ChunkCoordIntPair.class, LightEngine.class, BitSet.class, BitSet.class, Boolean.TYPE);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    @NotNull
    public String getKey(ItemStack itemStack2) {
        if (MinecraftVersion.INSTANCE.getMajor() >= 5) {
            return itemStack2.getType().getKey().getKey();
        }
        net.minecraft.server.v1_8_R3.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)itemStack2);
        net.minecraft.server.v1_12_R1.Item item = ((net.minecraft.server.v1_12_R1.ItemStack)nmsItem).getItem();
        String name2 = (String)Reflex.Companion.getProperty(item, "name", false, false, true);
        String r = "";
        for (char c : name2.toCharArray()) {
            r = Character.isUpperCase(c) ? r + "_" + Character.toLowerCase(c) : r + c;
        }
        return r;
    }

    @Override
    @NotNull
    public String getName(ItemStack itemStack2) {
        net.minecraft.server.v1_8_R3.ItemStack obcItem = CraftItemStack.asNMSCopy((ItemStack)itemStack2);
        if (MinecraftVersion.INSTANCE.getMajor() >= 5) {
            String name2;
            if (MinecraftVersion.INSTANCE.getMajor() >= 10) {
                Item nmsItem = obcItem.getItem();
                name2 = (String)Reflex.Companion.invokeMethod(nmsItem, "getDescriptionId", new Object[0], false, true, true);
            } else {
                name2 = obcItem.getItem().getName();
            }
            if (itemStack2.getItemMeta() instanceof PotionMeta) {
                name2 = name2 + ".effect." + obcItem.getTag().getString("Potion").replaceAll("minecraft:(strong_|long_)?", "");
            }
            return name2;
        }
        if (MinecraftVersion.INSTANCE.getMajor() >= 3) {
            String name3 = ((net.minecraft.server.v1_12_R1.ItemStack)obcItem).getItem().a((net.minecraft.server.v1_12_R1.ItemStack)obcItem);
            if (itemStack2.getItemMeta() instanceof PotionMeta) {
                return name3.replace("item.", "") + ".effect." + obcItem.getTag().getString("Potion").replaceAll("(minecraft:)?(strong_|long_)?", "");
            }
            return name3 + ".name";
        }
        String name4 = obcItem.getItem().getName();
        if (itemStack2.getItemMeta() instanceof PotionMeta) {
            return name4.replace("item.", "") + ".effect." + obcItem.getTag().getString("Potion").replaceAll("(minecraft:)?(strong_|long_)?", "");
        }
        return name4 + ".name";
    }

    @Override
    @NotNull
    public String getName(Entity entity) {
        if (MinecraftVersion.INSTANCE.getMajor() >= 6) {
            net.minecraft.server.v1_14_R1.Entity nmsEntity = ((CraftEntity)entity).getHandle();
            Object minecraftKey = null;
            if (MinecraftVersion.INSTANCE.getMajor() >= 10) {
                try {
                    Object type2 = Reflex.Companion.invokeMethod(nmsEntity, "getType", new Object[0], false, true, true);
                    minecraftKey = this.getKeyMethod.invoke(null, type2);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return "entity.minecraft." + Reflex.Companion.invokeMethod(minecraftKey, "getPath", new Object[0], false, true, true);
            }
            minecraftKey = net.minecraft.server.v1_14_R1.EntityTypes.getName((net.minecraft.server.v1_14_R1.EntityTypes)nmsEntity.getEntityType());
            return "entity.minecraft." + minecraftKey.getKey();
        }
        if (MinecraftVersion.INSTANCE.getMajor() >= 5) {
            try {
                Object career;
                String name2 = "entity.minecraft." + IRegistry.ENTITY_TYPE.getKey(UnsafeAccess.INSTANCE.get(((org.bukkit.craftbukkit.v1_13_R2.entity.CraftEntity)entity).getHandle(), this.entityTypesField)).getKey();
                if (entity instanceof Villager && (career = Reflex.Companion.invokeMethod(entity, "getCareer", new Object[0], false, true, true)) != null) {
                    name2 = name2 + "." + String.valueOf(career).toLowerCase(Locale.getDefault());
                }
                return name2;
            }
            catch (Throwable t) {
                t.printStackTrace();
                return "entity.null";
            }
        }
        try {
            if (entity instanceof Player) {
                return "entity.Player.name";
            }
            if (entity instanceof Villager) {
                String name3 = "name";
                EntityVillager villager = ((CraftVillager)entity).getHandle();
                net.minecraft.server.v1_12_R1.NBTTagCompound export = new net.minecraft.server.v1_12_R1.NBTTagCompound();
                villager.b(export);
                int career = export.getInt("Career");
                switch (villager.getProfession()) {
                    case 0: {
                        if (career == 1) {
                            name3 = "farmer";
                            break;
                        }
                        if (career == 2) {
                            name3 = "fisherman";
                            break;
                        }
                        if (career == 3) {
                            name3 = "shepherd";
                            break;
                        }
                        if (career != 4) break;
                        name3 = "fletcher";
                        break;
                    }
                    case 1: {
                        if (career == 1) {
                            name3 = "librarian";
                            break;
                        }
                        if (career != 2) break;
                        name3 = "cartographer";
                        break;
                    }
                    case 2: {
                        name3 = "cleric";
                        break;
                    }
                    case 3: {
                        if (career == 1) {
                            name3 = "armor";
                            break;
                        }
                        if (career == 2) {
                            name3 = "weapon";
                            break;
                        }
                        if (career != 3) break;
                        name3 = "tool";
                        break;
                    }
                    case 4: {
                        if (career == 1) {
                            name3 = "butcher";
                            break;
                        }
                        if (career != 2) break;
                        name3 = "leather";
                        break;
                    }
                    case 5: {
                        name3 = "nitwit";
                        break;
                    }
                }
                return "entity.Villager." + name3;
            }
            return "entity." + entity.getType().getEntityClass().getSimpleName() + ".name";
        }
        catch (Throwable throwable) {
            return "entity.null";
        }
    }

    @Override
    @NotNull
    public ItemTag getItemTag(ItemStack itemStack2) {
        net.minecraft.server.v1_8_R3.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)itemStack2);
        net.minecraft.server.v1_8_R3.ItemStack nmsItemStack = nmsItem;
        return nmsItemStack.hasTag() ? this.fromNBTBase(nmsItemStack.getTag()).asCompound() : new ItemTag();
    }

    @Override
    @NotNull
    public ItemStack setItemTag(ItemStack itemStack2, ItemTag compound) {
        net.minecraft.server.v1_8_R3.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)itemStack2);
        nmsItem.setTag((NBTTagCompound)this.toNBTBase(compound));
        return CraftItemStack.asBukkitCopy((net.minecraft.server.v1_8_R3.ItemStack)nmsItem);
    }

    @Override
    @NotNull
    public String itemTagToString(ItemTagData itemTag) {
        return this.toNBTBase(itemTag).toString();
    }

    private Object toNBTBase(ItemTagData base) {
        boolean v11500 = MinecraftVersion.INSTANCE.getMajor() >= 7;
        switch (base.getType().getId()) {
            case 1: {
                if (v11500) {
                    return net.minecraft.server.v1_15_R1.NBTTagByte.a((byte)base.asByte());
                }
                return new NBTTagByte(base.asByte());
            }
            case 2: {
                if (v11500) {
                    return NBTTagShort.a((short)base.asShort());
                }
                return new net.minecraft.server.v1_8_R3.NBTTagShort(base.asShort());
            }
            case 3: {
                if (v11500) {
                    return NBTTagInt.a((int)base.asInt());
                }
                return new net.minecraft.server.v1_8_R3.NBTTagInt(base.asInt());
            }
            case 4: {
                if (v11500) {
                    return net.minecraft.server.v1_15_R1.NBTTagLong.a((long)base.asLong());
                }
                return new NBTTagLong(base.asLong());
            }
            case 5: {
                if (v11500) {
                    return NBTTagFloat.a((float)base.asFloat());
                }
                return new net.minecraft.server.v1_8_R3.NBTTagFloat(base.asFloat());
            }
            case 6: {
                if (v11500) {
                    return net.minecraft.server.v1_15_R1.NBTTagDouble.a((double)base.asDouble());
                }
                return new NBTTagDouble(base.asDouble());
            }
            case 7: {
                return new NBTTagByteArray(base.asByteArray());
            }
            case 11: {
                return new NBTTagIntArray(base.asIntArray());
            }
            case 8: {
                if (v11500) {
                    return net.minecraft.server.v1_15_R1.NBTTagString.a((String)base.asString());
                }
                return new NBTTagString(base.asString());
            }
            case 9: {
                net.minecraft.server.v1_8_R3.NBTTagList nmsList = new net.minecraft.server.v1_8_R3.NBTTagList();
                for (ItemTagData value : base.asList()) {
                    if (MinecraftVersion.INSTANCE.getMajor() >= 6) {
                        ((net.minecraft.server.v1_14_R1.NBTTagList)nmsList).add(((net.minecraft.server.v1_14_R1.NBTTagList)nmsList).size(), (net.minecraft.server.v1_14_R1.NBTBase)this.toNBTBase(value));
                        continue;
                    }
                    if (MinecraftVersion.INSTANCE.getMajor() >= 5) {
                        ((NBTTagList)nmsList).add((NBTBase)this.toNBTBase(value));
                        continue;
                    }
                    nmsList.add((net.minecraft.server.v1_8_R3.NBTBase)this.toNBTBase(value));
                }
                return nmsList;
            }
            case 10: {
                NBTTagCompound nmsTag = new NBTTagCompound();
                if (MinecraftVersion.INSTANCE.isUniversal()) {
                    for (Map.Entry<String, ItemTagData> entry : base.asCompound().entrySet()) {
                        ((Map)Reflex.Companion.getProperty(nmsTag, "tags", false, true, true)).put(entry.getKey(), this.toNBTBase(entry.getValue()));
                    }
                } else {
                    for (Map.Entry<String, ItemTagData> entry : base.asCompound().entrySet()) {
                        ((Map)Reflex.Companion.getProperty(nmsTag, "map", false, true, true)).put(entry.getKey(), this.toNBTBase(entry.getValue()));
                    }
                }
                return nmsTag;
            }
        }
        return null;
    }

    private ItemTagData fromNBTBase(Object base) {
        if (base instanceof NBTTagCompound) {
            ItemTag itemTag = new ItemTag();
            Map map2 = MinecraftVersion.INSTANCE.isUniversal() ? (Map)Reflex.Companion.getProperty(base, "tags", false, false, true) : (Map)Reflex.Companion.getProperty(base, "map", false, false, true);
            for (Map.Entry entry : map2.entrySet()) {
                itemTag.put((String)entry.getKey(), this.fromNBTBase(entry.getValue()));
            }
            return itemTag;
        }
        if (base instanceof net.minecraft.server.v1_8_R3.NBTTagList) {
            ItemTagList itemTagList = new ItemTagList();
            List list = (List)Reflex.Companion.getProperty(base, "list", false, false, true);
            for (Object v : list) {
                itemTagList.add(this.fromNBTBase(v));
            }
            return itemTagList;
        }
        Object data = Reflex.Companion.getProperty(base, "data", false, false, true);
        if (base instanceof NBTTagString) {
            return new ItemTagData((String)data);
        }
        if (base instanceof NBTTagDouble) {
            return new ItemTagData((Double)data);
        }
        if (base instanceof net.minecraft.server.v1_8_R3.NBTTagInt) {
            return new ItemTagData((Integer)data);
        }
        if (base instanceof net.minecraft.server.v1_8_R3.NBTTagFloat) {
            return new ItemTagData(((Float)data).floatValue());
        }
        if (base instanceof net.minecraft.server.v1_8_R3.NBTTagShort) {
            return new ItemTagData((Short)data);
        }
        if (base instanceof NBTTagLong) {
            return new ItemTagData((Long)data);
        }
        if (base instanceof NBTTagByte) {
            return new ItemTagData((Byte)data);
        }
        if (base instanceof NBTTagIntArray) {
            return new ItemTagData((int[])data);
        }
        if (base instanceof NBTTagByteArray) {
            return new ItemTagData((byte[])data);
        }
        return null;
    }

    @Override
    @Nullable
    public Object getEntityType(String name2) {
        if (MinecraftVersion.INSTANCE.getMajor() >= 6) {
            return net.minecraft.server.v1_14_R1.EntityTypes.a((String)name2).orElse(null);
        }
        return EntityTypes.a((String)name2);
    }

    @Override
    public <T extends Entity> T spawnEntity(Location location, Class<T> entity, Consumer<T> e) {
        if (MinecraftVersion.INSTANCE.getMajor() >= 4) {
            return (T)location.getWorld().spawn(location, entity, e::accept);
        }
        net.minecraft.server.v1_13_R2.Entity createEntity = ((CraftWorld)location.getWorld()).createEntity(location, entity);
        try {
            e.accept(createEntity.getBukkitEntity());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return (T)((CraftWorld)location.getWorld()).addEntity(createEntity, CreatureSpawnEvent.SpawnReason.CUSTOM);
    }

    @Override
    public boolean createLight(Block block, LightType lightType, int lightLevel) {
        int level = this.getRawLightLevel(block, lightType);
        this.setRawLightLevel(block, lightType, lightLevel);
        this.recalculateLightAround(block, lightType, lightLevel);
        return this.getRawLightLevel(block, lightType) >= level;
    }

    @Override
    public boolean deleteLight(Block block, LightType lightType) {
        int level = this.getRawLightLevel(block, lightType);
        this.setRawLightLevel(block, lightType, 0);
        this.recalculateLightAround(block, lightType, level);
        return this.getRawLightLevel(block, lightType) != level;
    }

    @Override
    public int getRawLightLevel(Block block, LightType lightType) {
        net.minecraft.server.v1_13_R2.WorldServer world = ((CraftWorld)block.getWorld()).getHandle();
        net.minecraft.server.v1_15_R1.BlockPosition position = new net.minecraft.server.v1_15_R1.BlockPosition(block.getX(), block.getY(), block.getZ());
        if (MinecraftVersion.INSTANCE.getMajor() >= 4) {
            if (lightType == LightType.BLOCK) {
                return world.getBrightness(net.minecraft.server.v1_13_R2.EnumSkyBlock.BLOCK, (net.minecraft.server.v1_13_R2.BlockPosition)position);
            }
            if (lightType == LightType.SKY) {
                return world.getBrightness(net.minecraft.server.v1_13_R2.EnumSkyBlock.SKY, (net.minecraft.server.v1_13_R2.BlockPosition)position);
            }
            return world.getLightLevel((net.minecraft.server.v1_13_R2.BlockPosition)position);
        }
        Chunk chunk = ((net.minecraft.server.v1_9_R2.WorldServer)world).getChunkAt(block.getChunk().getX(), block.getChunk().getZ());
        if (lightType == LightType.BLOCK) {
            return chunk.getBrightness(net.minecraft.server.v1_9_R2.EnumSkyBlock.BLOCK, (net.minecraft.server.v1_9_R2.BlockPosition)position);
        }
        if (lightType == LightType.SKY) {
            return ((Chunk)world).getBrightness(net.minecraft.server.v1_9_R2.EnumSkyBlock.SKY, (net.minecraft.server.v1_9_R2.BlockPosition)position);
        }
        return 15;
    }

    @Override
    public void setRawLightLevel(Block block, LightType lightType, int lightLevel) {
        int level = Math.max(Math.min(lightLevel, 15), 0);
        net.minecraft.server.v1_13_R2.WorldServer world = ((CraftWorld)block.getWorld()).getHandle();
        net.minecraft.server.v1_15_R1.BlockPosition position = new net.minecraft.server.v1_15_R1.BlockPosition(block.getX(), block.getY(), block.getZ());
        if (MinecraftVersion.INSTANCE.getMajor() >= 6) {
            this.syncLight(((WorldServer)world).getChunkProvider().getLightEngine(), lightEngine -> {
                if (lightType == LightType.BLOCK) {
                    LightEngineLayerEventListener lightEngineLayer = ((LightEngineThreaded)lightEngine).a(EnumSkyBlock.BLOCK);
                    this.setRawLightLevelBlock(level, position, lightEngineLayer);
                } else if (lightType == LightType.SKY) {
                    LightEngineLayerEventListener lightEngineLayer = ((LightEngineThreaded)lightEngine).a(EnumSkyBlock.SKY);
                    this.setRawLightLevelSky(level, position, lightEngineLayer);
                } else {
                    LightEngineLayerEventListener lightEngineLayer1 = ((LightEngineThreaded)lightEngine).a(EnumSkyBlock.BLOCK);
                    LightEngineLayerEventListener lightEngineLayer2 = ((LightEngineThreaded)lightEngine).a(EnumSkyBlock.SKY);
                    this.setRawLightLevelBlock(level, position, lightEngineLayer1);
                    this.setRawLightLevelSky(level, position, lightEngineLayer2);
                }
            });
        } else if (lightType == LightType.BLOCK) {
            world.a(net.minecraft.server.v1_13_R2.EnumSkyBlock.BLOCK, (net.minecraft.server.v1_13_R2.BlockPosition)position, level);
        } else if (lightType == LightType.SKY) {
            world.a(net.minecraft.server.v1_13_R2.EnumSkyBlock.SKY, (net.minecraft.server.v1_13_R2.BlockPosition)position, level);
        } else {
            world.a(net.minecraft.server.v1_13_R2.EnumSkyBlock.BLOCK, (net.minecraft.server.v1_13_R2.BlockPosition)position, level);
            world.a(net.minecraft.server.v1_13_R2.EnumSkyBlock.SKY, (net.minecraft.server.v1_13_R2.BlockPosition)position, level);
        }
    }

    @Override
    public void recalculateLight(Block block, LightType lightType) {
        net.minecraft.server.v1_13_R2.WorldServer world = ((CraftWorld)block.getWorld()).getHandle();
        net.minecraft.server.v1_15_R1.BlockPosition position = new net.minecraft.server.v1_15_R1.BlockPosition(block.getX(), block.getY(), block.getZ());
        if (MinecraftVersion.INSTANCE.getMajor() >= 9) {
            LightEngineThreaded lightEngine = ((WorldServer)world).getChunkProvider().getLightEngine();
            if (((Boolean)Reflex.Companion.invokeMethod(lightEngine, "hasLightWork", new Object[0], false, true, true)).booleanValue()) {
                this.syncLight(lightEngine, e -> {
                    if (lightType == LightType.BLOCK) {
                        ((LightEngineLayer)((LightEngineThreaded)lightEngine).a(EnumSkyBlock.BLOCK)).a(Integer.MAX_VALUE, true, true);
                    } else if (lightType == LightType.SKY) {
                        ((LightEngineLayer)((LightEngineThreaded)lightEngine).a(EnumSkyBlock.SKY)).a(Integer.MAX_VALUE, true, true);
                    } else {
                        LightEngineLayerEventListener b = ((LightEngineThreaded)lightEngine).a(EnumSkyBlock.BLOCK);
                        LightEngineLayerEventListener s = ((LightEngineThreaded)lightEngine).a(EnumSkyBlock.SKY);
                        int maxUpdateCount = Integer.MAX_VALUE;
                        int integer4 = maxUpdateCount / 2;
                        int integer5 = ((LightEngineLayer)b).a(integer4, true, true);
                        int integer6 = maxUpdateCount - integer4 + integer5;
                        int integer7 = ((LightEngineLayer)s).a(integer6, true, true);
                        if (integer5 == 0 && integer7 > 0) {
                            ((LightEngineLayer)b).a(integer7, true, true);
                        }
                    }
                });
            }
        } else if (MinecraftVersion.INSTANCE.getMajor() >= 6) {
            LightEngineThreaded lightEngine = ((WorldServer)world).getChunkProvider().getLightEngine();
            if (lightEngine.a()) {
                this.syncLight(lightEngine, e -> {
                    if (lightType == LightType.BLOCK) {
                        ((LightEngineLayer)((LightEngineThreaded)lightEngine).a(EnumSkyBlock.BLOCK)).a(Integer.MAX_VALUE, true, true);
                    } else if (lightType == LightType.SKY) {
                        ((LightEngineLayer)((LightEngineThreaded)lightEngine).a(EnumSkyBlock.SKY)).a(Integer.MAX_VALUE, true, true);
                    } else {
                        LightEngineLayerEventListener b = ((LightEngineThreaded)lightEngine).a(EnumSkyBlock.BLOCK);
                        LightEngineLayerEventListener s = ((LightEngineThreaded)lightEngine).a(EnumSkyBlock.SKY);
                        int maxUpdateCount = Integer.MAX_VALUE;
                        int integer4 = maxUpdateCount / 2;
                        int integer5 = ((LightEngineLayer)b).a(integer4, true, true);
                        int integer6 = maxUpdateCount - integer4 + integer5;
                        int integer7 = ((LightEngineLayer)s).a(integer6, true, true);
                        if (integer5 == 0 && integer7 > 0) {
                            ((LightEngineLayer)b).a(integer7, true, true);
                        }
                    }
                });
            }
        } else if (lightType == LightType.SKY) {
            world.c(net.minecraft.server.v1_13_R2.EnumSkyBlock.SKY, (net.minecraft.server.v1_13_R2.BlockPosition)position);
        } else if (lightType == LightType.BLOCK) {
            world.c(net.minecraft.server.v1_13_R2.EnumSkyBlock.BLOCK, (net.minecraft.server.v1_13_R2.BlockPosition)position);
        } else {
            world.c(net.minecraft.server.v1_13_R2.EnumSkyBlock.SKY, (net.minecraft.server.v1_13_R2.BlockPosition)position);
            world.c(net.minecraft.server.v1_13_R2.EnumSkyBlock.BLOCK, (net.minecraft.server.v1_13_R2.BlockPosition)position);
        }
    }

    @Override
    public void recalculateLightAround(Block block, LightType lightType, int lightLevel) {
        if (this.getRawLightLevel(block.getRelative(1, 0, 0), lightType) < lightLevel) {
            this.recalculateLight(block.getRelative(1, 0, 0), lightType);
        }
        if (this.getRawLightLevel(block.getRelative(-1, 0, 0), lightType) < lightLevel) {
            this.recalculateLight(block.getRelative(-1, 0, 0), lightType);
        }
        if (this.getRawLightLevel(block.getRelative(0, 1, 0), lightType) < lightLevel) {
            this.recalculateLight(block.getRelative(0, 1, 0), lightType);
        }
        if (this.getRawLightLevel(block.getRelative(0, -1, 0), lightType) < lightLevel) {
            this.recalculateLight(block.getRelative(0, -1, 0), lightType);
        }
        if (this.getRawLightLevel(block.getRelative(0, 0, 1), lightType) < lightLevel) {
            this.recalculateLight(block.getRelative(0, 0, 1), lightType);
        }
        if (this.getRawLightLevel(block.getRelative(0, 0, -1), lightType) < lightLevel) {
            this.recalculateLight(block.getRelative(0, 0, -1), lightType);
        }
    }

    @Override
    public void updateLight(org.bukkit.Chunk chunk, Collection<Player> viewers) {
        for (Player player : viewers) {
            net.minecraft.server.v1_8_R3.EntityPlayer human = ((CraftPlayer)player).getHandle();
            net.minecraft.server.v1_13_R2.Chunk chunk1 = ((CraftWorld)player.getWorld()).getHandle().getChunkAt(chunk.getX(), chunk.getZ());
            net.minecraft.server.v1_8_R3.Chunk chunk2 = human.getWorld().getChunkAtWorldCoords(human.getChunkCoordinates());
            if (this.distance(chunk2, chunk1) >= this.distance(human)) continue;
            if (MinecraftVersion.INSTANCE.getMajor() >= 8) {
                MinecraftServerUtilKt.sendPacket(player, new PacketPlayOutLightUpdate(((net.minecraft.server.v1_16_R1.Chunk)chunk1).getPos(), ((net.minecraft.server.v1_16_R1.Chunk)chunk1).getWorld().getChunkProvider().getLightEngine(), true));
                continue;
            }
            if (MinecraftVersion.INSTANCE.getMajor() >= 6) {
                MinecraftServerUtilKt.sendPacket(player, new net.minecraft.server.v1_14_R1.PacketPlayOutLightUpdate(((net.minecraft.server.v1_14_R1.Chunk)chunk1).getPos(), ((net.minecraft.server.v1_14_R1.Chunk)chunk1).e()));
                continue;
            }
            MinecraftServerUtilKt.sendPacket(player, new PacketPlayOutMapChunk((net.minecraft.server.v1_14_R1.Chunk)chunk1, 131071));
        }
    }

    @Override
    public void updateLightUniversal(Block block, LightType lightType, Collection<Player> viewers) {
        org.bukkit.Chunk chunk = block.getChunk();
        for (Player player : viewers) {
            net.minecraft.server.v1_8_R3.EntityPlayer human = ((CraftPlayer)player).getHandle();
            net.minecraft.server.v1_13_R2.Chunk chunk1 = ((CraftWorld)player.getWorld()).getHandle().getChunkAt(chunk.getX(), chunk.getZ());
            net.minecraft.server.v1_8_R3.Chunk chunk2 = human.getWorld().getChunkAtWorldCoords(human.getChunkCoordinates());
            if (this.distance(chunk2, chunk1) >= this.distance(human)) continue;
            IChunkProvider chunkProvider = ((net.minecraft.server.v1_16_R1.Chunk)chunk1).getWorld().getChunkProvider();
            Object[] params = new Object[]{ChunkCoordIntPair.pair((int)chunk.getX(), (int)chunk.getZ())};
            PlayerChunk playerChunk = (PlayerChunk)Reflex.Companion.invokeMethod(chunkProvider, "getChunk", params, false, true, true);
            BitSet skyChangedLightSectionFilter = new BitSet();
            BitSet blockChangedLightSectionFilter = new BitSet();
            if (lightType == LightType.BLOCK) {
                blockChangedLightSectionFilter.set((block.getY() >> 4) + 1);
            } else if (lightType == LightType.SKY) {
                skyChangedLightSectionFilter.set((block.getY() >> 4) + 1);
            } else {
                blockChangedLightSectionFilter.set((block.getY() >> 4) + 1);
                skyChangedLightSectionFilter.set((block.getY() >> 4) + 1);
            }
            try {
                MinecraftServerUtilKt.sendPacket(player, this.packetPlayOutLightUpdateConstructor.newInstance(((net.minecraft.server.v1_16_R1.Chunk)chunk1).getPos(), ((net.minecraft.server.v1_16_R1.Chunk)chunk1).getWorld().getChunkProvider().getLightEngine(), skyChangedLightSectionFilter, blockChangedLightSectionFilter, true));
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    @NotNull
    public String getEnchantmentKey(Enchantment enchantment) {
        if (MinecraftVersion.INSTANCE.getMajor() > 5) {
            NamespacedKey key2 = (NamespacedKey)Reflex.Companion.invokeMethod(enchantment, "getKey", new Object[0], false, true, true);
            return "enchantment.minecraft." + key2.getKey();
        }
        if (MinecraftVersion.INSTANCE.getMajor() == 5) {
            int id2 = (Integer)Reflex.Companion.invokeMethod(enchantment, "id", new Object[0], false, true, true);
            return ((net.minecraft.server.v1_13_R2.Enchantment)IRegistry.ENCHANTMENT.fromId(id2)).g();
        }
        Map byName = (Map)Reflex.Companion.getProperty(Enchantment.class, "byName", true, false, true);
        for (Map.Entry entry : byName.entrySet()) {
            if (entry != enchantment) continue;
            return "enchantment.minecraft." + (String)entry.getKey();
        }
        return "null";
    }

    @Override
    @NotNull
    public String getPotionEffectTypeKey(PotionEffectType potionEffectType) {
        if (MinecraftVersion.INSTANCE.isUniversal()) {
            Registry registry = (Registry)Reflex.Companion.getProperty(MinecraftServerUtilKt.nmsClass("IRegistry"), "MOB_EFFECT", true, false, true);
            return ((net.minecraft.server.v1_14_R1.MobEffectList)registry.fromId(potionEffectType.getId())).c();
        }
        if (MinecraftVersion.INSTANCE.getMajor() >= 5) {
            return net.minecraft.server.v1_13_R2.MobEffectList.fromId((int)potionEffectType.getId()).c();
        }
        if (MinecraftVersion.INSTANCE.getMajor() >= 1) {
            return net.minecraft.server.v1_12_R1.MobEffectList.fromId((int)potionEffectType.getId()).a();
        }
        return MobEffectList.byId[potionEffectType.getId()].a();
    }

    @Override
    public void openSignEditor(Player player, Block block) {
        try {
            MinecraftServerUtilKt.sendPacket(player, new PacketPlayOutOpenSignEditor(new BlockPosition(block.getX(), block.getY(), block.getZ())));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private int distance(Object player) {
        int viewDistance = Bukkit.getViewDistance();
        try {
            int playerViewDistance = ((EntityPlayer)player).clientViewDistance;
            if (playerViewDistance < viewDistance) {
                viewDistance = playerViewDistance;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return viewDistance;
    }

    private int distance(Object from, Object to) {
        double z;
        double x;
        String name2;
        String name1;
        if (MinecraftVersion.INSTANCE.getMajor() >= 8 ? !(name1 = ((WorldDataServer)((net.minecraft.server.v1_16_R1.Chunk)from).getWorld().getWorldData()).getName()).equals(name2 = ((WorldDataServer)((net.minecraft.server.v1_16_R1.Chunk)to).getWorld().getWorldData()).getName()) : !((net.minecraft.server.v1_14_R1.Chunk)from).getWorld().getWorldData().getName().equals(((net.minecraft.server.v1_14_R1.Chunk)to).getWorld().getWorldData().getName())) {
            return 100;
        }
        if (MinecraftVersion.INSTANCE.getMajor() >= 9) {
            x = ((net.minecraft.server.v1_14_R1.Chunk)to).getPos().x - ((net.minecraft.server.v1_14_R1.Chunk)from).getPos().x;
            z = ((net.minecraft.server.v1_14_R1.Chunk)to).getPos().z - ((net.minecraft.server.v1_14_R1.Chunk)from).getPos().z;
        } else if (MinecraftVersion.INSTANCE.getMajor() >= 4) {
            x = ((net.minecraft.server.v1_12_R1.Chunk)to).locX - ((net.minecraft.server.v1_12_R1.Chunk)from).locX;
            z = ((net.minecraft.server.v1_12_R1.Chunk)to).locZ - ((net.minecraft.server.v1_12_R1.Chunk)from).locZ;
        } else {
            x = ((net.minecraft.server.v1_14_R1.Chunk)to).getPos().x - ((net.minecraft.server.v1_14_R1.Chunk)from).getPos().x;
            z = ((net.minecraft.server.v1_14_R1.Chunk)to).getPos().z - ((net.minecraft.server.v1_14_R1.Chunk)from).getPos().z;
        }
        return (int)Math.sqrt(x * x + z * z);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncLight(Object lightEngine, Consumer<Object> task2) {
        try {
            int flags;
            AtomicInteger c;
            Object b;
            if (MinecraftVersion.INSTANCE.getMajor() >= 9) {
                b = Reflex.Companion.getProperty(lightEngine, "taskMailbox", false, true, true);
                c = (AtomicInteger)Reflex.Companion.getProperty(b, "status", false, true, true);
            } else {
                b = Reflex.Companion.getProperty(lightEngine, "b", false, true, true);
                c = (AtomicInteger)Reflex.Companion.getProperty(b, "c", false, true, true);
            }
            long wait = -1L;
            while (!c.compareAndSet(flags = c.get() & 0xFFFFFFFD, flags | 2)) {
                if ((flags & 1) == 0) continue;
                if (wait == -1L) {
                    wait = System.currentTimeMillis() + 3000L;
                    IOKt.info("ThreadedMailbox is closing. Will wait...");
                } else if (System.currentTimeMillis() >= wait) {
                    IOKt.warning("Failed to enter critical section while ThreadedMailbox is closing");
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
            try {
                task2.accept(lightEngine);
            }
            finally {
                while (!c.compareAndSet(flags = c.get(), flags & 0xFFFFFFFD)) {
                }
                Reflex.Companion.getProperty(b, "f", false, true, true);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void setRawLightLevelBlock(int level, Object position, Object lightEngineLayer) {
        if (level == 0) {
            ((LightEngineBlock)lightEngineLayer).a((net.minecraft.server.v1_14_R1.BlockPosition)position);
        } else if (((LightEngineLayer)lightEngineLayer).a(SectionPosition.a((net.minecraft.server.v1_14_R1.BlockPosition)((net.minecraft.server.v1_14_R1.BlockPosition)position))) != null) {
            try {
                ((LightEngineLayer)lightEngineLayer).a((net.minecraft.server.v1_14_R1.BlockPosition)position, level);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private void setRawLightLevelSky(int level, Object position, Object lightEngineLayer) {
        if (level == 0) {
            ((LightEngineSky)lightEngineLayer).a((net.minecraft.server.v1_14_R1.BlockPosition)position);
        } else if (((LightEngineLayer)lightEngineLayer).a(SectionPosition.a((net.minecraft.server.v1_14_R1.BlockPosition)((net.minecraft.server.v1_14_R1.BlockPosition)position))) != null) {
            try {
                Object s;
                if (MinecraftVersion.INSTANCE.getMajor() >= 9) {
                    s = Reflex.Companion.getProperty(lightEngineLayer, "storage", false, true, true);
                    Reflex.Companion.invokeMethod(s, "e", new Object[0], false, true, true);
                } else {
                    s = Reflex.Companion.getProperty(lightEngineLayer, "c", false, true, true);
                    if (MinecraftVersion.INSTANCE.getMajor() >= 7) {
                        Reflex.Companion.invokeMethod(s, "d", new Object[0], false, true, true);
                    } else {
                        Reflex.Companion.invokeMethod(s, "c", new Object[0], false, true, true);
                    }
                }
                Object[] params = new Object[]{Long.MAX_VALUE, ((net.minecraft.server.v1_14_R1.BlockPosition)position).asLong(), 15 - level, true};
                Reflex.Companion.invokeMethod(lightEngineLayer, "a", params, false, true, true);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

