/*
 * Decompiled with CFR 0.152.
 */
package cc.trixey.invero.common.adventure.adventure.text.serializer.gson;

import cc.trixey.invero.common.adventure.adventure.text.format.NamedTextColor;
import cc.trixey.invero.common.adventure.adventure.text.format.TextColor;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class TextColorSerializer
extends TypeAdapter<TextColor> {
    static final TypeAdapter<TextColor> INSTANCE = new TextColorSerializer(false).nullSafe();
    static final TypeAdapter<TextColor> DOWNSAMPLE_COLOR = new TextColorSerializer(true).nullSafe();
    private final boolean downsampleColor;

    private TextColorSerializer(boolean downsampleColor) {
        this.downsampleColor = downsampleColor;
    }

    public void write(JsonWriter out, TextColor value2) throws IOException {
        if (value2 instanceof NamedTextColor) {
            out.value(NamedTextColor.NAMES.key((NamedTextColor)value2));
        } else if (this.downsampleColor) {
            out.value(NamedTextColor.NAMES.key(NamedTextColor.nearestTo(value2)));
        } else {
            out.value(TextColorSerializer.asUpperCaseHexString(value2));
        }
    }

    private static String asUpperCaseHexString(TextColor color) {
        return String.format(Locale.ROOT, "#%06X", color.value());
    }

    @Nullable
    public TextColor read(JsonReader in) throws IOException {
        @Nullable TextColor color = TextColorSerializer.fromString(in.nextString());
        if (color == null) {
            return null;
        }
        return this.downsampleColor ? NamedTextColor.nearestTo(color) : color;
    }

    @Nullable
    static TextColor fromString(@NotNull String value2) {
        if (value2.startsWith("#")) {
            return TextColor.fromHexString(value2);
        }
        return NamedTextColor.NAMES.value(value2);
    }
}

