/*
 * Decompiled with CFR 0.152.
 */
package cc.trixey.invero.taboolib.common5;

import cc.trixey.invero.taboolib.common.Isolated;
import java.util.concurrent.ConcurrentHashMap;

@Isolated
public class LoreMap<T> {
    private final TrieNode root = new TrieNode();
    private final boolean ignorePrefix;
    private final boolean ignoreSpace;
    private final boolean ignoreColor;

    public LoreMap(boolean ignoreSpace, boolean ignoreColor, boolean ignorePrefix) {
        this.ignoreSpace = ignoreSpace;
        this.ignoreColor = ignoreColor;
        this.ignorePrefix = ignorePrefix;
    }

    public LoreMap() {
        this(true, true, false);
    }

    public void put(String lore, T value2) {
        lore = lore.replaceAll("&", "\u00a7");
        if (this.ignoreSpace) {
            lore = lore.replaceAll("\\s", "");
        }
        if (this.ignoreColor) {
            lore = lore.replaceAll("\u00a7.", "");
        }
        TrieNode current = this.root;
        for (int depth = 0; depth < lore.length(); ++depth) {
            LoreChar c = new LoreChar(lore.charAt(depth));
            if (current.child.containsKey(c)) {
                current = current.child.get(c);
            } else {
                TrieNode node2 = new TrieNode();
                ++node2.depth;
                node2.pre = current;
                current.child.put(c, node2);
                current = node2;
            }
            if (depth != lore.length() - 1) continue;
            current.obj = value2;
        }
    }

    public T get(String lore) {
        int depth = 0;
        if (this.ignoreSpace) {
            lore = lore.replaceAll("\\s", "");
        }
        if (this.ignoreColor) {
            lore = lore.replaceAll("\u00a7.", "");
        }
        TrieNode current = this.root;
        if (this.ignorePrefix) {
            while (depth < lore.length() && !this.root.child.containsKey(new LoreChar(lore.charAt(depth)))) {
                ++depth;
            }
        }
        while (depth < lore.length()) {
            LoreChar c = new LoreChar(lore.charAt(depth));
            TrieNode node2 = current.child.get(c);
            if (node2 == null) {
                return null;
            }
            if (node2.obj != null) {
                return node2.obj;
            }
            current = node2;
            ++depth;
        }
        return null;
    }

    public MatchResult<T> getMatchResult(String lore) {
        int depth = 0;
        if (this.ignoreSpace) {
            lore = lore.replaceAll("\\s", "");
        }
        if (this.ignoreColor) {
            lore = lore.replaceAll("\u00a7.", "");
        }
        if (this.ignorePrefix) {
            while (depth < lore.length() && !this.root.child.containsKey(new LoreChar(lore.charAt(depth)))) {
                ++depth;
            }
        }
        TrieNode current = this.root;
        while (depth < lore.length()) {
            LoreChar c = new LoreChar(lore.charAt(depth));
            TrieNode node2 = current.child.get(c);
            if (node2 == null) {
                return null;
            }
            if (node2.obj != null) {
                return new MatchResult(depth < lore.length() - 1 ? lore.substring(depth + 1) : null, node2.obj);
            }
            current = node2;
            ++depth;
        }
        return null;
    }

    public void clear() {
        this.root.child.clear();
    }

    public static class LoreChar {
        private final char c;

        public LoreChar(char c) {
            this.c = c;
        }

        public char get() {
            return this.c;
        }

        public int hashCode() {
            return this.c;
        }

        public boolean equals(Object o) {
            return o instanceof LoreChar && ((LoreChar)o).c == this.c;
        }
    }

    public static class MatchResult<T> {
        public final String remain;
        public final T obj;

        public MatchResult(String remain, T obj) {
            this.remain = remain;
            this.obj = obj;
        }
    }

    public class TrieNode {
        final ConcurrentHashMap<LoreChar, TrieNode> child = new ConcurrentHashMap();
        TrieNode pre = null;
        T obj = null;
        int depth = 0;
    }
}

