/*
 * Decompiled with CFR 0.152.
 */
package cc.trixey.invero.taboolib.common.util;

import cc.trixey.invero.taboolib.common.Isolated;

@Isolated
public class Strings {
    public static double similarDegree(String strA, String strB) {
        String newStrA = Strings.removeSign(Strings.max(strA, strB));
        String newStrB = Strings.removeSign(Strings.min(strA, strB));
        try {
            int temp = Math.max(newStrA.length(), newStrB.length());
            int temp2 = Strings.longestCommonSubstring(newStrA, newStrB).length();
            return (double)temp2 * 1.0 / (double)temp;
        }
        catch (Exception ignored) {
            return 0.0;
        }
    }

    private static String bytesToHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte aByte : bytes) {
            String hex = Integer.toHexString(0xFF & aByte);
            if (hex.length() == 1) {
                sb.append('0');
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    private static String max(String strA, String strB) {
        return strA.length() >= strB.length() ? strA : strB;
    }

    private static String min(String strA, String strB) {
        return strA.length() < strB.length() ? strA : strB;
    }

    private static String removeSign(String str) {
        StringBuilder builder = new StringBuilder();
        for (char item2 : str.toCharArray()) {
            if (!Strings.charReg(item2)) continue;
            builder.append(item2);
        }
        return builder.toString();
    }

    private static boolean charReg(char charValue) {
        return charValue >= '\u4e00' && charValue <= '\u9fa5' || charValue >= 'a' && charValue <= 'z' || charValue >= 'A' && charValue <= 'Z' || charValue >= '0' && charValue <= '9';
    }

    private static String longestCommonSubstring(String strA, String strB) {
        char[] chars_strA = strA.toCharArray();
        char[] chars_strB = strB.toCharArray();
        int m = chars_strA.length;
        int n = chars_strB.length;
        int[][] matrix = new int[m + 1][n + 1];
        for (int i = 1; i <= m; ++i) {
            for (int j = 1; j <= n; ++j) {
                matrix[i][j] = chars_strA[i - 1] == chars_strB[j - 1] ? matrix[i - 1][j - 1] + 1 : Math.max(matrix[i][j - 1], matrix[i - 1][j]);
            }
        }
        char[] result = new char[matrix[m][n]];
        int currentIndex = result.length - 1;
        while (matrix[m][n] != 0) {
            if (matrix[n] == matrix[n - 1]) {
                --n;
                continue;
            }
            if (matrix[m][n] == matrix[m - 1][n]) {
                --m;
                continue;
            }
            result[currentIndex] = chars_strA[m - 1];
            --currentIndex;
            --n;
            --m;
        }
        return new String(result);
    }
}

