/*
 * Decompiled with CFR 0.152.
 */
package cc.trixey.invero.taboolib.common.util;

import cc.trixey.invero.taboolib.common.Isolated;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@Isolated
public class Version
implements Comparable<Version> {
    private final String source;
    private final int[] version;

    public Version(String source) {
        this.source = source;
        String[] type2 = source.split("[- ]");
        String[] args = type2[0].split("\\.");
        if (args.length == 2) {
            this.version = new int[]{-1, Integer.parseInt(args[0]), Integer.parseInt(args[1])};
        } else if (args.length == 3) {
            this.version = new int[]{Integer.parseInt(args[0]), Integer.parseInt(args[1]), Integer.parseInt(args[2])};
        } else {
            throw new VersionFormatException(source);
        }
    }

    public boolean isBefore(Version version) {
        return this.compareTo(version) < 0;
    }

    public boolean isAfter(Version version) {
        return this.compareTo(version) > 0;
    }

    public String getSource() {
        return this.source;
    }

    public boolean isLegacy() {
        return this.version[0] == -1;
    }

    public int[] getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Version)) {
            return false;
        }
        Version version1 = (Version)o;
        return this.getSource().equals(version1.getSource()) && Arrays.equals(this.getVersion(), version1.getVersion());
    }

    public int hashCode() {
        int result = Objects.hash(this.getSource());
        result = 31 * result + Arrays.hashCode(this.getVersion());
        return result;
    }

    public String toString() {
        return "Version{source='" + this.source + '\'' + ", version=" + Arrays.toString(this.version) + '}';
    }

    @Override
    public int compareTo(@NotNull Version o) {
        if (this.version[0] > o.version[0]) {
            return 1;
        }
        if (this.version[0] == o.version[0]) {
            if (this.version[1] > o.version[1]) {
                return 1;
            }
            if (this.version[1] == o.version[1]) {
                return Integer.compare(this.version[2], o.version[2]);
            }
            return -1;
        }
        return -1;
    }

    public static class VersionFormatException
    extends IllegalArgumentException {
        public VersionFormatException(String source) {
            super("For input version: \"" + source + "\"");
        }
    }
}

