/*
 * Decompiled with CFR 0.152.
 */
package cc.trixey.invero.taboolib.library.jarrelocator;

import cc.trixey.invero.taboolib.library.asm.commons.Remapper;
import cc.trixey.invero.taboolib.library.jarrelocator.Relocation;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class RelocatingRemapper
extends Remapper {
    private static final Pattern CLASS_PATTERN = Pattern.compile("(\\[*)?L(.+);");
    private static final Pattern VERSION_PATTERN = Pattern.compile("^(META-INF/versions/\\d+/)(.*)$");
    private final Collection<Relocation> rules;

    RelocatingRemapper(Collection<Relocation> rules) {
        this.rules = rules;
    }

    @Override
    public String map(String name2) {
        String relocatedName = this.relocate(name2, false);
        if (relocatedName != null) {
            return relocatedName;
        }
        return super.map(name2);
    }

    @Override
    public Object mapValue(Object object) {
        String relocatedName;
        if (object instanceof String && (relocatedName = this.relocate((String)object, true)) != null) {
            return relocatedName;
        }
        return super.mapValue(object);
    }

    private String relocate(String name2, boolean isStringValue) {
        Matcher m;
        String prefix = "";
        String suffix = "";
        if (isStringValue && (m = CLASS_PATTERN.matcher(name2)).matches()) {
            prefix = m.group(1) + "L";
            name2 = m.group(2);
            suffix = ";";
        }
        if ((m = VERSION_PATTERN.matcher(name2)).matches()) {
            prefix = m.group(1);
            name2 = m.group(2);
        }
        for (Relocation r : this.rules) {
            if (isStringValue && r.canRelocateClass(name2)) {
                return prefix + r.relocateClass(name2) + suffix;
            }
            if (!r.canRelocatePath(name2)) continue;
            return prefix + r.relocatePath(name2) + suffix;
        }
        return null;
    }
}

