/*
 * Decompiled with CFR 0.152.
 */
package cc.trixey.invero.taboolib.library.kether;

import cc.trixey.invero.taboolib.library.kether.AbstractStringReader;
import cc.trixey.invero.taboolib.library.kether.ActionProperties;
import cc.trixey.invero.taboolib.library.kether.LoadError;
import cc.trixey.invero.taboolib.library.kether.LocalizedException;
import cc.trixey.invero.taboolib.library.kether.ParsedAction;
import cc.trixey.invero.taboolib.library.kether.Quest;
import cc.trixey.invero.taboolib.library.kether.QuestService;
import cc.trixey.invero.taboolib.library.kether.SimpleQuest;
import cc.trixey.invero.taboolib.library.kether.SimpleReader;
import cc.trixey.invero.taboolib.module.kether.Kether;
import cc.trixey.invero.taboolib.module.kether.KetherError;
import cc.trixey.invero.taboolib.module.kether.action.ActionLiteral;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BlockReader
extends AbstractStringReader {
    protected final Map<String, Quest.Block> blocks;
    protected final QuestService<?> service;
    protected final List<String> namespace;
    protected String currentBlock;

    public BlockReader(char[] content2, QuestService<?> service, List<String> namespace2) {
        super(content2);
        this.blocks = new HashMap<String, Quest.Block>();
        this.service = service;
        this.namespace = namespace2;
    }

    public BlockReader(char[] arr, int index, int mark, Map<String, Quest.Block> blocks, QuestService<?> service, List<String> namespace2, String currentBlock) {
        super(arr, index, mark);
        this.blocks = blocks;
        this.service = service;
        this.namespace = namespace2;
        this.currentBlock = currentBlock;
    }

    public Quest parse(String id2) {
        while (this.hasNext()) {
            this.readBlock();
        }
        return new SimpleQuest(this.content, this.blocks, id2);
    }

    public void readBlock() {
        this.expect("def");
        String name2 = this.nextToken();
        this.expect("=");
        this.currentBlock = name2;
        List<ParsedAction<?>> actions = this.readActions();
        this.checkLiteral(actions);
        SimpleQuest.SimpleBlock block = new SimpleQuest.SimpleBlock(name2, actions);
        this.processActions(block, actions);
        this.blocks.put(name2, block);
    }

    public void checkLiteral(List<ParsedAction<?>> actions) {
        if (Kether.INSTANCE.isAllowToleranceParser()) {
            ActionLiteral before = null;
            for (ParsedAction<?> action : actions) {
                if (before != null) {
                    throw KetherError.CUSTOM.create("Isolate literal \"" + before.getValue() + "\" is not end of block, maybe a misspelled action?");
                }
                if (!(action.getAction() instanceof ActionLiteral) || !((ActionLiteral)action.getAction()).isMisspelled()) continue;
                before = (ActionLiteral)action.getAction();
            }
        }
    }

    public List<ParsedAction<?>> readActions() {
        boolean batch;
        this.skipBlank();
        boolean bl = batch = this.peek() == '{';
        if (batch) {
            this.skip(1);
        }
        SimpleReader reader = this.newActionReader(this.service, this.namespace);
        try {
            ArrayList list2 = new ArrayList();
            while (batch && reader.hasNext() || list2.isEmpty()) {
                if (batch && reader.peek() == '}') {
                    reader.skip(1);
                    this.index = reader.index;
                    list2.trimToSize();
                    return list2;
                }
                list2.add(reader.nextAction());
                reader.mark();
            }
            return list2;
        }
        catch (Exception e2) {
            if (e2 instanceof LocalizedException) {
                String source = new String(this.content, reader.getMark(), Math.min(this.content.length, reader.getIndex()) - reader.getMark()).trim();
                if (batch && ((LocalizedException)e2).getError() == LoadError.EOF) {
                    source = source.substring(0, source.lastIndexOf(125) - 1);
                }
                throw LoadError.BLOCK_ERROR.create(this.currentBlock, BlockReader.lineOf(this.content, reader.getMark()), source).then((LocalizedException)e2);
            }
            e2.printStackTrace();
            throw LoadError.UNHANDLED.create(e2);
        }
    }

    protected ParsedAction<?> readAnonymousAction() {
        String name2;
        String lastBlock = this.currentBlock;
        this.currentBlock = name2 = this.nextAnonymousBlockName();
        List<ParsedAction<?>> actions = this.readActions();
        this.checkLiteral(actions);
        this.currentBlock = lastBlock;
        if (!actions.isEmpty()) {
            ParsedAction<?> head = actions.get(0);
            SimpleQuest.SimpleBlock block = new SimpleQuest.SimpleBlock(name2, actions);
            this.blocks.put(block.getLabel(), block);
            head.set(ActionProperties.BLOCK, block.getLabel());
            return head;
        }
        return ParsedAction.noop();
    }

    protected SimpleReader newActionReader(QuestService<?> service, List<String> namespace2) {
        return new SimpleReader(service, this, namespace2);
    }

    protected String nextAnonymousBlockName() {
        return this.currentBlock + "_anon_" + System.nanoTime();
    }

    protected void processActions(Quest.Block block, List<ParsedAction<?>> actions) {
        if (!actions.isEmpty()) {
            actions.get(0).set(ActionProperties.BLOCK, block.getLabel());
        }
    }

    protected static int lineOf(char[] chars, int index) {
        int line = 1;
        for (int i = 0; i < index; ++i) {
            if (chars[i] != '\n') continue;
            ++line;
        }
        return line;
    }

    public Map<String, Quest.Block> getBlocks() {
        return this.blocks;
    }

    public QuestService<?> getService() {
        return this.service;
    }

    public List<String> getNamespace() {
        return this.namespace;
    }

    public String getCurrentBlock() {
        return this.currentBlock;
    }
}

