/*
 * Decompiled with CFR 0.152.
 */
package cc.trixey.invero.ui.bukkit;

import cc.trixey.invero.taboolib.platform.util.ItemModifierKt;
import cc.trixey.invero.ui.bukkit.Storage;
import cc.trixey.invero.ui.bukkit.util.ItemKt;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin1810.collections.ArraysKt;
import kotlin1810.jvm.internal.Intrinsics;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\n\u0010\u0006\u001a\u00020\u0007*\u00020\b\u001a\f\u0010\t\u001a\u0004\u0018\u00010\u0003*\u00020\b\u001a\u0012\u0010\n\u001a\u00020\u000b*\u00020\b2\u0006\u0010\f\u001a\u00020\u0007\"\u001d\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\r"}, d2={"storageMap", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/UUID;", "Lcc/trixey/invero/ui/bukkit/Storage;", "getStorageMap", "()Ljava/util/concurrent/ConcurrentHashMap;", "isCurrentlyStored", "", "Lorg/bukkit/entity/Player;", "restorePlayerInventory", "storePlayerInventory", "", "hidePlayerInventory", "framework-bukkit"})
public final class PlayerStorageKt {
    @NotNull
    private static final ConcurrentHashMap<UUID, Storage> storageMap = new ConcurrentHashMap();

    @NotNull
    public static final ConcurrentHashMap<UUID, Storage> getStorageMap() {
        return storageMap;
    }

    public static final boolean isCurrentlyStored(@NotNull Player $this$isCurrentlyStored) {
        Intrinsics.checkNotNullParameter((Object)$this$isCurrentlyStored, (String)"<this>");
        return storageMap.containsKey($this$isCurrentlyStored.getUniqueId());
    }

    public static final void storePlayerInventory(@NotNull Player $this$storePlayerInventory, boolean hidePlayerInventory) {
        Intrinsics.checkNotNullParameter((Object)$this$storePlayerInventory, (String)"<this>");
        if (storageMap.containsKey($this$storePlayerInventory.getUniqueId())) {
            throw new IllegalStateException(("Player " + $this$storePlayerInventory.getName() + " is already stored!").toString());
        }
        Map map2 = storageMap;
        UUID uUID = $this$storePlayerInventory.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"uniqueId");
        UUID uUID2 = uUID;
        Storage storage = new Storage(hidePlayerInventory, $this$storePlayerInventory);
        map2.put(uUID2, storage);
    }

    @Nullable
    public static final Storage restorePlayerInventory(@NotNull Player $this$restorePlayerInventory) {
        Storage storage;
        Intrinsics.checkNotNullParameter((Object)$this$restorePlayerInventory, (String)"<this>");
        Storage storage2 = storageMap.get($this$restorePlayerInventory.getUniqueId());
        if (storage2 != null) {
            Storage backup = storage2;
            boolean bl = false;
            if (!backup.isPlayerInventoryHided()) {
                for (int i = 0; i < 36; ++i) {
                    ItemStack[] itemStackArray = $this$restorePlayerInventory.getInventory().getStorageContents();
                    Intrinsics.checkNotNullExpressionValue((Object)itemStackArray, (String)"inventory.storageContents");
                    ItemStack currentSlot = (ItemStack)ArraysKt.getOrNull((Object[])itemStackArray, (int)i);
                    ItemStack previousSlot = (ItemStack)ArraysKt.getOrNull((Object[])backup.getStorage(), (int)i);
                    ItemStack itemStack = currentSlot;
                    if (itemStack != null ? ItemKt.isUIMarked(itemStack) : false) continue;
                    if (ItemModifierKt.isNotAir(currentSlot)) {
                        backup.getStorage()[i] = currentSlot;
                        continue;
                    }
                    if (!ItemModifierKt.isNotAir(previousSlot)) continue;
                    backup.getStorage()[i] = null;
                }
            }
            $this$restorePlayerInventory.getInventory().setStorageContents(backup.getStorage());
            storage = storageMap.remove($this$restorePlayerInventory.getUniqueId());
        } else {
            storage = null;
        }
        return storage;
    }
}

