/*
 * Decompiled with CFR 0.152.
 */
package cc.trixey.invero.common.adventure.adventure.nbt;

import cc.trixey.invero.common.adventure.adventure.nbt.BinaryTag;
import cc.trixey.invero.common.adventure.adventure.nbt.BinaryTagScope;
import cc.trixey.invero.common.adventure.adventure.nbt.BinaryTagType;
import cc.trixey.invero.common.adventure.adventure.nbt.ByteArrayBinaryTag;
import cc.trixey.invero.common.adventure.adventure.nbt.ByteArrayBinaryTagImpl;
import cc.trixey.invero.common.adventure.adventure.nbt.ByteBinaryTag;
import cc.trixey.invero.common.adventure.adventure.nbt.CompoundBinaryTag;
import cc.trixey.invero.common.adventure.adventure.nbt.CompoundBinaryTagImpl;
import cc.trixey.invero.common.adventure.adventure.nbt.DoubleBinaryTag;
import cc.trixey.invero.common.adventure.adventure.nbt.EndBinaryTag;
import cc.trixey.invero.common.adventure.adventure.nbt.FloatBinaryTag;
import cc.trixey.invero.common.adventure.adventure.nbt.IntArrayBinaryTag;
import cc.trixey.invero.common.adventure.adventure.nbt.IntArrayBinaryTagImpl;
import cc.trixey.invero.common.adventure.adventure.nbt.IntBinaryTag;
import cc.trixey.invero.common.adventure.adventure.nbt.ListBinaryTag;
import cc.trixey.invero.common.adventure.adventure.nbt.LongArrayBinaryTag;
import cc.trixey.invero.common.adventure.adventure.nbt.LongArrayBinaryTagImpl;
import cc.trixey.invero.common.adventure.adventure.nbt.LongBinaryTag;
import cc.trixey.invero.common.adventure.adventure.nbt.ShortBinaryTag;
import cc.trixey.invero.common.adventure.adventure.nbt.StringBinaryTag;
import cc.trixey.invero.common.adventure.adventure.nbt.TrackingDataInput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public final class BinaryTagTypes {
    public static final BinaryTagType<EndBinaryTag> END = BinaryTagType.register(EndBinaryTag.class, (byte)0, input -> EndBinaryTag.get(), null);
    public static final BinaryTagType<ByteBinaryTag> BYTE = BinaryTagType.registerNumeric(ByteBinaryTag.class, (byte)1, input -> ByteBinaryTag.of(input.readByte()), (tag, output) -> output.writeByte(tag.value()));
    public static final BinaryTagType<ShortBinaryTag> SHORT = BinaryTagType.registerNumeric(ShortBinaryTag.class, (byte)2, input -> ShortBinaryTag.of(input.readShort()), (tag, output) -> output.writeShort(tag.value()));
    public static final BinaryTagType<IntBinaryTag> INT = BinaryTagType.registerNumeric(IntBinaryTag.class, (byte)3, input -> IntBinaryTag.of(input.readInt()), (tag, output) -> output.writeInt(tag.value()));
    public static final BinaryTagType<LongBinaryTag> LONG = BinaryTagType.registerNumeric(LongBinaryTag.class, (byte)4, input -> LongBinaryTag.of(input.readLong()), (tag, output) -> output.writeLong(tag.value()));
    public static final BinaryTagType<FloatBinaryTag> FLOAT = BinaryTagType.registerNumeric(FloatBinaryTag.class, (byte)5, input -> FloatBinaryTag.of(input.readFloat()), (tag, output) -> output.writeFloat(tag.value()));
    public static final BinaryTagType<DoubleBinaryTag> DOUBLE = BinaryTagType.registerNumeric(DoubleBinaryTag.class, (byte)6, input -> DoubleBinaryTag.of(input.readDouble()), (tag, output) -> output.writeDouble(tag.value()));
    public static final BinaryTagType<ByteArrayBinaryTag> BYTE_ARRAY = BinaryTagType.register(ByteArrayBinaryTag.class, (byte)7, input -> {
        int length = input.readInt();
        try (BinaryTagScope ignored = TrackingDataInput.enter(input, length);){
            byte[] value2 = new byte[length];
            input.readFully(value2);
            ByteArrayBinaryTag byteArrayBinaryTag = ByteArrayBinaryTag.of(value2);
            return byteArrayBinaryTag;
        }
    }, (tag, output) -> {
        byte[] value2 = ByteArrayBinaryTagImpl.value(tag);
        output.writeInt(value2.length);
        output.write(value2);
    });
    public static final BinaryTagType<StringBinaryTag> STRING = BinaryTagType.register(StringBinaryTag.class, (byte)8, input -> StringBinaryTag.of(input.readUTF()), (tag, output) -> output.writeUTF(tag.value()));
    public static final BinaryTagType<ListBinaryTag> LIST = BinaryTagType.register(ListBinaryTag.class, (byte)9, input -> {
        BinaryTagType<BinaryTag> type2 = BinaryTagType.of(input.readByte());
        int length = input.readInt();
        try (BinaryTagScope ignored = TrackingDataInput.enter(input, (long)length * 8L);){
            ArrayList<BinaryTag> tags = new ArrayList<BinaryTag>(length);
            for (int i = 0; i < length; ++i) {
                tags.add(type2.read(input));
            }
            ListBinaryTag listBinaryTag = ListBinaryTag.of(type2, tags);
            return listBinaryTag;
        }
    }, (tag, output) -> {
        output.writeByte(tag.elementType().id());
        int size = tag.size();
        output.writeInt(size);
        for (BinaryTag item2 : tag) {
            BinaryTagType.writeUntyped(item2.type(), item2, output);
        }
    });
    public static final BinaryTagType<CompoundBinaryTag> COMPOUND = BinaryTagType.register(CompoundBinaryTag.class, (byte)10, input -> {
        try (BinaryTagScope ignored = TrackingDataInput.enter(input);){
            BinaryTagType<BinaryTag> type2;
            HashMap<String, BinaryTag> tags = new HashMap<String, BinaryTag>();
            while ((type2 = BinaryTagType.of(input.readByte())) != END) {
                String key2 = input.readUTF();
                BinaryTag tag = type2.read(input);
                tags.put(key2, tag);
            }
            CompoundBinaryTagImpl compoundBinaryTagImpl = new CompoundBinaryTagImpl(tags);
            return compoundBinaryTagImpl;
        }
    }, (tag, output) -> {
        for (Map.Entry entry : tag) {
            BinaryTag value2 = (BinaryTag)entry.getValue();
            if (value2 == null) continue;
            BinaryTagType<? extends BinaryTag> type2 = value2.type();
            output.writeByte(type2.id());
            if (type2 == END) continue;
            output.writeUTF((String)entry.getKey());
            BinaryTagType.writeUntyped(type2, value2, output);
        }
        output.writeByte(END.id());
    });
    public static final BinaryTagType<IntArrayBinaryTag> INT_ARRAY = BinaryTagType.register(IntArrayBinaryTag.class, (byte)11, input -> {
        int length = input.readInt();
        try (BinaryTagScope ignored = TrackingDataInput.enter(input, (long)length * 4L);){
            int[] value2 = new int[length];
            for (int i = 0; i < length; ++i) {
                value2[i] = input.readInt();
            }
            IntArrayBinaryTag intArrayBinaryTag = IntArrayBinaryTag.of(value2);
            return intArrayBinaryTag;
        }
    }, (tag, output) -> {
        int[] value2 = IntArrayBinaryTagImpl.value(tag);
        int length = value2.length;
        output.writeInt(length);
        for (int i = 0; i < length; ++i) {
            output.writeInt(value2[i]);
        }
    });
    public static final BinaryTagType<LongArrayBinaryTag> LONG_ARRAY = BinaryTagType.register(LongArrayBinaryTag.class, (byte)12, input -> {
        int length = input.readInt();
        try (BinaryTagScope ignored = TrackingDataInput.enter(input, (long)length * 8L);){
            long[] value2 = new long[length];
            for (int i = 0; i < length; ++i) {
                value2[i] = input.readLong();
            }
            LongArrayBinaryTag longArrayBinaryTag = LongArrayBinaryTag.of(value2);
            return longArrayBinaryTag;
        }
    }, (tag, output) -> {
        long[] value2 = LongArrayBinaryTagImpl.value(tag);
        int length = value2.length;
        output.writeInt(length);
        for (int i = 0; i < length; ++i) {
            output.writeLong(value2[i]);
        }
    });

    private BinaryTagTypes() {
    }
}

