/*
 * Decompiled with CFR 0.152.
 */
package cc.trixey.invero.taboolib.common.classloader;

import cc.trixey.invero.taboolib.common.SkipIsolatedClassLoader;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class IsolatedClassLoader
extends URLClassLoader {
    private static final Set<String> excludeClasses = new HashSet<String>();
    private static boolean isEnabled = false;

    public IsolatedClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name2, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name2);
        synchronized (object) {
            Class<?> loadedClass = this.findLoadedClass(name2);
            if (loadedClass == null) {
                ClassLoader parent;
                if (!excludeClasses.contains(name2)) {
                    try {
                        loadedClass = this.findClass(name2);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                if (loadedClass == null && (parent = this.getParent()) != null) {
                    loadedClass = parent.loadClass(name2);
                }
            }
            if (resolve) {
                this.resolveClass(loadedClass);
            }
            return loadedClass;
        }
    }

    public static boolean isEnabled() {
        return isEnabled;
    }

    static {
        try {
            Class<SkipIsolatedClassLoader> clazz = SkipIsolatedClassLoader.class;
        }
        catch (NoClassDefFoundError ignored) {
            isEnabled = true;
            excludeClasses.addAll(Arrays.asList("cc.trixey.invero.taboolib.common.classloader.IsolatedClassLoader", "cc.trixey.invero.taboolib.common.platform.Plugin", "cc.trixey.invero.taboolib.platform.BukkitPlugin", "cc.trixey.invero.taboolib.platform.BungeePlugin", "cc.trixey.invero.taboolib.platform.VelocityPlugin", "cc.trixey.invero.taboolib.platform.CloudNetV3Plugin", "cc.trixey.invero.taboolib.platform.NukkitPlugin", "cc.trixey.invero.taboolib.platform.Sponge7Plugin", "cc.trixey.invero.taboolib.platform.Sponge8Plugin", "cc.trixey.invero.taboolib.platform.Sponge9Plugin"));
        }
    }
}

