/*
 * Decompiled with CFR 0.152.
 */
package cc.trixey.invero.taboolib.common.env;

import cc.trixey.invero.taboolib.common.TabooLibCommon;
import cc.trixey.invero.taboolib.common.classloader.IsolatedClassLoader;
import java.io.File;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import sun.misc.Unsafe;

public class ClassAppender {
    static MethodHandles.Lookup lookup;
    static Unsafe unsafe;

    ClassAppender() {
    }

    public static ClassLoader addPath(Path path, boolean isIsolated, boolean isInitiative) {
        try {
            File file = new File(path.toUri().getPath());
            ClassLoader loader = TabooLibCommon.class.getClassLoader();
            if (loader instanceof IsolatedClassLoader && IsolatedClassLoader.isEnabled()) {
                if (isIsolated || isInitiative) {
                    Field ucpField;
                    try {
                        ucpField = URLClassLoader.class.getDeclaredField("ucp");
                    }
                    catch (NoSuchFieldError | NoSuchFieldException ignored) {
                        ucpField = ClassAppender.ucp(loader.getClass());
                    }
                    ClassAppender.addURL(loader, ucpField, file);
                    return loader;
                }
                loader = loader.getParent();
            }
            if (loader.getClass().getName().equals("jdk.internal.loader.ClassLoaders$AppClassLoader")) {
                ClassAppender.addURL(loader, ClassAppender.ucp(loader.getClass()), file);
            } else if (loader.getClass().getName().equals("net.minecraft.launchwrapper.LaunchClassLoader")) {
                MethodHandle methodHandle = lookup.findVirtual(URLClassLoader.class, "addURL", MethodType.methodType(Void.TYPE, URL.class));
                methodHandle.invoke(loader, file.toURI().toURL());
            } else {
                Field ucpField;
                try {
                    ucpField = URLClassLoader.class.getDeclaredField("ucp");
                }
                catch (NoSuchFieldError | NoSuchFieldException ignored) {
                    ucpField = ClassAppender.ucp(loader.getClass());
                }
                ClassAppender.addURL(loader, ucpField, file);
            }
            return loader;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public static ClassLoader judgeAddPathClassLoader(boolean isIsolated, boolean isInitiative) {
        ClassLoader loader = TabooLibCommon.class.getClassLoader();
        if (loader instanceof IsolatedClassLoader && IsolatedClassLoader.isEnabled()) {
            if (isIsolated || isInitiative) {
                return loader;
            }
            return loader.getParent();
        }
        return loader;
    }

    public static boolean isExists(String path) {
        try {
            Class.forName(path, false, TabooLibCommon.class.getClassLoader());
            return true;
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
    }

    private static void addURL(ClassLoader loader, Field ucpField, File file) throws Throwable {
        if (ucpField == null) {
            throw new IllegalStateException("ucp field not found");
        }
        Object ucp = unsafe.getObject(loader, unsafe.objectFieldOffset(ucpField));
        try {
            MethodHandle methodHandle = lookup.findVirtual(ucp.getClass(), "addURL", MethodType.methodType(Void.TYPE, URL.class));
            methodHandle.invoke(ucp, file.toURI().toURL());
        }
        catch (NoSuchMethodError e2) {
            throw new IllegalStateException("Unsupported (classloader: " + loader.getClass().getName() + ", ucp: " + ucp.getClass().getName() + ")", e2);
        }
    }

    private static Field ucp(Class<?> loader) {
        try {
            return loader.getDeclaredField("ucp");
        }
        catch (NoSuchFieldError | NoSuchFieldException e2) {
            Class<?> superclass2 = loader.getSuperclass();
            if (superclass2 == Object.class) {
                return null;
            }
            return ClassAppender.ucp(superclass2);
        }
    }

    static {
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            unsafe = (Unsafe)field.get(null);
            Field lookupField = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
            Object lookupBase = unsafe.staticFieldBase(lookupField);
            long lookupOffset = unsafe.staticFieldOffset(lookupField);
            lookup = (MethodHandles.Lookup)unsafe.getObject(lookupBase, lookupOffset);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

