/*
 * Decompiled with CFR 0.152.
 */
package cc.trixey.invero.taboolib.module.kether;

import cc.trixey.invero.taboolib.common.util.StringKt;
import cc.trixey.invero.taboolib.library.kether.DefaultRegistry;
import cc.trixey.invero.taboolib.library.kether.Quest;
import cc.trixey.invero.taboolib.library.kether.QuestRegistry;
import cc.trixey.invero.taboolib.library.kether.QuestService;
import cc.trixey.invero.taboolib.library.kether.ServiceHolder;
import cc.trixey.invero.taboolib.module.configuration.Config;
import cc.trixey.invero.taboolib.module.configuration.Configuration;
import cc.trixey.invero.taboolib.module.kether.ScriptContext;
import cc.trixey.invero.taboolib.module.kether.ScriptSchedulerExecutor;
import cc.trixey.invero.taboolib.module.kether.ScriptService;
import cc.trixey.invero.taboolib.module.kether.Workspace;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import kotlin.Metadata;
import kotlin1810.Lazy;
import kotlin1810.LazyKt;
import kotlin1810.jvm.functions.Function0;
import kotlin1810.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0016\u001a\u00020\u0005H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J)\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0012\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001e0\u001d\"\u00020\u001eH\u0016\u00a2\u0006\u0002\u0010\u001fJ\u001a\u0010 \u001a\f\u0012\b\u0012\u00060\"j\u0002`#0!2\u0006\u0010$\u001a\u00020\u001aH\u0016J\u001e\u0010%\u001a\u0010\u0012\u0004\u0012\u00020\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u001e0&2\u0006\u0010$\u001a\u00020\u001aH\u0016J\u0018\u0010'\u001a\u0012\u0012\u0004\u0012\u00020\u001a\u0012\b\u0012\u00060\"j\u0002`#0&H\u0016J\b\u0010(\u001a\u00020)H\u0016J\u0014\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00020+H\u0016J\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00020,2\u0006\u0010-\u001a\u00020\u001aH\u0016J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u0002H\u0016J\u0010\u00101\u001a\u00020/2\u0006\u00100\u001a\u00020\u0002H\u0016R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b8\u0006@BX\u0087.\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\f\u001a\u00020\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcc/trixey/invero/taboolib/module/kether/ScriptService;", "Lcc/trixey/invero/taboolib/library/kether/QuestService;", "Lcc/trixey/invero/taboolib/module/kether/ScriptContext;", "()V", "asyncExecutor", "Ljava/util/concurrent/ScheduledExecutorService;", "kotlin1810.jvm.PlatformType", "<set-?>", "Lcc/trixey/invero/taboolib/module/configuration/Configuration;", "locale", "getLocale", "()Ltaboolib/module/configuration/Configuration;", "mainspace", "Lcc/trixey/invero/taboolib/module/kether/Workspace;", "getMainspace", "()Ltaboolib/module/kether/Workspace;", "mainspace$delegate", "Lkotlin1810/Lazy;", "registry", "Lcc/trixey/invero/taboolib/library/kether/DefaultRegistry;", "syncExecutor", "Lcc/trixey/invero/taboolib/module/kether/ScriptSchedulerExecutor;", "getAsyncExecutor", "getExecutor", "Ljava/util/concurrent/Executor;", "getLocalizedText", "", "node", "params", "", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "getQuest", "Ljava/util/Optional;", "Lcc/trixey/invero/taboolib/library/kether/Quest;", "Lcc/trixey/invero/taboolib/module/kether/Script;", "id", "getQuestSettings", "", "getQuests", "getRegistry", "Lcc/trixey/invero/taboolib/library/kether/QuestRegistry;", "getRunningQuests", "Lcom/google/common/collect/Multimap;", "", "playerIdentifier", "startQuest", "", "context", "terminateQuest", "module-kether"})
public final class ScriptService
implements QuestService<ScriptContext> {
    @NotNull
    public static final ScriptService INSTANCE = new ScriptService();
    @NotNull
    private static final DefaultRegistry registry;
    @NotNull
    private static final ScriptSchedulerExecutor syncExecutor;
    private static final ScheduledExecutorService asyncExecutor;
    @Config(value="kether.yml")
    private static Configuration locale;
    @NotNull
    private static final Lazy mainspace$delegate;

    private ScriptService() {
    }

    @NotNull
    public final Configuration getLocale() {
        Configuration configuration = locale;
        if (configuration != null) {
            return configuration;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"locale");
        throw null;
    }

    @NotNull
    public final Workspace getMainspace() {
        Lazy lazy = mainspace$delegate;
        boolean bl = false;
        return (Workspace)lazy.getValue();
    }

    @Override
    @NotNull
    public QuestRegistry getRegistry() {
        return registry;
    }

    @Override
    @NotNull
    public Optional<Quest> getQuest(@NotNull String id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Optional<Quest> optional = Optional.ofNullable(this.getMainspace().getScripts().get(id2));
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(mainspace.scripts[id])");
        return optional;
    }

    @Override
    @NotNull
    public Map<String, Object> getQuestSettings(@NotNull String id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Map<String, Object> map2 = Collections.unmodifiableMap(this.getMainspace().getScriptsSetting().getOrDefault(id2, (Map<String, Object>)ImmutableMap.of()));
        Intrinsics.checkNotNullExpressionValue(map2, (String)"unmodifiableMap(mainspace.scriptsSetting.getOrDefault(id, ImmutableMap.of()))");
        return map2;
    }

    @Override
    @NotNull
    public Map<String, Quest> getQuests() {
        Map<String, Quest> map2 = Collections.unmodifiableMap((Map)this.getMainspace().getScripts());
        Intrinsics.checkNotNullExpressionValue(map2, (String)"unmodifiableMap(mainspace.scripts)");
        return map2;
    }

    @Override
    @NotNull
    public Multimap<String, ScriptContext> getRunningQuests() {
        return (Multimap)this.getMainspace().getRunningScripts();
    }

    @Override
    @NotNull
    public List<ScriptContext> getRunningQuests(@NotNull String playerIdentifier) {
        Intrinsics.checkNotNullParameter((Object)playerIdentifier, (String)"playerIdentifier");
        List<ScriptContext> list2 = Collections.unmodifiableList(this.getMainspace().getRunningScripts().get((Object)playerIdentifier));
        Intrinsics.checkNotNullExpressionValue(list2, (String)"unmodifiableList(mainspace.runningScripts[playerIdentifier])");
        return list2;
    }

    @Override
    @NotNull
    public Executor getExecutor() {
        return syncExecutor;
    }

    @Override
    @NotNull
    public ScheduledExecutorService getAsyncExecutor() {
        ScheduledExecutorService scheduledExecutorService = asyncExecutor;
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"asyncExecutor");
        return scheduledExecutorService;
    }

    @Override
    @NotNull
    public String getLocalizedText(@NotNull String node2, Object ... params) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        String string = this.getLocale().getString(node2, '{' + node2 + '}');
        Intrinsics.checkNotNull((Object)string);
        return StringKt.replaceWithOrder(string, Arrays.copyOf(params, params.length));
    }

    @Override
    public void startQuest(@NotNull ScriptContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Workspace workspace = this.getMainspace();
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        workspace.runScript(string, context2);
    }

    @Override
    public void terminateQuest(@NotNull ScriptContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.getMainspace().terminateScript(context2);
    }

    static {
        ServiceHolder.setQuestServiceInstance(INSTANCE);
        registry = new DefaultRegistry();
        syncExecutor = ScriptSchedulerExecutor.INSTANCE;
        asyncExecutor = Executors.newScheduledThreadPool(2);
        mainspace$delegate = LazyKt.lazy((Function0)mainspace.2.INSTANCE);
    }
}

