/*
 * Decompiled with CFR 0.152.
 */
package cc.trixey.invero.taboolib.type;

import cc.trixey.invero.taboolib.common.Isolated;
import com.google.common.base.Enums;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Isolated
public enum BukkitEquipment {
    HAND(EquipmentSlot.HAND, "mainhand", -1),
    OFF_HAND((EquipmentSlot)Enums.getIfPresent(EquipmentSlot.class, (String)"OFF_HAND").or((Object)EquipmentSlot.HAND), "offhand", 40),
    FEET(EquipmentSlot.FEET, "feet", 36),
    LEGS(EquipmentSlot.LEGS, "legs", 37),
    CHEST(EquipmentSlot.CHEST, "chest", 38),
    HEAD(EquipmentSlot.HEAD, "head", 39);

    private final EquipmentSlot bukkit;
    private final String nms;
    private final int slot;

    private BukkitEquipment(EquipmentSlot bukkit, String nms, int slot) {
        this.bukkit = bukkit;
        this.nms = nms;
        this.slot = slot;
    }

    public void setItem(Player player2, ItemStack item2) {
        this.setItem((LivingEntity)player2, item2);
    }

    public void setItem(LivingEntity entity, ItemStack item2) {
        EntityEquipment equipment = entity.getEquipment();
        if (equipment == null) {
            return;
        }
        switch (this) {
            case HAND: {
                try {
                    equipment.setItemInMainHand(item2);
                }
                catch (NoSuchMethodError ex) {
                    equipment.setItemInHand(item2);
                }
                break;
            }
            case OFF_HAND: {
                equipment.setItemInOffHand(item2);
                break;
            }
            case FEET: {
                equipment.setBoots(item2);
                break;
            }
            case LEGS: {
                equipment.setLeggings(item2);
                break;
            }
            case CHEST: {
                equipment.setChestplate(item2);
                break;
            }
            case HEAD: {
                equipment.setHelmet(item2);
            }
        }
    }

    public void setItemDropChance(LivingEntity entity, float chance2) {
        EntityEquipment equipment = entity.getEquipment();
        if (equipment == null) {
            return;
        }
        switch (this) {
            case HAND: {
                try {
                    equipment.setItemInMainHandDropChance(chance2);
                }
                catch (NoSuchMethodError ex) {
                    equipment.setItemInHandDropChance(chance2);
                }
                break;
            }
            case OFF_HAND: {
                equipment.setItemInOffHandDropChance(chance2);
                break;
            }
            case FEET: {
                equipment.setBootsDropChance(chance2);
                break;
            }
            case LEGS: {
                equipment.setLeggingsDropChance(chance2);
                break;
            }
            case CHEST: {
                equipment.setChestplateDropChance(chance2);
                break;
            }
            case HEAD: {
                equipment.setHelmetDropChance(chance2);
            }
        }
    }

    @Nullable
    public ItemStack getItem(Player player2) {
        return this.getItem((LivingEntity)player2);
    }

    @Nullable
    public ItemStack getItem(LivingEntity entity) {
        EntityEquipment equipment = entity.getEquipment();
        if (equipment == null) {
            return null;
        }
        switch (this) {
            case HAND: {
                try {
                    return equipment.getItemInMainHand();
                }
                catch (NoSuchMethodError ex) {
                    return equipment.getItemInHand();
                }
            }
            case OFF_HAND: {
                return equipment.getItemInOffHand();
            }
            case FEET: {
                return equipment.getBoots();
            }
            case LEGS: {
                return equipment.getLeggings();
            }
            case CHEST: {
                return equipment.getChestplate();
            }
            case HEAD: {
                return equipment.getHelmet();
            }
        }
        return null;
    }

    public float getItemDropChance(LivingEntity entity) {
        EntityEquipment equipment = entity.getEquipment();
        if (equipment == null) {
            return 0.0f;
        }
        switch (this) {
            case HAND: {
                try {
                    return equipment.getItemInMainHandDropChance();
                }
                catch (NoSuchMethodError ex) {
                    return equipment.getItemInHandDropChance();
                }
            }
            case OFF_HAND: {
                return equipment.getItemInOffHandDropChance();
            }
            case FEET: {
                return equipment.getBootsDropChance();
            }
            case LEGS: {
                return equipment.getLeggingsDropChance();
            }
            case CHEST: {
                return equipment.getChestplateDropChance();
            }
            case HEAD: {
                return equipment.getHelmetDropChance();
            }
        }
        return 0.0f;
    }

    @Nullable
    public static BukkitEquipment fromString(String value2) {
        switch (value2.toLowerCase(Locale.getDefault())) {
            case "0": 
            case "hand": 
            case "mainhand": {
                return HAND;
            }
            case "1": 
            case "head": 
            case "helmet": {
                return HEAD;
            }
            case "2": 
            case "chest": 
            case "chestplate": {
                return CHEST;
            }
            case "3": 
            case "legs": 
            case "leggings": {
                return LEGS;
            }
            case "4": 
            case "feet": 
            case "boots": {
                return FEET;
            }
            case "-1": 
            case "5": 
            case "offhand": {
                return OFF_HAND;
            }
        }
        return null;
    }

    @Nullable
    public static BukkitEquipment fromNMS(String nms) {
        return Arrays.stream(BukkitEquipment.values()).filter(tEquipment -> tEquipment.nms.equalsIgnoreCase(nms)).findFirst().orElse(null);
    }

    @Nullable
    public static BukkitEquipment fromBukkit(EquipmentSlot bukkit) {
        return Arrays.stream(BukkitEquipment.values()).filter(tEquipment -> tEquipment.bukkit == bukkit).findFirst().orElse(null);
    }

    @NotNull
    public static Map<BukkitEquipment, ItemStack> getItems(Player player2) {
        return BukkitEquipment.getItems((LivingEntity)player2);
    }

    @NotNull
    public static Map<BukkitEquipment, ItemStack> getItems(LivingEntity entity) {
        HashMap map2 = Maps.newHashMap();
        for (BukkitEquipment bukkitEquipment : BukkitEquipment.values()) {
            ItemStack itemStack = bukkitEquipment.getItem(entity);
            if (itemStack == null) continue;
            map2.put(bukkitEquipment, itemStack);
        }
        return map2;
    }

    public EquipmentSlot getBukkit() {
        return this.bukkit;
    }

    public String getNMS() {
        return this.nms;
    }

    public int getSlot() {
        return this.slot;
    }
}

