/*
 * Decompiled with CFR 0.152.
 */
package dev.lone.itemsadder.api;

import dev.lone.itemsadder.api.CustomStack;
import ia.m.G;
import ia.m.bq;
import ia.m.ex;
import ia.m.jS;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.jetbrains.annotations.Nullable;

public class CustomFurniture
extends CustomStack {
    Entity entity;
    private bq behaviour;

    CustomFurniture(ex ex2, Entity entity) {
        super(ex2);
        this.entity = entity;
        this.initItemStack(entity);
    }

    CustomFurniture(ex ex2, ItemStack itemStack, Entity entity, bq bq2) {
        super(ex2, itemStack);
        this.entity = entity;
        this.behaviour = bq2;
        this.initItemStack(entity);
    }

    private void initItemStack(Entity entity) {
        ItemStack itemStack;
        if (entity instanceof ArmorStand) {
            itemStack = ((ArmorStand)entity).getHelmet();
        } else if (entity instanceof ItemFrame) {
            itemStack = ((ItemFrame)entity).getItem();
        } else {
            throw new RuntimeException("This furniture entity somehow is not an armorstand or itemframe.");
        }
        this.itemStack = itemStack;
    }

    @Nullable
    public static CustomFurniture byAlreadySpawned(Entity entity) {
        ItemStack itemStack = null;
        if (entity instanceof ArmorStand) {
            itemStack = ((ArmorStand)entity).getHelmet();
        } else if (entity instanceof ItemFrame) {
            itemStack = ((ItemFrame)entity).getItem().clone();
        }
        if (!ex.isCustomItem(itemStack)) {
            return null;
        }
        ex ex2 = G.a().a(itemStack);
        if (ex2 == null) {
            return null;
        }
        bq bq2 = (bq)ex2.a.a("furniture");
        if (bq2 == null) {
            return null;
        }
        return new CustomFurniture(ex2, entity);
    }

    @Nullable
    public static CustomFurniture byAlreadySpawned(Block block) {
        Optional optional = block.getLocation().getWorld().getNearbyEntities(block.getLocation(), 0.1, 0.1, 0.1).stream().findFirst();
        if (optional.isPresent()) {
            return CustomFurniture.byAlreadySpawned((Entity)optional.get());
        }
        return null;
    }

    @Nullable
    public static CustomFurniture spawnPreciseNonSolid(String string, Location location) {
        ex ex2 = G.a().a(string);
        if (ex2 == null) {
            return null;
        }
        if (!ex2.a.l("furniture")) {
            return null;
        }
        ItemStack itemStack = ex2.a();
        bq bq2 = (bq)ex2.a.a("furniture");
        Entity entity = bq2.a(itemStack, location);
        return new CustomFurniture(ex2, itemStack, entity, bq2);
    }

    @Nullable
    public static CustomFurniture spawn(String string, Block block) {
        ex ex2 = G.a().a(string);
        if (ex2 == null) {
            return null;
        }
        if (!ex2.a.l("furniture")) {
            return null;
        }
        ItemStack itemStack = ex2.a();
        bq bq2 = (bq)ex2.a.a("furniture");
        Entity entity = bq2.a(itemStack, block);
        return new CustomFurniture(ex2, itemStack, entity, bq2);
    }

    public void remove(boolean bl2) {
        if (this.entity != null) {
            CustomFurniture.remove(this.entity, bl2);
        }
    }

    public static void remove(Entity entity, boolean bl2) {
        G.a().a.a(entity, bl2);
    }

    public void teleport(Entity entity) {
        this.teleport(entity.getLocation());
    }

    public void teleport(Location location) {
        if (this.entity != null) {
            if (this.behaviour.X()) {
                this.behaviour.h(this.entity);
            }
            this.entity.teleport(location);
        }
    }

    public void replaceFurniture(String string) {
        this.replaceFurniture(string, null);
    }

    public void replaceFurniture(String string, Color color) {
        ex ex2 = G.a().a(string);
        if (ex2 == null) {
            throw new NoSuchElementException("No custom item with that namespacedId: " + string);
        }
        if (!ex2.a.l("furniture")) {
            throw new NoSuchElementException("Custom item has no furniture behaviour with that namespacedId: " + string);
        }
        if (bq.a(ex2, this.internalItem, this.entity)) {
            this.replace(this.itemStack, ex2);
            this.itemStack = ex2.a();
            this.itemStack = bq.a(this.itemStack);
            if (color != null) {
                this.setColor(color);
            } else if (this.entity instanceof ArmorStand) {
                ((ArmorStand)this.entity).setHelmet(this.itemStack);
            } else if (this.entity instanceof ItemFrame) {
                ((ItemFrame)this.entity).setItem(this.itemStack, false);
            }
        }
    }

    public void setColor(Color color) {
        ItemMeta itemMeta = this.itemStack.getItemMeta();
        if (itemMeta instanceof PotionMeta) {
            ((PotionMeta)itemMeta).setColor(color);
            this.itemStack.setItemMeta(itemMeta);
        } else if (itemMeta instanceof LeatherArmorMeta) {
            ((LeatherArmorMeta)itemMeta).setColor(color);
            this.itemStack.setItemMeta(itemMeta);
        }
        if (this.entity instanceof ArmorStand) {
            ((ArmorStand)this.entity).setHelmet(this.itemStack);
        } else if (this.entity instanceof ItemFrame) {
            ((ItemFrame)this.entity).setItem(this.itemStack, false);
        }
    }

    public int getOriginalLightLevel() {
        return this.behaviour.m();
    }

    public void setCurrentLightLevel(int n2) {
        jS.V(this.entity.getLocation().getBlock());
        jS.d(this.entity.getLocation().getBlock(), n2);
    }

    @Deprecated
    @Nullable
    public Entity getArmorstand() {
        return this.entity;
    }

    @Nullable
    public Entity getEntity() {
        return this.entity;
    }
}

