/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.com.jayway.jsonpath.internal;

import ia.sh.com.jayway.jsonpath.Configuration;
import ia.sh.com.jayway.jsonpath.DocumentContext;
import ia.sh.com.jayway.jsonpath.ParseContext;
import ia.sh.com.jayway.jsonpath.internal.JsonContext;
import ia.sh.com.jayway.jsonpath.internal.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;

public class ParseContextImpl
implements ParseContext {
    private final Configuration configuration;

    public ParseContextImpl() {
        this(Configuration.defaultConfiguration());
    }

    public ParseContextImpl(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public DocumentContext parse(Object object) {
        Utils.notNull(object, "json object can not be null");
        return new JsonContext(object, this.configuration);
    }

    @Override
    public DocumentContext parse(String string) {
        Utils.notEmpty(string, "json string can not be null or empty");
        Object object = this.configuration.jsonProvider().parse(string);
        return new JsonContext(object, this.configuration);
    }

    @Override
    public DocumentContext parseUtf8(byte[] byArray) {
        Utils.notEmpty(byArray, "json bytes can not be null or empty");
        Object object = this.configuration.jsonProvider().parse(byArray);
        return new JsonContext(object, this.configuration);
    }

    @Override
    public DocumentContext parse(InputStream inputStream) {
        return this.parse(inputStream, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DocumentContext parse(InputStream inputStream, String string) {
        Utils.notNull(inputStream, "json input stream can not be null");
        Utils.notNull(string, "charset can not be null");
        try {
            Object object = this.configuration.jsonProvider().parse(inputStream, string);
            JsonContext jsonContext = new JsonContext(object, this.configuration);
            return jsonContext;
        }
        finally {
            Utils.closeQuietly(inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DocumentContext parse(File file) {
        DocumentContext documentContext;
        Utils.notNull(file, "json file can not be null");
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            documentContext = this.parse(fileInputStream);
        }
        catch (Throwable throwable) {
            Utils.closeQuietly(fileInputStream);
            throw throwable;
        }
        Utils.closeQuietly(fileInputStream);
        return documentContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public DocumentContext parse(URL uRL) {
        Utils.notNull(uRL, "url can not be null");
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
            DocumentContext documentContext = this.parse(inputStream);
            return documentContext;
        }
        finally {
            Utils.closeQuietly(inputStream);
        }
    }
}

