/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.com.jayway.jsonpath.internal.filter;

import ia.sh.com.jayway.jsonpath.Predicate;
import ia.sh.com.jayway.jsonpath.internal.Utils;
import ia.sh.com.jayway.jsonpath.internal.filter.ExpressionNode;
import ia.sh.com.jayway.jsonpath.internal.filter.LogicalOperator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LogicalExpressionNode
extends ExpressionNode {
    protected List chain = new ArrayList();
    private final LogicalOperator operator;

    public static ExpressionNode createLogicalNot(ExpressionNode expressionNode) {
        return new LogicalExpressionNode(expressionNode, LogicalOperator.NOT, null);
    }

    public static LogicalExpressionNode createLogicalOr(ExpressionNode expressionNode, ExpressionNode expressionNode2) {
        return new LogicalExpressionNode(expressionNode, LogicalOperator.OR, expressionNode2);
    }

    public static LogicalExpressionNode createLogicalOr(Collection collection) {
        return new LogicalExpressionNode(LogicalOperator.OR, collection);
    }

    public static LogicalExpressionNode createLogicalAnd(ExpressionNode expressionNode, ExpressionNode expressionNode2) {
        return new LogicalExpressionNode(expressionNode, LogicalOperator.AND, expressionNode2);
    }

    public static LogicalExpressionNode createLogicalAnd(Collection collection) {
        return new LogicalExpressionNode(LogicalOperator.AND, collection);
    }

    private LogicalExpressionNode(ExpressionNode expressionNode, LogicalOperator logicalOperator, ExpressionNode expressionNode2) {
        this.chain.add(expressionNode);
        this.chain.add(expressionNode2);
        this.operator = logicalOperator;
    }

    private LogicalExpressionNode(LogicalOperator logicalOperator, Collection collection) {
        this.chain.addAll(collection);
        this.operator = logicalOperator;
    }

    public LogicalExpressionNode and(LogicalExpressionNode logicalExpressionNode) {
        return LogicalExpressionNode.createLogicalAnd(this, logicalExpressionNode);
    }

    public LogicalExpressionNode or(LogicalExpressionNode logicalExpressionNode) {
        return LogicalExpressionNode.createLogicalOr(this, logicalExpressionNode);
    }

    public LogicalOperator getOperator() {
        return this.operator;
    }

    public LogicalExpressionNode append(ExpressionNode expressionNode) {
        this.chain.add(0, expressionNode);
        return this;
    }

    public String toString() {
        return "(" + Utils.join(" " + this.operator.getOperatorString() + " ", this.chain) + ")";
    }

    @Override
    public boolean apply(Predicate.PredicateContext predicateContext) {
        if (this.operator == LogicalOperator.OR) {
            for (ExpressionNode expressionNode : this.chain) {
                if (!expressionNode.apply(predicateContext)) continue;
                return true;
            }
            return false;
        }
        if (this.operator == LogicalOperator.AND) {
            for (ExpressionNode expressionNode : this.chain) {
                if (expressionNode.apply(predicateContext)) continue;
                return false;
            }
            return true;
        }
        ExpressionNode expressionNode = (ExpressionNode)this.chain.get(0);
        return !expressionNode.apply(predicateContext);
    }
}

