/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.com.jayway.jsonpath.internal.path;

import ia.sh.com.jayway.jsonpath.Configuration;
import ia.sh.com.jayway.jsonpath.Predicate$PredicateContext;
import ia.sh.com.jayway.jsonpath.internal.Path;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PredicateContextImpl
implements Predicate$PredicateContext {
    private static final Logger logger = LoggerFactory.getLogger(PredicateContextImpl.class);
    private final Object contextDocument;
    private final Object rootDocument;
    private final Configuration configuration;
    private final HashMap documentPathCache;

    public PredicateContextImpl(Object object, Object object2, Configuration configuration, HashMap hashMap) {
        this.contextDocument = object;
        this.rootDocument = object2;
        this.configuration = configuration;
        this.documentPathCache = hashMap;
    }

    public Object evaluate(Path path) {
        Object object;
        if (path.isRootPath()) {
            if (this.documentPathCache.containsKey(path)) {
                logger.debug("Using cached result for root path: " + path.toString());
                object = this.documentPathCache.get(path);
            } else {
                object = path.evaluate(this.rootDocument, this.rootDocument, this.configuration).getValue();
                this.documentPathCache.put(path, object);
            }
        } else {
            object = path.evaluate(this.contextDocument, this.rootDocument, this.configuration).getValue();
        }
        return object;
    }

    public HashMap documentPathCache() {
        return this.documentPathCache;
    }

    @Override
    public Object item() {
        return this.contextDocument;
    }

    @Override
    public Object item(Class clazz) {
        return this.configuration().mappingProvider().map(this.contextDocument, clazz, this.configuration);
    }

    @Override
    public Object root() {
        return this.rootDocument;
    }

    @Override
    public Configuration configuration() {
        return this.configuration;
    }
}

