/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.org.apache.commons.math3.distribution;

import ia.sh.org.apache.commons.math3.random.RandomGenerator;
import ia.sh.org.apache.commons.math3.util.FastMath;
import ia.sh.org.apache.commons.math3.util.Precision;

final class BetaDistribution$ChengBetaSampler {
    private BetaDistribution$ChengBetaSampler() {
    }

    static double sample(RandomGenerator randomGenerator, double d2, double d3) {
        double d4 = FastMath.min(d2, d3);
        double d5 = FastMath.max(d2, d3);
        if (d4 > 1.0) {
            return BetaDistribution$ChengBetaSampler.algorithmBB(randomGenerator, d2, d4, d5);
        }
        return BetaDistribution$ChengBetaSampler.algorithmBC(randomGenerator, d2, d5, d4);
    }

    private static double algorithmBB(RandomGenerator randomGenerator, double d2, double d3, double d4) {
        double d5;
        double d6;
        double d7;
        double d8;
        double d9;
        double d10;
        double d11;
        double d12;
        double d13 = d3 + d4;
        double d14 = FastMath.sqrt((d13 - 2.0) / (2.0 * d3 * d4 - d13));
        double d15 = d3 + 1.0 / d14;
        do {
            d9 = randomGenerator.nextDouble();
            d6 = randomGenerator.nextDouble();
        } while (!((d12 = d3 + (d11 = d15 * (d10 = d14 * (FastMath.log(d9) - FastMath.log1p(-d9))) - 1.3862944) - (d8 = d3 * FastMath.exp(d10))) + 2.609438 >= 5.0 * (d7 = d9 * d9 * d6)) && !(d12 >= (d5 = FastMath.log(d7))) && d11 + d13 * (FastMath.log(d13) - FastMath.log(d4 + d8)) < d5);
        d8 = FastMath.min(d8, Double.MAX_VALUE);
        return Precision.equals(d3, d2) ? d8 / (d4 + d8) : d4 / (d4 + d8);
    }

    private static double algorithmBC(RandomGenerator randomGenerator, double d2, double d3, double d4) {
        double d5;
        double d6 = d3 + d4;
        double d7 = 1.0 / d4;
        double d8 = 1.0 + d3 - d4;
        double d9 = d8 * (0.0138889 + 0.0416667 * d4) / (d3 * d7 - 0.777778);
        double d10 = 0.25 + (0.5 + 0.25 / d8) * d4;
        while (true) {
            double d11;
            double d12 = randomGenerator.nextDouble();
            double d13 = randomGenerator.nextDouble();
            double d14 = d12 * d13;
            double d15 = d12 * d14;
            if (d12 < 0.5) {
                if (0.25 * d13 + d15 - d14 >= d9) {
                    continue;
                }
            } else {
                if (d15 <= 0.25) {
                    d11 = d7 * (FastMath.log(d12) - FastMath.log1p(-d12));
                    d5 = d3 * FastMath.exp(d11);
                    break;
                }
                if (d15 >= d10) continue;
            }
            d11 = d7 * (FastMath.log(d12) - FastMath.log1p(-d12));
            d5 = d3 * FastMath.exp(d11);
            if (d6 * (FastMath.log(d6) - FastMath.log(d4 + d5) + d11) - 1.3862944 >= FastMath.log(d15)) break;
        }
        d5 = FastMath.min(d5, Double.MAX_VALUE);
        return Precision.equals(d3, d2) ? d5 / (d4 + d5) : d4 / (d4 + d5);
    }
}

