/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.org.apache.commons.math3.distribution;

import ia.sh.org.apache.commons.math3.distribution.AbstractIntegerDistribution;
import ia.sh.org.apache.commons.math3.exception.NumberIsTooLargeException;
import ia.sh.org.apache.commons.math3.exception.util.Localizable;
import ia.sh.org.apache.commons.math3.exception.util.LocalizedFormats;
import ia.sh.org.apache.commons.math3.random.RandomGenerator;
import ia.sh.org.apache.commons.math3.random.Well19937c;

public class UniformIntegerDistribution
extends AbstractIntegerDistribution {
    private static final long serialVersionUID = 20120109L;
    private final int lower;
    private final int upper;

    public UniformIntegerDistribution(int n2, int n3) {
        this(new Well19937c(), n2, n3);
    }

    public UniformIntegerDistribution(RandomGenerator randomGenerator, int n2, int n3) {
        super(randomGenerator);
        if (n2 > n3) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.LOWER_BOUND_NOT_BELOW_UPPER_BOUND, (Number)n2, n3, true);
        }
        this.lower = n2;
        this.upper = n3;
    }

    public double probability(int n2) {
        if (n2 < this.lower || n2 > this.upper) {
            return 0.0;
        }
        return 1.0 / (double)(this.upper - this.lower + 1);
    }

    public double cumulativeProbability(int n2) {
        if (n2 < this.lower) {
            return 0.0;
        }
        if (n2 > this.upper) {
            return 1.0;
        }
        return ((double)(n2 - this.lower) + 1.0) / ((double)(this.upper - this.lower) + 1.0);
    }

    public double getNumericalMean() {
        return 0.5 * (double)(this.lower + this.upper);
    }

    public double getNumericalVariance() {
        double d2 = this.upper - this.lower + 1;
        return (d2 * d2 - 1.0) / 12.0;
    }

    public int getSupportLowerBound() {
        return this.lower;
    }

    public int getSupportUpperBound() {
        return this.upper;
    }

    public boolean isSupportConnected() {
        return true;
    }

    public int sample() {
        int n2 = this.upper - this.lower + 1;
        if (n2 <= 0) {
            int n3;
            while ((n3 = this.random.nextInt()) < this.lower || n3 > this.upper) {
            }
            return n3;
        }
        return this.lower + this.random.nextInt(n2);
    }
}

