/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.com.jayway.jsonpath;

import ia.sh.com.jayway.jsonpath.Configuration;
import ia.sh.com.jayway.jsonpath.DocumentContext;
import ia.sh.com.jayway.jsonpath.JsonPathException;
import ia.sh.com.jayway.jsonpath.MapFunction;
import ia.sh.com.jayway.jsonpath.Option;
import ia.sh.com.jayway.jsonpath.ParseContext;
import ia.sh.com.jayway.jsonpath.PathNotFoundException;
import ia.sh.com.jayway.jsonpath.Predicate;
import ia.sh.com.jayway.jsonpath.internal.EvaluationContext;
import ia.sh.com.jayway.jsonpath.internal.ParseContextImpl;
import ia.sh.com.jayway.jsonpath.internal.Path;
import ia.sh.com.jayway.jsonpath.internal.PathRef;
import ia.sh.com.jayway.jsonpath.internal.Utils;
import ia.sh.com.jayway.jsonpath.internal.path.PathCompiler;
import ia.sh.com.jayway.jsonpath.spi.json.JsonProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;

public class JsonPath {
    private final Path path;

    private JsonPath(String string, Predicate[] predicateArray) {
        Utils.notNull(string, "path can not be null");
        this.path = PathCompiler.compile(string, predicateArray);
    }

    public String getPath() {
        return this.path.toString();
    }

    public static boolean isPathDefinite(String string) {
        return JsonPath.compile(string, new Predicate[0]).isDefinite();
    }

    public boolean isDefinite() {
        return this.path.isDefinite();
    }

    public Object read(Object object) {
        return this.read(object, Configuration.defaultConfiguration());
    }

    public Object read(Object object, Configuration configuration) {
        boolean bl2 = configuration.containsOption(Option.AS_PATH_LIST);
        boolean bl3 = configuration.containsOption(Option.ALWAYS_RETURN_LIST);
        boolean bl4 = configuration.containsOption(Option.SUPPRESS_EXCEPTIONS);
        if (this.path.isFunctionPath()) {
            if (bl2 || bl3) {
                if (bl4) {
                    return this.path.isDefinite() ? null : configuration.jsonProvider().createArray();
                }
                throw new JsonPathException("Options " + (Object)((Object)Option.AS_PATH_LIST) + " and " + (Object)((Object)Option.ALWAYS_RETURN_LIST) + " are not allowed when using path functions!");
            }
            EvaluationContext evaluationContext = this.path.evaluate(object, object, configuration);
            if (bl4 && evaluationContext.getPathList().isEmpty()) {
                return this.path.isDefinite() ? null : configuration.jsonProvider().createArray();
            }
            return evaluationContext.getValue(true);
        }
        if (bl2) {
            EvaluationContext evaluationContext = this.path.evaluate(object, object, configuration);
            if (bl4 && evaluationContext.getPathList().isEmpty()) {
                return configuration.jsonProvider().createArray();
            }
            return evaluationContext.getPath();
        }
        EvaluationContext evaluationContext = this.path.evaluate(object, object, configuration);
        if (bl4 && evaluationContext.getPathList().isEmpty()) {
            if (bl3) {
                return configuration.jsonProvider().createArray();
            }
            return this.path.isDefinite() ? null : configuration.jsonProvider().createArray();
        }
        Object object2 = evaluationContext.getValue(false);
        if (bl3 && this.path.isDefinite()) {
            Object object3 = configuration.jsonProvider().createArray();
            configuration.jsonProvider().setArrayIndex(object3, 0, object2);
            return object3;
        }
        return object2;
    }

    public Object set(Object object, Object object2, Configuration configuration) {
        Utils.notNull(object, "json can not be null");
        Utils.notNull(configuration, "configuration can not be null");
        EvaluationContext evaluationContext = this.path.evaluate(object, object, configuration, true);
        if (evaluationContext.getPathList().isEmpty()) {
            boolean bl2 = configuration.containsOption(Option.SUPPRESS_EXCEPTIONS);
            if (bl2) {
                return this.handleMissingPathInContext(configuration);
            }
            throw new PathNotFoundException();
        }
        for (PathRef pathRef : evaluationContext.updateOperations()) {
            pathRef.set(object2, configuration);
        }
        return this.resultByConfiguration(object, configuration, evaluationContext);
    }

    public Object map(Object object, MapFunction mapFunction, Configuration configuration) {
        Utils.notNull(object, "json can not be null");
        Utils.notNull(configuration, "configuration can not be null");
        Utils.notNull(mapFunction, "mapFunction can not be null");
        EvaluationContext evaluationContext = this.path.evaluate(object, object, configuration, true);
        if (evaluationContext.getPathList().isEmpty()) {
            boolean bl2 = configuration.containsOption(Option.SUPPRESS_EXCEPTIONS);
            if (bl2) {
                return this.handleMissingPathInContext(configuration);
            }
            throw new PathNotFoundException();
        }
        for (PathRef pathRef : evaluationContext.updateOperations()) {
            pathRef.convert(mapFunction, configuration);
        }
        return this.resultByConfiguration(object, configuration, evaluationContext);
    }

    public Object delete(Object object, Configuration configuration) {
        Utils.notNull(object, "json can not be null");
        Utils.notNull(configuration, "configuration can not be null");
        EvaluationContext evaluationContext = this.path.evaluate(object, object, configuration, true);
        if (evaluationContext.getPathList().isEmpty()) {
            boolean bl2 = configuration.containsOption(Option.SUPPRESS_EXCEPTIONS);
            if (bl2) {
                return this.handleMissingPathInContext(configuration);
            }
            throw new PathNotFoundException();
        }
        for (PathRef pathRef : evaluationContext.updateOperations()) {
            pathRef.delete(configuration);
        }
        return this.resultByConfiguration(object, configuration, evaluationContext);
    }

    public Object add(Object object, Object object2, Configuration configuration) {
        Utils.notNull(object, "json can not be null");
        Utils.notNull(configuration, "configuration can not be null");
        EvaluationContext evaluationContext = this.path.evaluate(object, object, configuration, true);
        if (evaluationContext.getPathList().isEmpty()) {
            boolean bl2 = configuration.containsOption(Option.SUPPRESS_EXCEPTIONS);
            if (bl2) {
                return this.handleMissingPathInContext(configuration);
            }
            throw new PathNotFoundException();
        }
        for (PathRef pathRef : evaluationContext.updateOperations()) {
            pathRef.add(object2, configuration);
        }
        return this.resultByConfiguration(object, configuration, evaluationContext);
    }

    public Object put(Object object, String string, Object object2, Configuration configuration) {
        Utils.notNull(object, "json can not be null");
        Utils.notEmpty(string, "key can not be null or empty");
        Utils.notNull(configuration, "configuration can not be null");
        EvaluationContext evaluationContext = this.path.evaluate(object, object, configuration, true);
        if (evaluationContext.getPathList().isEmpty()) {
            boolean bl2 = configuration.containsOption(Option.SUPPRESS_EXCEPTIONS);
            if (bl2) {
                return this.handleMissingPathInContext(configuration);
            }
            throw new PathNotFoundException();
        }
        for (PathRef pathRef : evaluationContext.updateOperations()) {
            pathRef.put(string, object2, configuration);
        }
        return this.resultByConfiguration(object, configuration, evaluationContext);
    }

    public Object renameKey(Object object, String string, String string2, Configuration configuration) {
        Utils.notNull(object, "json can not be null");
        Utils.notEmpty(string2, "newKeyName can not be null or empty");
        Utils.notNull(configuration, "configuration can not be null");
        EvaluationContext evaluationContext = this.path.evaluate(object, object, configuration, true);
        for (PathRef pathRef : evaluationContext.updateOperations()) {
            boolean bl2 = configuration.containsOption(Option.SUPPRESS_EXCEPTIONS);
            try {
                pathRef.renameKey(string, string2, configuration);
            }
            catch (RuntimeException runtimeException) {
                if (bl2) continue;
                throw runtimeException;
            }
        }
        return this.resultByConfiguration(object, configuration, evaluationContext);
    }

    public Object read(String string) {
        return this.read(string, Configuration.defaultConfiguration());
    }

    public Object read(String string, Configuration configuration) {
        Utils.notEmpty(string, "json can not be null or empty");
        Utils.notNull(configuration, "jsonProvider can not be null");
        return this.read(configuration.jsonProvider().parse(string), configuration);
    }

    public Object read(URL uRL) {
        return this.read(uRL, Configuration.defaultConfiguration());
    }

    public Object read(File file) {
        return this.read(file, Configuration.defaultConfiguration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object read(File file, Configuration configuration) {
        Object object;
        Utils.notNull(file, "json file can not be null");
        Utils.isTrue(file.exists(), "json file does not exist");
        Utils.notNull(configuration, "jsonProvider can not be null");
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            object = this.read(fileInputStream, configuration);
        }
        catch (Throwable throwable) {
            Utils.closeQuietly(fileInputStream);
            throw throwable;
        }
        Utils.closeQuietly(fileInputStream);
        return object;
    }

    public Object read(InputStream inputStream) {
        return this.read(inputStream, Configuration.defaultConfiguration());
    }

    public Object read(InputStream inputStream, Configuration configuration) {
        Utils.notNull(inputStream, "json input stream can not be null");
        Utils.notNull(configuration, "configuration can not be null");
        return this.read(inputStream, "UTF-8", configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object read(InputStream inputStream, String string, Configuration configuration) {
        Utils.notNull(inputStream, "json input stream can not be null");
        Utils.notNull(string, "charset can not be null");
        Utils.notNull(configuration, "configuration can not be null");
        try {
            Object object = this.read(configuration.jsonProvider().parse(inputStream, string), configuration);
            return object;
        }
        finally {
            Utils.closeQuietly(inputStream);
        }
    }

    public static JsonPath compile(String string, Predicate ... predicateArray) {
        Utils.notEmpty(string, "json can not be null or empty");
        return new JsonPath(string, predicateArray);
    }

    public static Object read(Object object, String string, Predicate ... predicateArray) {
        return JsonPath.parse(object).read(string, predicateArray);
    }

    public static Object read(String string, String string2, Predicate ... predicateArray) {
        return new ParseContextImpl().parse(string).read(string2, predicateArray);
    }

    @Deprecated
    public static Object read(URL uRL, String string, Predicate ... predicateArray) {
        return new ParseContextImpl().parse(uRL).read(string, predicateArray);
    }

    public static Object read(File file, String string, Predicate ... predicateArray) {
        return new ParseContextImpl().parse(file).read(string, predicateArray);
    }

    public static Object read(InputStream inputStream, String string, Predicate ... predicateArray) {
        return new ParseContextImpl().parse(inputStream).read(string, predicateArray);
    }

    public static ParseContext using(Configuration configuration) {
        return new ParseContextImpl(configuration);
    }

    @Deprecated
    public static ParseContext using(JsonProvider jsonProvider) {
        return new ParseContextImpl(Configuration.builder().jsonProvider(jsonProvider).build());
    }

    public static DocumentContext parse(Object object) {
        return new ParseContextImpl().parse(object);
    }

    public static DocumentContext parse(String string) {
        return new ParseContextImpl().parse(string);
    }

    public static DocumentContext parse(InputStream inputStream) {
        return new ParseContextImpl().parse(inputStream);
    }

    public static DocumentContext parse(File file) {
        return new ParseContextImpl().parse(file);
    }

    @Deprecated
    public static DocumentContext parse(URL uRL) {
        return new ParseContextImpl().parse(uRL);
    }

    public static DocumentContext parse(Object object, Configuration configuration) {
        return new ParseContextImpl(configuration).parse(object);
    }

    public static DocumentContext parse(String string, Configuration configuration) {
        return new ParseContextImpl(configuration).parse(string);
    }

    public static DocumentContext parse(InputStream inputStream, Configuration configuration) {
        return new ParseContextImpl(configuration).parse(inputStream);
    }

    public static DocumentContext parse(File file, Configuration configuration) {
        return new ParseContextImpl(configuration).parse(file);
    }

    @Deprecated
    public static DocumentContext parse(URL uRL, Configuration configuration) {
        return new ParseContextImpl(configuration).parse(uRL);
    }

    private Object resultByConfiguration(Object object, Configuration configuration, EvaluationContext evaluationContext) {
        if (configuration.containsOption(Option.AS_PATH_LIST)) {
            return evaluationContext.getPathList();
        }
        return object;
    }

    private Object handleMissingPathInContext(Configuration configuration) {
        boolean bl2 = configuration.containsOption(Option.AS_PATH_LIST);
        boolean bl3 = configuration.containsOption(Option.ALWAYS_RETURN_LIST);
        if (bl2) {
            return configuration.jsonProvider().createArray();
        }
        if (bl3) {
            return configuration.jsonProvider().createArray();
        }
        return this.path.isDefinite() ? null : configuration.jsonProvider().createArray();
    }
}

