/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.com.jayway.jsonpath.internal;

import ia.sh.com.jayway.jsonpath.JsonPathException;
import java.io.Closeable;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Iterator;

public final class Utils {
    public static String join(String string, String string2, Iterable iterable) {
        Iterator iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2).append(iterator.next()).append(string2);
        while (iterator.hasNext()) {
            stringBuilder.append(string).append(string2).append(iterator.next()).append(string2);
        }
        return stringBuilder.toString();
    }

    public static String join(String string, Iterable iterable) {
        return Utils.join(string, "", iterable);
    }

    public static String concat(CharSequence ... charSequenceArray) {
        if (charSequenceArray.length == 0) {
            return "";
        }
        if (charSequenceArray.length == 1) {
            return charSequenceArray[0].toString();
        }
        int n2 = 0;
        int n3 = -1;
        for (int i2 = 0; i2 < charSequenceArray.length; ++i2) {
            CharSequence[] charSequenceArray2 = charSequenceArray[i2];
            int n4 = charSequenceArray2.length();
            n2 += n4;
            if (n3 == -2 || n4 <= 0) continue;
            n3 = n3 == -1 ? i2 : -2;
        }
        if (n2 == 0) {
            return "";
        }
        if (n3 > 0) {
            return charSequenceArray[n3].toString();
        }
        StringBuilder stringBuilder = new StringBuilder(n2);
        for (CharSequence charSequence : charSequenceArray) {
            stringBuilder.append(charSequence);
        }
        return stringBuilder.toString();
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String escape(String string, boolean bl2) {
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        StringWriter stringWriter = new StringWriter(n2 * 2);
        block13: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 > '\u0fff') {
                stringWriter.write("\\u" + Utils.hex(c2));
                continue;
            }
            if (c2 > '\u00ff') {
                stringWriter.write("\\u0" + Utils.hex(c2));
                continue;
            }
            if (c2 > '\u007f') {
                stringWriter.write("\\u00" + Utils.hex(c2));
                continue;
            }
            if (c2 < ' ') {
                switch (c2) {
                    case '\b': {
                        stringWriter.write(92);
                        stringWriter.write(98);
                        break;
                    }
                    case '\n': {
                        stringWriter.write(92);
                        stringWriter.write(110);
                        break;
                    }
                    case '\t': {
                        stringWriter.write(92);
                        stringWriter.write(116);
                        break;
                    }
                    case '\f': {
                        stringWriter.write(92);
                        stringWriter.write(102);
                        break;
                    }
                    case '\r': {
                        stringWriter.write(92);
                        stringWriter.write(114);
                        break;
                    }
                    default: {
                        if (c2 > '\u000f') {
                            stringWriter.write("\\u00" + Utils.hex(c2));
                            break;
                        }
                        stringWriter.write("\\u000" + Utils.hex(c2));
                        break;
                    }
                }
                continue;
            }
            switch (c2) {
                case '\'': {
                    if (bl2) {
                        stringWriter.write(92);
                    }
                    stringWriter.write(39);
                    continue block13;
                }
                case '\"': {
                    stringWriter.write(92);
                    stringWriter.write(34);
                    continue block13;
                }
                case '\\': {
                    stringWriter.write(92);
                    stringWriter.write(92);
                    continue block13;
                }
                case '/': {
                    stringWriter.write(92);
                    stringWriter.write(47);
                    continue block13;
                }
                default: {
                    stringWriter.write(c2);
                }
            }
        }
        return stringWriter.toString();
    }

    public static String unescape(String string) {
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        StringWriter stringWriter = new StringWriter(n2);
        StringBuilder stringBuilder = new StringBuilder(4);
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (bl3) {
                stringBuilder.append(c2);
                if (stringBuilder.length() != 4) continue;
                try {
                    int n3 = Integer.parseInt(stringBuilder.toString(), 16);
                    stringWriter.write((char)n3);
                    stringBuilder.setLength(0);
                    bl3 = false;
                    bl2 = false;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new JsonPathException("Unable to parse unicode value: " + stringBuilder, numberFormatException);
                }
            }
            if (bl2) {
                bl2 = false;
                switch (c2) {
                    case '\\': {
                        stringWriter.write(92);
                        break;
                    }
                    case '\'': {
                        stringWriter.write(39);
                        break;
                    }
                    case '\"': {
                        stringWriter.write(34);
                        break;
                    }
                    case 'r': {
                        stringWriter.write(13);
                        break;
                    }
                    case 'f': {
                        stringWriter.write(12);
                        break;
                    }
                    case 't': {
                        stringWriter.write(9);
                        break;
                    }
                    case 'n': {
                        stringWriter.write(10);
                        break;
                    }
                    case 'b': {
                        stringWriter.write(8);
                        break;
                    }
                    case 'u': {
                        bl3 = true;
                        break;
                    }
                    default: {
                        stringWriter.write(c2);
                        break;
                    }
                }
                continue;
            }
            if (c2 == '\\') {
                bl2 = true;
                continue;
            }
            stringWriter.write(c2);
        }
        if (bl2) {
            stringWriter.write(92);
        }
        return stringWriter.toString();
    }

    public static String hex(char c2) {
        return Integer.toHexString(c2).toUpperCase();
    }

    public static boolean isEmpty(CharSequence charSequence) {
        return charSequence == null || charSequence.length() == 0;
    }

    static int indexOf(CharSequence charSequence, CharSequence charSequence2, int n2) {
        return charSequence.toString().indexOf(charSequence2.toString(), n2);
    }

    public static Object notNull(Object object, String string) {
        if (object == null) {
            throw new IllegalArgumentException(string);
        }
        return object;
    }

    public static Object notNull(Object object, String string, Object ... objectArray) {
        if (object == null) {
            throw new IllegalArgumentException(String.format(string, objectArray));
        }
        return object;
    }

    public static void isTrue(boolean bl2, String string) {
        if (!bl2) {
            throw new IllegalArgumentException(string);
        }
    }

    public static void onlyOneIsTrue(String string, boolean ... blArray) {
        if (!Utils.onlyOneIsTrueNonThrow(blArray)) {
            throw new IllegalArgumentException(string);
        }
    }

    public static boolean onlyOneIsTrueNonThrow(boolean ... blArray) {
        int n2 = 0;
        for (boolean bl2 : blArray) {
            if (!bl2 || ++n2 <= 1) continue;
            return false;
        }
        return 1 == n2;
    }

    public static CharSequence notEmpty(CharSequence charSequence, String string) {
        if (charSequence == null || charSequence.length() == 0) {
            throw new IllegalArgumentException(string);
        }
        return charSequence;
    }

    public static byte[] notEmpty(byte[] byArray, String string) {
        if (byArray == null || byArray.length == 0) {
            throw new IllegalArgumentException(string);
        }
        return byArray;
    }

    public static CharSequence notEmpty(CharSequence charSequence, String string, Object ... objectArray) {
        if (charSequence == null || charSequence.length() == 0) {
            throw new IllegalArgumentException(String.format(string, objectArray));
        }
        return charSequence;
    }

    public static String toString(Object object) {
        if (null == object) {
            return null;
        }
        return object.toString();
    }

    private Utils() {
    }
}

