/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.net.minidev.json.parser;

import ia.sh.net.minidev.json.JSONValue;
import ia.sh.net.minidev.json.parser.JSONParserByteArray;
import ia.sh.net.minidev.json.parser.JSONParserInputStream;
import ia.sh.net.minidev.json.parser.JSONParserReader;
import ia.sh.net.minidev.json.parser.JSONParserString;
import ia.sh.net.minidev.json.writer.JsonReaderI;
import java.io.InputStream;
import java.io.Reader;

public class JSONParser {
    public static final int ACCEPT_SIMPLE_QUOTE = 1;
    public static final int ACCEPT_NON_QUOTE = 2;
    public static final int ACCEPT_NAN = 4;
    public static final int IGNORE_CONTROL_CHAR = 8;
    public static final int USE_INTEGER_STORAGE = 16;
    public static final int ACCEPT_LEADING_ZERO = 32;
    public static final int ACCEPT_USELESS_COMMA = 64;
    public static final int USE_HI_PRECISION_FLOAT = 128;
    public static final int ACCEPT_TAILLING_DATA = 256;
    public static final int ACCEPT_TAILLING_SPACE = 512;
    public static final int REJECT_127_CHAR = 1024;
    public static final int BIG_DIGIT_UNRESTRICTED = 2048;
    public static final int MODE_PERMISSIVE = -1;
    public static final int MODE_RFC4627 = 656;
    public static final int MODE_JSON_SIMPLE = 4032;
    public static final int MODE_STRICTEST = 1168;
    public static int DEFAULT_PERMISSIVE_MODE = System.getProperty("JSON_SMART_SIMPLE") != null ? 4032 : -1;
    private int mode;
    private JSONParserInputStream pBinStream;
    private JSONParserByteArray pBytes;
    private JSONParserReader pStream;
    private JSONParserString pString;

    private JSONParserReader getPStream() {
        if (this.pStream == null) {
            this.pStream = new JSONParserReader(this.mode);
        }
        return this.pStream;
    }

    private JSONParserInputStream getPBinStream() {
        if (this.pBinStream == null) {
            this.pBinStream = new JSONParserInputStream(this.mode);
        }
        return this.pBinStream;
    }

    private JSONParserString getPString() {
        if (this.pString == null) {
            this.pString = new JSONParserString(this.mode);
        }
        return this.pString;
    }

    private JSONParserByteArray getPBytes() {
        if (this.pBytes == null) {
            this.pBytes = new JSONParserByteArray(this.mode);
        }
        return this.pBytes;
    }

    public JSONParser() {
        this.mode = DEFAULT_PERMISSIVE_MODE;
    }

    public JSONParser(int n2) {
        this.mode = n2;
    }

    public Object parse(byte[] byArray) {
        return this.getPBytes().parse(byArray);
    }

    public Object parse(byte[] byArray, JsonReaderI jsonReaderI) {
        return this.getPBytes().parse(byArray, jsonReaderI);
    }

    public Object parse(byte[] byArray, Class clazz) {
        return this.getPBytes().parse(byArray, JSONValue.defaultReader.getMapper(clazz));
    }

    public Object parse(InputStream inputStream) {
        return this.getPBinStream().parse(inputStream);
    }

    public Object parse(InputStream inputStream, JsonReaderI jsonReaderI) {
        return this.getPBinStream().parse(inputStream, jsonReaderI);
    }

    public Object parse(InputStream inputStream, Class clazz) {
        return this.getPBinStream().parse(inputStream, JSONValue.defaultReader.getMapper(clazz));
    }

    public Object parse(Reader reader) {
        return this.getPStream().parse(reader);
    }

    public Object parse(Reader reader, JsonReaderI jsonReaderI) {
        return this.getPStream().parse(reader, jsonReaderI);
    }

    public Object parse(Reader reader, Class clazz) {
        return this.getPStream().parse(reader, JSONValue.defaultReader.getMapper(clazz));
    }

    public Object parse(String string) {
        return this.getPString().parse(string);
    }

    public Object parse(String string, JsonReaderI jsonReaderI) {
        return this.getPString().parse(string, jsonReaderI);
    }

    public Object parse(String string, Class clazz) {
        return this.getPString().parse(string, JSONValue.defaultReader.getMapper(clazz));
    }
}

