/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.com.jayway.jsonpath.internal.path;

import ia.sh.com.jayway.jsonpath.internal.PathRef;
import ia.sh.com.jayway.jsonpath.internal.path.ArrayPathToken;
import ia.sh.com.jayway.jsonpath.internal.path.ArraySliceOperation;
import ia.sh.com.jayway.jsonpath.internal.path.EvaluationContextImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArraySliceToken
extends ArrayPathToken {
    private static final Logger logger = LoggerFactory.getLogger(ArraySliceToken.class);
    private final ArraySliceOperation operation;

    ArraySliceToken(ArraySliceOperation arraySliceOperation) {
        this.operation = arraySliceOperation;
    }

    @Override
    public void evaluate(String string, PathRef pathRef, Object object, EvaluationContextImpl evaluationContextImpl) {
        if (!this.checkArrayModel(string, object, evaluationContextImpl)) {
            return;
        }
        switch (this.operation.operation()) {
            case SLICE_FROM: {
                this.sliceFrom(string, pathRef, object, evaluationContextImpl);
                break;
            }
            case SLICE_BETWEEN: {
                this.sliceBetween(string, pathRef, object, evaluationContextImpl);
                break;
            }
            case SLICE_TO: {
                this.sliceTo(string, pathRef, object, evaluationContextImpl);
            }
        }
    }

    private void sliceFrom(String string, PathRef pathRef, Object object, EvaluationContextImpl evaluationContextImpl) {
        int n2 = evaluationContextImpl.jsonProvider().length(object);
        int n3 = this.operation.from();
        if (n3 < 0) {
            n3 = n2 + n3;
        }
        n3 = Math.max(0, n3);
        logger.debug("Slice from index on array with length: {}. From index: {} to: {}. Input: {}", new Object[]{n2, n3, n2 - 1, this.toString()});
        if (n2 == 0 || n3 >= n2) {
            return;
        }
        for (int i2 = n3; i2 < n2; ++i2) {
            this.handleArrayIndex(i2, string, object, evaluationContextImpl);
        }
    }

    private void sliceBetween(String string, PathRef pathRef, Object object, EvaluationContextImpl evaluationContextImpl) {
        int n2 = evaluationContextImpl.jsonProvider().length(object);
        int n3 = this.operation.from();
        int n4 = this.operation.to();
        if (n3 >= (n4 = Math.min(n2, n4)) || n2 == 0) {
            return;
        }
        logger.debug("Slice between indexes on array with length: {}. From index: {} to: {}. Input: {}", new Object[]{n2, n3, n4, this.toString()});
        for (int i2 = n3; i2 < n4; ++i2) {
            this.handleArrayIndex(i2, string, object, evaluationContextImpl);
        }
    }

    private void sliceTo(String string, PathRef pathRef, Object object, EvaluationContextImpl evaluationContextImpl) {
        int n2 = evaluationContextImpl.jsonProvider().length(object);
        if (n2 == 0) {
            return;
        }
        int n3 = this.operation.to();
        if (n3 < 0) {
            n3 = n2 + n3;
        }
        n3 = Math.min(n2, n3);
        logger.debug("Slice to index on array with length: {}. From index: 0 to: {}. Input: {}", new Object[]{n2, n3, this.toString()});
        for (int i2 = 0; i2 < n3; ++i2) {
            this.handleArrayIndex(i2, string, object, evaluationContextImpl);
        }
    }

    @Override
    public String getPathFragment() {
        return this.operation.toString();
    }

    @Override
    public boolean isTokenDefinite() {
        return false;
    }
}

