/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.com.jayway.jsonpath.internal.path;

import ia.sh.com.jayway.jsonpath.Configuration;
import ia.sh.com.jayway.jsonpath.internal.EvaluationAbortException;
import ia.sh.com.jayway.jsonpath.internal.EvaluationContext;
import ia.sh.com.jayway.jsonpath.internal.Path;
import ia.sh.com.jayway.jsonpath.internal.PathRef;
import ia.sh.com.jayway.jsonpath.internal.function.ParamType;
import ia.sh.com.jayway.jsonpath.internal.function.Parameter;
import ia.sh.com.jayway.jsonpath.internal.path.EvaluationContextImpl;
import ia.sh.com.jayway.jsonpath.internal.path.FunctionPathToken;
import ia.sh.com.jayway.jsonpath.internal.path.PathToken;
import ia.sh.com.jayway.jsonpath.internal.path.RootPathToken;
import ia.sh.com.jayway.jsonpath.internal.path.ScanPathToken;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompiledPath
implements Path {
    private static final Logger logger = LoggerFactory.getLogger(CompiledPath.class);
    private final RootPathToken root;
    private final boolean isRootPath;

    public CompiledPath(RootPathToken rootPathToken, boolean bl2) {
        this.root = this.invertScannerFunctionRelationship(rootPathToken);
        this.isRootPath = bl2;
    }

    @Override
    public boolean isRootPath() {
        return this.isRootPath;
    }

    private RootPathToken invertScannerFunctionRelationship(RootPathToken rootPathToken) {
        if (rootPathToken.isFunctionPath() && rootPathToken.next() instanceof ScanPathToken) {
            PathToken pathToken = rootPathToken;
            PathToken pathToken2 = null;
            while (null != (pathToken = pathToken.next()) && !(pathToken instanceof FunctionPathToken)) {
                pathToken2 = pathToken;
            }
            if (pathToken instanceof FunctionPathToken) {
                pathToken2.setNext(null);
                rootPathToken.setTail(pathToken2);
                Parameter parameter = new Parameter();
                parameter.setPath(new CompiledPath(rootPathToken, true));
                parameter.setType(ParamType.PATH);
                ((FunctionPathToken)pathToken).setParameters(Arrays.asList(parameter));
                RootPathToken rootPathToken2 = new RootPathToken('$');
                rootPathToken2.setTail(pathToken);
                rootPathToken2.setNext(pathToken);
                return rootPathToken2;
            }
        }
        return rootPathToken;
    }

    @Override
    public EvaluationContext evaluate(Object object, Object object2, Configuration configuration, boolean bl2) {
        if (logger.isDebugEnabled()) {
            logger.debug("Evaluating path: {}", (Object)this.toString());
        }
        EvaluationContextImpl evaluationContextImpl = new EvaluationContextImpl(this, object2, configuration, bl2);
        try {
            PathRef pathRef = evaluationContextImpl.forUpdate() ? PathRef.createRoot(object2) : PathRef.NO_OP;
            this.root.evaluate("", pathRef, object, evaluationContextImpl);
        }
        catch (EvaluationAbortException evaluationAbortException) {
            // empty catch block
        }
        return evaluationContextImpl;
    }

    @Override
    public EvaluationContext evaluate(Object object, Object object2, Configuration configuration) {
        return this.evaluate(object, object2, configuration, false);
    }

    @Override
    public boolean isDefinite() {
        return this.root.isPathDefinite();
    }

    @Override
    public boolean isFunctionPath() {
        return this.root.isFunctionPath();
    }

    public String toString() {
        return this.root.toString();
    }

    public RootPathToken getRoot() {
        return this.root;
    }
}

