/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.com.jayway.jsonpath.internal.path;

import ia.sh.com.jayway.jsonpath.Option;
import ia.sh.com.jayway.jsonpath.PathNotFoundException;
import ia.sh.com.jayway.jsonpath.internal.PathRef;
import ia.sh.com.jayway.jsonpath.internal.Utils;
import ia.sh.com.jayway.jsonpath.internal.function.PathFunction;
import ia.sh.com.jayway.jsonpath.internal.path.EvaluationContextImpl;
import ia.sh.com.jayway.jsonpath.internal.path.PropertyPathToken;
import ia.sh.com.jayway.jsonpath.spi.json.JsonProvider;
import java.util.List;

public abstract class PathToken {
    private PathToken prev;
    private PathToken next;
    private Boolean definite = null;
    private Boolean upstreamDefinite = null;
    private int upstreamArrayIndex = -1;

    public void setUpstreamArrayIndex(int n2) {
        this.upstreamArrayIndex = n2;
    }

    PathToken appendTailToken(PathToken pathToken) {
        this.next = pathToken;
        this.next.prev = this;
        return pathToken;
    }

    /*
     * Enabled aggressive block sorting
     */
    void handleObjectProperty(String string, Object object, EvaluationContextImpl evaluationContextImpl, List list) {
        if (list.size() == 1) {
            PathRef pathRef;
            String string2 = (String)list.get(0);
            String string3 = Utils.concat(string, "['", string2, "']");
            Object object2 = PathToken.readObjectProperty(string2, object, evaluationContextImpl);
            if (object2 == JsonProvider.UNDEFINED) {
                assert (this instanceof PropertyPathToken) : "only PropertyPathToken is supported";
                if (this.isLeaf()) {
                    if (!evaluationContextImpl.options().contains((Object)Option.DEFAULT_PATH_LEAF_TO_NULL)) {
                        if (evaluationContextImpl.options().contains((Object)Option.SUPPRESS_EXCEPTIONS)) return;
                        if (evaluationContextImpl.options().contains((Object)Option.REQUIRE_PROPERTIES)) throw new PathNotFoundException("No results for path: " + string3);
                        return;
                    }
                    object2 = null;
                } else {
                    if (!this.isUpstreamDefinite() || !this.isTokenDefinite()) {
                        if (!evaluationContextImpl.options().contains((Object)Option.REQUIRE_PROPERTIES)) return;
                    }
                    if (!evaluationContextImpl.options().contains((Object)Option.SUPPRESS_EXCEPTIONS)) throw new PathNotFoundException("Missing property in path " + string3);
                    return;
                }
            }
            PathRef pathRef2 = pathRef = evaluationContextImpl.forUpdate() ? PathRef.create(object, string2) : PathRef.NO_OP;
            if (!this.isLeaf()) {
                this.next().evaluate(string3, pathRef, object2, evaluationContextImpl);
                return;
            }
            String string4 = "[" + String.valueOf(this.upstreamArrayIndex) + "]";
            if (!string4.equals("[-1]")) {
                if (!evaluationContextImpl.getRoot().getTail().prev().getPathFragment().equals(string4)) return;
            }
            evaluationContextImpl.addResult(string3, pathRef, object2);
            return;
        }
        String string5 = string + "[" + Utils.join(", ", "'", list) + "]";
        assert (this.isLeaf()) : "non-leaf multi props handled elsewhere";
        Object object3 = evaluationContextImpl.jsonProvider().createMap();
        for (String string6 : list) {
            Object object4;
            if (PathToken.hasProperty(string6, object, evaluationContextImpl)) {
                object4 = PathToken.readObjectProperty(string6, object, evaluationContextImpl);
                if (object4 == JsonProvider.UNDEFINED) {
                    if (!evaluationContextImpl.options().contains((Object)Option.DEFAULT_PATH_LEAF_TO_NULL)) continue;
                    object4 = null;
                }
            } else if (evaluationContextImpl.options().contains((Object)Option.DEFAULT_PATH_LEAF_TO_NULL)) {
                object4 = null;
            } else {
                if (!evaluationContextImpl.options().contains((Object)Option.REQUIRE_PROPERTIES)) continue;
                throw new PathNotFoundException("Missing property in path " + string5);
            }
            evaluationContextImpl.jsonProvider().setProperty(object3, string6, object4);
        }
        PathRef pathRef = evaluationContextImpl.forUpdate() ? PathRef.create(object, list) : PathRef.NO_OP;
        evaluationContextImpl.addResult(string5, pathRef, object3);
    }

    private static boolean hasProperty(String string, Object object, EvaluationContextImpl evaluationContextImpl) {
        return evaluationContextImpl.jsonProvider().getPropertyKeys(object).contains(string);
    }

    private static Object readObjectProperty(String string, Object object, EvaluationContextImpl evaluationContextImpl) {
        return evaluationContextImpl.jsonProvider().getMapValue(object, string);
    }

    protected void handleArrayIndex(int n2, String string, Object object, EvaluationContextImpl evaluationContextImpl) {
        String string2 = Utils.concat(string, "[", String.valueOf(n2), "]");
        PathRef pathRef = evaluationContextImpl.forUpdate() ? PathRef.create(object, n2) : PathRef.NO_OP;
        int n3 = n2 < 0 ? evaluationContextImpl.jsonProvider().length(object) + n2 : n2;
        try {
            Object object2 = evaluationContextImpl.jsonProvider().getArrayIndex(object, n3);
            if (this.isLeaf()) {
                evaluationContextImpl.addResult(string2, pathRef, object2);
            } else {
                this.next().evaluate(string2, pathRef, object2, evaluationContextImpl);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    PathToken prev() {
        return this.prev;
    }

    PathToken next() {
        if (this.isLeaf()) {
            throw new IllegalStateException("Current path token is a leaf");
        }
        return this.next;
    }

    boolean isLeaf() {
        return this.next == null;
    }

    boolean isRoot() {
        return this.prev == null;
    }

    boolean isUpstreamDefinite() {
        if (this.upstreamDefinite == null) {
            this.upstreamDefinite = this.isRoot() || this.prev.isTokenDefinite() && this.prev.isUpstreamDefinite();
        }
        return this.upstreamDefinite;
    }

    public int getTokenCount() {
        int n2 = 1;
        PathToken pathToken = this;
        while (!pathToken.isLeaf()) {
            pathToken = pathToken.next();
            ++n2;
        }
        return n2;
    }

    public boolean isPathDefinite() {
        if (this.definite != null) {
            return this.definite;
        }
        boolean bl2 = this.isTokenDefinite();
        if (bl2 && !this.isLeaf()) {
            bl2 = this.next.isPathDefinite();
        }
        this.definite = bl2;
        return bl2;
    }

    public String toString() {
        if (this.isLeaf()) {
            return this.getPathFragment();
        }
        return this.getPathFragment() + this.next().toString();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public void invoke(PathFunction pathFunction, String string, PathRef pathRef, Object object, EvaluationContextImpl evaluationContextImpl) {
        evaluationContextImpl.addResult(string, pathRef, pathFunction.invoke(string, pathRef, object, evaluationContextImpl, null));
    }

    public abstract void evaluate(String var1, PathRef var2, Object var3, EvaluationContextImpl var4);

    public abstract boolean isTokenDefinite();

    protected abstract String getPathFragment();

    public void setNext(PathToken pathToken) {
        this.next = pathToken;
    }

    public PathToken getNext() {
        return this.next;
    }
}

