/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.org.apache.commons.math3.analysis.solvers;

import ia.sh.org.apache.commons.math3.analysis.UnivariateFunction;
import ia.sh.org.apache.commons.math3.analysis.solvers.BaseUnivariateSolver;
import ia.sh.org.apache.commons.math3.analysis.solvers.UnivariateSolverUtils;
import ia.sh.org.apache.commons.math3.exception.MaxCountExceededException;
import ia.sh.org.apache.commons.math3.exception.TooManyEvaluationsException;
import ia.sh.org.apache.commons.math3.util.IntegerSequence$Incrementor;
import ia.sh.org.apache.commons.math3.util.MathUtils;

public abstract class BaseAbstractUnivariateSolver
implements BaseUnivariateSolver {
    private static final double DEFAULT_RELATIVE_ACCURACY = 1.0E-14;
    private static final double DEFAULT_FUNCTION_VALUE_ACCURACY = 1.0E-15;
    private final double functionValueAccuracy;
    private final double absoluteAccuracy;
    private final double relativeAccuracy;
    private IntegerSequence$Incrementor evaluations;
    private double searchMin;
    private double searchMax;
    private double searchStart;
    private UnivariateFunction function;

    protected BaseAbstractUnivariateSolver(double d2) {
        this(1.0E-14, d2, 1.0E-15);
    }

    protected BaseAbstractUnivariateSolver(double d2, double d3) {
        this(d2, d3, 1.0E-15);
    }

    protected BaseAbstractUnivariateSolver(double d2, double d3, double d4) {
        this.absoluteAccuracy = d3;
        this.relativeAccuracy = d2;
        this.functionValueAccuracy = d4;
        this.evaluations = IntegerSequence$Incrementor.create();
    }

    public int getMaxEvaluations() {
        return this.evaluations.getMaximalCount();
    }

    public int getEvaluations() {
        return this.evaluations.getCount();
    }

    public double getMin() {
        return this.searchMin;
    }

    public double getMax() {
        return this.searchMax;
    }

    public double getStartValue() {
        return this.searchStart;
    }

    public double getAbsoluteAccuracy() {
        return this.absoluteAccuracy;
    }

    public double getRelativeAccuracy() {
        return this.relativeAccuracy;
    }

    public double getFunctionValueAccuracy() {
        return this.functionValueAccuracy;
    }

    protected double computeObjectiveValue(double d2) {
        this.incrementEvaluationCount();
        return this.function.value(d2);
    }

    protected void setup(int n2, UnivariateFunction univariateFunction, double d2, double d3, double d4) {
        MathUtils.checkNotNull(univariateFunction);
        this.searchMin = d2;
        this.searchMax = d3;
        this.searchStart = d4;
        this.function = univariateFunction;
        this.evaluations = this.evaluations.withMaximalCount(n2).withStart(0);
    }

    public double solve(int n2, UnivariateFunction univariateFunction, double d2, double d3, double d4) {
        this.setup(n2, univariateFunction, d2, d3, d4);
        return this.doSolve();
    }

    public double solve(int n2, UnivariateFunction univariateFunction, double d2, double d3) {
        return this.solve(n2, univariateFunction, d2, d3, d2 + 0.5 * (d3 - d2));
    }

    public double solve(int n2, UnivariateFunction univariateFunction, double d2) {
        return this.solve(n2, univariateFunction, Double.NaN, Double.NaN, d2);
    }

    protected abstract double doSolve();

    protected boolean isBracketing(double d2, double d3) {
        return UnivariateSolverUtils.isBracketing(this.function, d2, d3);
    }

    protected boolean isSequence(double d2, double d3, double d4) {
        return UnivariateSolverUtils.isSequence(d2, d3, d4);
    }

    protected void verifyInterval(double d2, double d3) {
        UnivariateSolverUtils.verifyInterval(d2, d3);
    }

    protected void verifySequence(double d2, double d3, double d4) {
        UnivariateSolverUtils.verifySequence(d2, d3, d4);
    }

    protected void verifyBracketing(double d2, double d3) {
        UnivariateSolverUtils.verifyBracketing(this.function, d2, d3);
    }

    protected void incrementEvaluationCount() {
        try {
            this.evaluations.increment();
        }
        catch (MaxCountExceededException maxCountExceededException) {
            throw new TooManyEvaluationsException(maxCountExceededException.getMax());
        }
    }
}

